/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import java.io.IOException;
import org.gvsig.raster.impl.buffer.cache.Cache;
import org.gvsig.raster.impl.buffer.cache.InvalidPageNumberException;
import org.gvsig.raster.impl.buffer.cache.PageBuffer;

public class LRUAlgorithm {
    private Cache cache = null;

    public LRUAlgorithm(Cache cache) {
        this.cache = cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void cacheAccess(int line, boolean readOnly) throws InvalidPageNumberException {
        int pag = line >> this.cache.getBitsPag();
        if (this.cache.isInCache(pag)) {
            if (this.cache.getNumberInAccessPage() != pag) {
                this.loadPage(pag, readOnly);
            }
        } else {
            this.replacePage(pag + 1, readOnly, false);
            this.replacePage(pag, readOnly, true);
        }
    }

    private void loadPage(int nPag, boolean readOnly) throws InvalidPageNumberException {
        PageBuffer buf = this.cache.getPageBufferFromNumberRasterPage(nPag);
        int[] cacheGroupPage = this.cache.getNumberGroupFromNumberRasterPage(nPag);
        if (buf != null && cacheGroupPage != null) {
            this.cache.setAccessPage(buf, nPag);
            this.cache.updateLastAccess(cacheGroupPage[0]);
            this.cache.setZeroInLastAccess(cacheGroupPage[0], cacheGroupPage[1]);
            if (!readOnly) {
                this.cache.setModify(cacheGroupPage[0], cacheGroupPage[1]);
            }
        } else {
            throw new InvalidPageNumberException("");
        }
    }

    private void replacePage(int nPag, boolean readOnly, boolean n) {
        int group = nPag % this.cache.getNGroups();
        if (nPag >= this.cache.getNTotalPags()) {
            return;
        }
        if (this.insertInAHole(group, readOnly, nPag, n)) {
            return;
        }
        int posInGroupPageToReplace = this.cache.updateLastAccess(group);
        this.cache.setZeroInLastAccess(group, posInGroupPageToReplace);
        int rasterPageToReplace = this.cache.getRasterPageNumberInPosition(group, posInGroupPageToReplace);
        this.cache.setPageAsNotLoadInCache(rasterPageToReplace);
        if (this.cache.isModified(group, posInGroupPageToReplace)) {
            try {
                this.cache.savePage(group, posInGroupPageToReplace, rasterPageToReplace);
                this.cache.unsetModify(group, posInGroupPageToReplace);
            }
            catch (IOException e) {
                System.err.println("No se ha podido salvar la p\u00e1gina de cach\u00e9.");
                e.printStackTrace();
            }
        }
        this.cache.loadPage(group, posInGroupPageToReplace, nPag);
        this.cache.setRasterPageNumberInPosition(group, posInGroupPageToReplace, nPag);
        this.cache.setPageAsLoadInCache(nPag);
        PageBuffer pb = this.cache.getPageBuffer(group, posInGroupPageToReplace);
        if (n) {
            if (!readOnly) {
                this.cache.setModify(group, posInGroupPageToReplace);
            }
            this.cache.setAccessPage(pb, nPag);
        }
    }

    private boolean insertInAHole(int group, boolean readOnly, int nPag, boolean n) {
        PageBuffer pb = null;
        for (int i = 0; i < this.cache.getPagsPerGroup(); ++i) {
            if (this.cache.getLastAccess()[group][i] != -1) continue;
            pb = this.cache.getPageBuffer(group, i);
            this.cache.loadPage(group, i, nPag);
            this.cache.setRasterPageNumberInPosition(group, i, nPag);
            this.cache.setPageAsLoadInCache(nPag);
            this.cache.updateLastAccess(group);
            this.cache.setZeroInLastAccess(group, i);
            if (n) {
                if (!readOnly) {
                    this.cache.setModify(group, i);
                }
                this.cache.setAccessPage(pb, nPag);
            }
            return true;
        }
        return false;
    }
}

