/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.awt.Color;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class ColorItemImpl
implements ColorItem,
Cloneable {
    public static final String PERSISTENT_NAME = "ColorItemImpl_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "ColorItemImpl Persistent";
    private double value = 0.0;
    private String nameClass = null;
    private Color color = Color.black;
    private double interpolated = 50.0;

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getInterpolated() {
        return this.interpolated;
    }

    public void setInterpolated(double interpolated) {
        this.interpolated = interpolated > 100.0 ? 100.0 : (interpolated < 0.0 ? 0.0 : interpolated);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        if (Double.isNaN(value)) {
            return;
        }
        this.value = value;
    }

    public String getNameClass() {
        return this.nameClass;
    }

    public void setNameClass(String nameClass) {
        this.nameClass = nameClass;
    }

    public Object clone() {
        ColorItemImpl clone = null;
        try {
            clone = (ColorItemImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.color != null) {
            clone.color = new Color(this.color.getRGB(), this.color.getAlpha() != 255);
        }
        if (this.nameClass != null) {
            clone.nameClass = new String(this.nameClass);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (int)this.interpolated;
        result = 31 * result + (this.nameClass == null ? 0 : this.nameClass.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorItemImpl other = (ColorItemImpl)obj;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.interpolated != other.interpolated) {
            return false;
        }
        if (this.nameClass == null ? other.nameClass != null : !this.nameClass.equals(other.nameClass)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(ColorItemImpl.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldDouble("value").setMandatory(false);
            definition.addDynFieldDouble("interpolated").setMandatory(false);
            definition.addDynFieldObject("color").setClassOfValue(Color.class).setMandatory(false);
            definition.addDynFieldString("nameClass").setMandatory(false);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.value = state.getDouble("value");
        this.interpolated = state.getDouble("interpolated");
        this.color = (Color)state.get("color");
        this.nameClass = state.getString("nameClass");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("value", this.value);
        state.set("interpolated", this.interpolated);
        state.set("color", (Object)this.color);
        state.set("nameClass", this.nameClass);
    }
}

