/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.gvsig.fmap.dal.coverage.datastruct.SerialInfo;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.AbsoluteInterval;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.Time;

public class DefaultSerialInfo
implements SerialInfo {
    public static final int SINGLE_VALUES = 0;
    public static final int RANGES = 1;
    private ArrayList<Date> timeDate = new ArrayList();
    private ArrayList<Double> timeNumeric = new ArrayList();
    private int timeType = 0;
    private int dataType = 1;
    private String timeFormat = null;
    private String serialName = null;
    private String description = null;

    public DefaultSerialInfo() {
        this.timeFormat = "dd/MM/yyyy-hh:mm:ss";
    }

    public DefaultSerialInfo(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public DefaultSerialInfo(Time time, String description, String name) throws ParseException {
        String dateA;
        AbsoluteInstant t;
        this.timeFormat = "dd/MM/yyyy-hh:mm:ss";
        if (time instanceof RelativeInstant) {
            this.setTimeType(0);
            this.setDataType(0);
            this.addValue(((RelativeInstant)time).toMillis());
            this.setDescription(description);
            this.setSerialName(name);
        }
        if (time instanceof AbsoluteInstant) {
            t = (AbsoluteInstant)time;
            dateA = t.getDays() + "/" + t.getMonths() + "/" + t.getYears() + "-" + t.getHours() + "/" + t.getMinutes() + "/" + t.getSeconds();
            this.setTimeType(0);
            this.setDataType(1);
            this.addValue(dateA);
            this.setDescription(description);
            this.setSerialName(name);
        }
        if (time instanceof AbsoluteInterval) {
            t = ((AbsoluteInterval)time).getStart();
            dateA = t.getDays() + "/" + t.getMonths() + "/" + t.getYears() + "-" + t.getHours() + "/" + t.getMinutes() + "/" + t.getSeconds();
            t = ((AbsoluteInterval)time).getEnd();
            String dateB = t.getDays() + "/" + t.getMonths() + "/" + t.getYears() + "-" + t.getHours() + "/" + t.getMinutes() + "/" + t.getSeconds();
            this.setTimeType(1);
            this.setDataType(1);
            this.addValue(dateA);
            this.addValue(dateB);
            this.setDescription(description);
            this.setSerialName(name);
        }
        if (time instanceof RelativeInterval) {
            t = ((RelativeInterval)time).getStart();
            double dateA2 = t.toMillis();
            t = ((RelativeInterval)time).getEnd();
            double dateB = t.toMillis();
            this.setTimeType(1);
            this.setDataType(0);
            this.addValue(dateA2);
            this.addValue(dateB);
            this.setDescription(description);
            this.setSerialName(name);
        }
    }

    public String getSerialName() {
        return this.serialName;
    }

    public void setSerialName(String serialName) {
        this.serialName = serialName;
    }

    public ArrayList<?> getTime() {
        return this.dataType == 1 ? this.timeDate : this.timeNumeric;
    }

    public void setTime(ArrayList<?> time) {
        if (this.dataType == 1) {
            this.timeDate = time;
        } else {
            this.timeNumeric = time;
        }
    }

    public int getTimeType() {
        return this.timeType;
    }

    public void setTimeType(int timeType) {
        this.timeType = timeType;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public void setTimeType(String timeType) {
        if (timeType.compareTo("Single values") == 0) {
            this.timeType = 0;
        }
        if (timeType.compareTo("Ranges") == 0) {
            this.timeType = 1;
        }
    }

    public void addValue(String value) throws ParseException {
        this.dataType = 1;
        SimpleDateFormat formatter = new SimpleDateFormat(this.timeFormat);
        Date date = null;
        try {
            date = formatter.parse(value);
        }
        catch (ParseException e) {
            date = formatter.parse(value + "-00:00:00");
        }
        this.timeDate.add(date);
    }

    public void addValue(double value) {
        this.dataType = 0;
        this.timeNumeric.add(new Double(value));
    }

    public String getTimeInfo(int pos) {
        if (this.dataType == 1) {
            SimpleDateFormat formatter = new SimpleDateFormat(this.timeFormat);
            return formatter.format(this.timeDate.get(pos));
        }
        if (this.dataType == 0) {
            return this.timeNumeric.get(pos) + "";
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isInRange(SerialInfo tInfo) {
        if (this.dataType == 1) {
            return this.isInRangeDateType(tInfo);
        }
        if (this.dataType == 0) {
            return this.isInRangeNumericType(tInfo);
        }
        return false;
    }

    private boolean isInRangeDateType(SerialInfo tInfo) {
        long dif2;
        long dif1;
        long dif;
        ArrayList t1 = tInfo.getTime();
        ArrayList<?> t2 = this.getTime();
        if (t1.size() == 1 && t2.size() == 1 && (dif = ((Date)t1.get(0)).getTime() - ((Date)t2.get(0)).getTime()) == 0L) {
            return true;
        }
        if (t1.size() == 1 && t2.size() > 1) {
            dif1 = ((Date)t1.get(0)).getTime() - ((Date)t2.get(0)).getTime();
            dif2 = ((Date)t1.get(0)).getTime() - ((Date)t2.get(t2.size() - 1)).getTime();
            if (dif1 > 0L && dif2 < 0L) {
                return true;
            }
        }
        if (t1.size() > 1 && t2.size() == 1) {
            dif1 = ((Date)t1.get(0)).getTime() - ((Date)t2.get(0)).getTime();
            dif2 = ((Date)t1.get(t1.size() - 1)).getTime() - ((Date)t2.get(0)).getTime();
            if (dif1 == 0L && dif2 == 0L) {
                return true;
            }
        }
        if (t1.size() > 1 && t2.size() > 1) {
            dif1 = ((Date)t1.get(0)).getTime() - ((Date)t2.get(0)).getTime();
            dif2 = ((Date)t1.get(t1.size() - 1)).getTime() - ((Date)t2.get(t2.size() - 1)).getTime();
            if (dif1 >= 0L && dif2 <= 0L) {
                return true;
            }
        }
        return false;
    }

    private boolean isInRangeNumericType(SerialInfo tInfo) {
        double dif2;
        double dif1;
        double dif;
        ArrayList t1 = tInfo.getTime();
        ArrayList<?> t2 = this.getTime();
        if (t1.size() == 1 && t2.size() == 1 && (dif = (Double)t1.get(0) - (Double)t2.get(0)) == 0.0) {
            return true;
        }
        if (t1.size() == 1 && t2.size() > 1) {
            dif1 = (Double)t1.get(0) - (Double)t2.get(0);
            dif2 = (Double)t1.get(0) - (Double)t2.get(t2.size() - 1);
            if (dif1 > 0.0 && dif2 < 0.0) {
                return true;
            }
        }
        if (t1.size() > 1 && t2.size() == 1) {
            dif1 = (Double)t1.get(0) - (Double)t2.get(0);
            dif2 = (Double)t1.get(t1.size() - 1) - (Double)t2.get(0);
            if (dif1 == 0.0 && dif2 == 0.0) {
                return true;
            }
        }
        if (t1.size() > 1 && t2.size() > 1) {
            dif1 = (Double)t1.get(0) - (Double)t2.get(0);
            dif2 = (Double)t1.get(t1.size() - 1) - (Double)t2.get(t2.size() - 1);
            if (dif1 >= 0.0 && dif2 <= 0.0) {
                return true;
            }
        }
        return false;
    }
}

