/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct.legend;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.raster.impl.datastruct.ColorItemImpl;
import org.gvsig.raster.impl.datastruct.legend.RasterLegendIO;
import org.gvsig.raster.impl.store.properties.DataStoreColorTable;

public class GimpPalettes
extends RasterLegendIO {
    private ColorItem parseColorItem(String[] strings) {
        if (strings.length < 4) {
            return null;
        }
        ColorItemImpl item = new ColorItemImpl();
        item.setInterpolated(100.0);
        item.setColor(new Color(Integer.valueOf(strings[1]), Integer.valueOf(strings[2]), Integer.valueOf(strings[3])));
        return item;
    }

    @Override
    public ColorTable read(File input) throws IOException {
        ArrayList<ColorItem> colorItems = new ArrayList<ColorItem>();
        DataStoreColorTable colorTable = new DataStoreColorTable();
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(input));
            int cont = 0;
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.charAt(0) == '#') continue;
                if (cont == 1) {
                    colorTable.setName(currentLine.substring(6));
                }
                if (cont > 1) {
                    String[] strings = (" " + currentLine).split("\\s+");
                    ColorItem colorItem = this.parseColorItem(strings);
                    if (colorItem == null) continue;
                    strings = (" " + currentLine).split("\\s+\\d+\\s+\\d+\\s+\\d+\\s+");
                    if (!strings[1].equals("Untitled")) {
                        colorItem.setNameClass(strings[1]);
                    } else {
                        colorItem.setNameClass("");
                    }
                    colorItem.setValue((double)(cont - 2));
                    colorItems.add(colorItem);
                }
                ++cont;
            }
            reader.close();
        }
        catch (IOException ex) {
            throw new IOException();
        }
        colorTable.createPaletteFromColorItems(colorItems, false);
        return colorTable;
    }

    @Override
    public void write(ColorTable colorTable, File output) throws IOException {
        List colorItems = colorTable.getColorItems();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(output));
            writer.write("GIMP Palette\n");
            writer.write("Name: " + colorTable.getName() + "\n");
            writer.write("#\n");
            for (int i = 0; i < colorItems.size(); ++i) {
                String line = "";
                ColorItem item1 = (ColorItem)colorItems.get(i);
                Color color = item1.getColor();
                line = line + color.getRed() + " ";
                line = line + color.getGreen() + " ";
                line = line + color.getBlue() + "\t";
                line = item1.getNameClass() != null && item1.getNameClass().length() > 0 ? line + item1.getNameClass() + "\n" : line + "Untitled\n";
                writer.write(line);
            }
            writer.close();
        }
        catch (IOException ex) {
            throw new IOException();
        }
    }

    @Override
    public String getDescription() {
        return "Gimp Palettes";
    }
}

