/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid;

import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.GridExtent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.RasterBufferInvalidAccessException;
import org.gvsig.fmap.dal.coverage.exception.RasterBufferInvalidException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;

public abstract class GridReader {
    protected RasterDataStore dataStore = null;
    protected Buffer rasterBuf = null;
    protected int dataType = 32;
    protected int[] bands = null;
    protected int bandToOperate = 0;
    protected NoData defaultNoData = null;
    GridExtent windowExtent = null;
    GridExtent layerExtent = null;

    public GridReader(Buffer rb, GridExtent layerExtent, GridExtent windowExtent, int[] bands) {
        this.rasterBuf = rb;
        this.dataType = rb.getDataType();
        this.bands = bands;
        this.windowExtent = windowExtent;
        this.layerExtent = layerExtent;
    }

    public GridReader(RasterDataStore ds, GridExtent layerExtent, GridExtent windowExtent, int[] bands) {
        this.dataStore = ds;
        this.rasterBuf = ds.getLastBuffer();
        if (this.dataStore.getDataType() != null) {
            this.dataType = this.dataStore.getDataType()[0];
        }
        this.bands = bands;
        this.windowExtent = windowExtent;
        this.layerExtent = layerExtent;
    }

    public abstract byte getCellValueAsByte(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract short getCellValueAsShort(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract int getCellValueAsInt(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract float getCellValueAsFloat(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract double getCellValueAsDouble(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract double getCellValue(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract byte[] getBandsValuesAsByte(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract short[] getBandsValuesAsShort(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract int[] getBandsValuesAsInt(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract float[] getBandsValuesAsFloat(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public abstract double[] getBandsValuesAsDouble(int var1, int var2) throws RasterBufferInvalidAccessException, RasterBufferInvalidException;

    public boolean isNoDataValue(double dValue) {
        if (this.rasterBuf != null && this.rasterBuf.getNoDataValue() != null && this.rasterBuf.getNoDataValue().isDefined()) {
            return dValue == this.rasterBuf.getNoDataValue().getValue().doubleValue();
        }
        if (this.defaultNoData != null && this.defaultNoData.isDefined()) {
            return dValue == this.defaultNoData.getValue().doubleValue();
        }
        return false;
    }

    public double getNoDataValue() {
        if (this.rasterBuf != null && this.rasterBuf.getNoDataValue() != null && this.rasterBuf.getNoDataValue().isDefined()) {
            return this.rasterBuf.getNoDataValue().getValue().doubleValue();
        }
        if (this.defaultNoData != null && this.defaultNoData.isDefined()) {
            return this.defaultNoData.getValue().doubleValue();
        }
        return -99999.0;
    }

    public int getNY() {
        return this.windowExtent.getNY();
    }

    public int getNX() {
        return this.windowExtent.getNX();
    }

    public double getCellSize() {
        return this.windowExtent.getCellSize();
    }

    public GridExtent getGridExtent() {
        return this.windowExtent;
    }

    public boolean isCellInGrid(int iX, int iY) {
        return iX >= 0 && iX < this.getNX() && iY >= 0 && iY < this.getNY();
    }

    public void setBandToOperate(int band) {
        this.bandToOperate = band;
    }

    public void dispose() {
        if (this.rasterBuf != null) {
            this.rasterBuf.dispose();
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.dataStore = null;
        this.rasterBuf = null;
        this.bands = null;
        this.defaultNoData = null;
        super.finalize();
    }
}

