/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.grid.FilterListChangeEvent;
import org.gvsig.fmap.dal.coverage.grid.FilterListChangeListener;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.store.ParamsImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultRasterFilterList
implements RasterFilterList {
    public static final String PERSISTENT_NAME = "RasterFilterList_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "RasterFilterList Persistent";
    private Buffer initialRasterBuffer = null;
    private Buffer outputRasterBuffer = null;
    private int typeFilter = -1;
    private TreeMap<String, Object> environment = new TreeMap();
    private List<RasterFilter> list = new ArrayList<RasterFilter>();
    private Stack<List<RasterFilter>> status = new Stack();
    private List<FilterListChangeListener> filterListListener = new ArrayList<FilterListChangeListener>();
    private RasterFilterListManagerImpl manager = null;

    public void addFilterListListener(FilterListChangeListener listener) {
        this.filterListListener.add(listener);
    }

    private void callFilterListChanged(Object obj) {
        if (this.filterListListener != null) {
            for (int i = 0; i < this.filterListListener.size(); ++i) {
                FilterListChangeEvent ev = new FilterListChangeEvent(obj);
                this.filterListListener.get(i).filterListChanged(ev);
            }
        }
    }

    public void addEnvParam(String key, Object value) {
        this.environment.put(key, value);
    }

    public Object getEnvParam(String key) {
        return this.environment.get(key);
    }

    public void controlTypes() throws FilterTypeException {
        RasterFilterListManagerImpl stackManager = new RasterFilterListManagerImpl(this);
        stackManager.controlTypes();
    }

    public void add(RasterFilter filter) throws FilterTypeException {
        if (this.isActive(filter.getName())) {
            this.replace(filter, filter.getName());
        } else {
            this.list.add(filter);
            this.controlTypes();
        }
        filter.setEnv(this.environment);
        this.callFilterListChanged(this);
    }

    public void replace(RasterFilter filter, String name) throws FilterTypeException {
        boolean changed = false;
        filter.setEnv(this.environment);
        for (int i = this.list.size() - 1; i >= 0; --i) {
            if (!((BaseRasterFilter)this.list.get(i)).getName().equals(name)) continue;
            this.list.remove(i);
            this.list.add(i, filter);
            changed = true;
        }
        if (changed) {
            this.controlTypes();
        }
        this.callFilterListChanged(this);
    }

    public void add(RasterFilter filter, int pos) throws FilterTypeException {
        try {
            this.list.add(pos, filter);
            this.controlTypes();
        }
        catch (IndexOutOfBoundsException e) {
            this.add(filter);
        }
        filter.setEnv(this.environment);
        this.callFilterListChanged(this);
    }

    public void remove(String name) throws FilterTypeException {
        boolean changed = false;
        for (int i = this.list.size() - 1; i >= 0; --i) {
            if (!((BaseRasterFilter)this.list.get(i)).getName().equals(name)) continue;
            this.list.remove(i);
            changed = true;
        }
        if (changed) {
            this.controlTypes();
        }
        this.callFilterListChanged(this);
    }

    public void removeAll() {
        this.list.clear();
        this.callFilterListChanged(this);
    }

    public void remove(Class<?> baseFilterClass) throws FilterTypeException {
        boolean changed = false;
        for (int i = 0; i < this.lenght(); ++i) {
            if (!baseFilterClass.isInstance(this.list.get(i))) continue;
            this.list.remove(i);
            --i;
            changed = true;
        }
        if (changed) {
            this.controlTypes();
        }
        this.callFilterListChanged(this);
    }

    public int getOutDataType() {
        if (this.list.size() > 0) {
            return ((BaseRasterFilter)this.list.get(this.list.size() - 1)).getOutRasterDataType();
        }
        if (this.outputRasterBuffer != null) {
            return this.outputRasterBuffer.getDataType();
        }
        return this.initialRasterBuffer.getDataType();
    }

    public Buffer getResult() {
        return this.outputRasterBuffer;
    }

    public int lenght() {
        return this.list.size();
    }

    public RasterFilter get(int i) {
        if (i >= this.list.size() || i < 0) {
            return null;
        }
        return (BaseRasterFilter)this.list.get(i);
    }

    public RasterFilter get(String name) {
        for (int i = this.list.size() - 1; i >= 0; --i) {
            if (!((BaseRasterFilter)this.list.get(i)).getName().equals(name)) continue;
            return (BaseRasterFilter)this.list.get(i);
        }
        return null;
    }

    public RasterFilter getByName(String name) {
        for (int i = 0; i < this.lenght(); ++i) {
            if (!((BaseRasterFilter)this.list.get(i)).getName().equals(name)) continue;
            return (BaseRasterFilter)this.list.get(i);
        }
        return null;
    }

    public RasterFilter getFilterByBaseClass(Class<?> baseFilterClass) {
        for (int i = 0; i < this.lenght(); ++i) {
            if (!baseFilterClass.isInstance(this.list.get(i))) continue;
            return (BaseRasterFilter)this.list.get(i);
        }
        return null;
    }

    public String getName(int i) {
        return ((BaseRasterFilter)this.list.get(i)).getName();
    }

    public void clear() {
        this.list.clear();
        this.callFilterListChanged(this);
    }

    public void replace(RasterFilter filter, int i) {
        filter.setEnv(this.environment);
        this.list.remove(i);
        this.list.add(i, filter);
        this.callFilterListChanged(this);
    }

    public boolean move(Class<?> filter, int position) {
        BaseRasterFilter f = null;
        for (int i = 0; i < this.list.size(); ++i) {
            if (!filter.isInstance(this.list.get(i))) continue;
            f = (BaseRasterFilter)this.list.get(i);
            this.list.remove(i);
            break;
        }
        if (f != null) {
            this.list.add(position, (RasterFilter)f);
            return true;
        }
        return false;
    }

    public void setInitRasterBuf(Buffer raster) {
        this.initialRasterBuffer = raster;
        if (this.initialRasterBuffer != null) {
            this.typeFilter = this.initialRasterBuffer.getDataType();
        }
    }

    public int getInitDataType() {
        return this.typeFilter;
    }

    public void setInitDataType(int dt) {
        this.typeFilter = dt;
    }

    public boolean isActive(String name) {
        for (int i = this.list.size() - 1; i >= 0; --i) {
            if (!this.list.get(i).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isActive(RasterFilter filter) {
        for (int i = this.list.size() - 1; i >= 0; --i) {
            if (!this.list.get(i).equals(filter)) continue;
            return true;
        }
        return false;
    }

    public int getPosition(Class<?> c) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!c.isInstance(this.list.get(i))) continue;
            return i;
        }
        return -1;
    }

    private void executeFilterByDataType(int dataType) throws ProcessInterruptedException, FilterAddException {
        if (this.outputRasterBuffer != null && this.initialRasterBuffer != this.outputRasterBuffer) {
            this.outputRasterBuffer.dispose();
            this.outputRasterBuffer = null;
        }
        Buffer bufferToProcess = this.initialRasterBuffer;
        for (int i = 0; i < this.list.size(); ++i) {
            BaseRasterFilter filter = (BaseRasterFilter)this.list.get(i);
            filter.addParam("raster", (Object)bufferToProcess);
            filter.execute();
            if (filter.getResult("raster") != null) {
                if (i < this.list.size() - 1) {
                    if (bufferToProcess != null && this.initialRasterBuffer != bufferToProcess) {
                        bufferToProcess.dispose();
                    }
                    bufferToProcess = (Buffer)filter.getResult("raster");
                } else {
                    this.outputRasterBuffer = (Buffer)filter.getResult("raster");
                }
            }
            if (i != this.list.size() - 1 || filter.getResult("transparency") == null) continue;
            this.addEnvParam("Transparency", filter.getResult("transparency"));
        }
    }

    public Buffer execute() throws ProcessInterruptedException, FilterAddException {
        if (this.initialRasterBuffer == null) {
            return null;
        }
        this.executeFilterByDataType(this.initialRasterBuffer.getDataType());
        return this.initialRasterBuffer;
    }

    public void show() {
        System.out.println("--------------------------------------------");
        for (int i = 0; i < this.list.size(); ++i) {
            System.out.println("FILTRO:" + i + " NAME:" + ((BaseRasterFilter)this.list.get(i)).getName() + " FIL:" + ((BaseRasterFilter)this.list.get(i)).toString());
        }
    }

    public void resetPercent() {
        for (int i = 0; i < this.list.size(); ++i) {
            ((BaseRasterFilter)this.list.get(i)).resetPercent();
        }
    }

    public int getPercent() {
        int percent = 0;
        if (this.list == null || this.list.size() == 0) {
            return 0;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            percent += ((BaseRasterFilter)this.list.get(i)).getPercent();
        }
        return percent /= this.list.size();
    }

    public void pushStatus() {
        this.status.push(this.getStatusCloned());
    }

    public List<RasterFilter> getStatusCloned() {
        ArrayList<RasterFilter> newArray = new ArrayList<RasterFilter>();
        for (int i = 0; i < this.list.size(); ++i) {
            try {
                newArray.add((RasterFilter)((BaseRasterFilter)this.list.get(i)).clone());
                continue;
            }
            catch (CloneNotSupportedException e) {
                System.out.println("No se ha podido clonar");
            }
        }
        return newArray;
    }

    public void setStatus(List<RasterFilter> newArray) {
        if (this.list != null) {
            this.list.clear();
        }
        if (newArray == null) {
            return;
        }
        for (int i = 0; i < newArray.size(); ++i) {
            if (this.list == null) continue;
            this.list.add(newArray.get(i));
        }
        this.callFilterListChanged(this);
    }

    public void popStatus() {
        if (this.status.size() <= 0) {
            return;
        }
        this.setStatus(this.status.pop());
    }

    public TreeMap<String, Object> getEnv() {
        return this.environment;
    }

    public void setEnv(TreeMap<String, Object> env) {
        this.environment = env;
    }

    public RasterFilterListManager getManagerByID(String id) throws FilterManagerException {
        return new RasterFilterListManagerImpl(this).getManagerByID(id);
    }

    public RasterFilterListManager getManagerByFilterClass(Class<?> c) {
        if (this.manager == null) {
            this.manager = new RasterFilterListManagerImpl(this);
        }
        return this.manager.getManagerByFilterClass(c);
    }

    public RasterFilterListManager getManagerByClass(Class<?> clase) {
        Object obj = null;
        Class[] args = new Class[]{RasterFilterList.class};
        try {
            Constructor<?> hazNuevo = clase.getConstructor(args);
            Object[] args2 = new Object[]{this};
            obj = hazNuevo.newInstance(args2);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public Class<?> getFilterClassByID(String id) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterFilter");
        for (ExtensionPoint.Extension entry : point) {
            Class c;
            Class managerClass;
            RasterFilterListManager manager;
            if (entry == null || (manager = this.getManagerByClass(managerClass = entry.getExtension())) == null || (c = manager.getFilterClassByID(id)) == null) continue;
            return c;
        }
        return null;
    }

    public Params createEmptyFilterParams() {
        return new ParamsImpl();
    }

    public List<Class<?>> getRegisteredFilterList() {
        if (this.manager == null) {
            this.manager = new RasterFilterListManagerImpl(this);
        }
        return this.manager.getRasterFilterList();
    }

    public List<Class<?>> getRegisteredFilterListByDataType(int dataType) {
        if (this.manager == null) {
            this.manager = new RasterFilterListManagerImpl(this);
        }
        return this.manager.getRasterFilterListByDataType(dataType);
    }

    public RasterFilter createEmptyFilter(String strPackage) throws FilterTypeException {
        Class<?> filterClass = null;
        try {
            filterClass = Class.forName(strPackage.trim());
        }
        catch (ClassNotFoundException e) {
            throw new FilterTypeException("No puedo instanciar " + strPackage.trim());
        }
        Constructor<?> con = null;
        try {
            con = filterClass.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new FilterTypeException("");
        }
        catch (NoSuchMethodException e) {
            throw new FilterTypeException("");
        }
        BaseRasterFilter newFilter = null;
        try {
            newFilter = (BaseRasterFilter)con.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new FilterTypeException("");
        }
        catch (InstantiationException e) {
            throw new FilterTypeException("");
        }
        catch (IllegalAccessException e) {
            throw new FilterTypeException("");
        }
        catch (InvocationTargetException e) {
            throw new FilterTypeException("");
        }
        return newFilter;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.typeFilter = state.getInt("typeFilter");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("typeFilter", this.typeFilter);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DefaultRasterFilterList.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldInt("typeFilter").setMandatory(false);
        }
    }

    public void dispose() {
        if (this.initialRasterBuffer != null) {
            this.initialRasterBuffer.dispose();
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Transparency getTransparency() {
        return (Transparency)this.getEnvParam("Transparency");
    }

    protected void finalize() throws Throwable {
        this.initialRasterBuffer = null;
        if (this.filterListListener != null) {
            this.filterListListener.clear();
            this.filterListListener = null;
        }
        if (this.status != null) {
            this.status.clear();
            this.status = null;
        }
        if (this.list != null) {
            this.list.clear();
            this.list = null;
        }
        super.finalize();
    }
}

