/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.fmap.dal.coverage.util.ColorConversion;
import org.gvsig.raster.impl.store.ParamsImpl;
import org.gvsig.raster.util.DefaultColorConversion;

public class ColorBalanceCMYFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"colorbalancecmy"};
    protected ColorConversion colorConversion = null;
    protected int out = 0;
    protected double cyan = 0.0;
    protected double magenta = 0.0;
    protected double yellow = 0.0;
    protected boolean luminosity = false;
    protected int redBandNumber = -1;
    protected int greenBandNumber = -1;
    protected int blueBandNumber = -1;

    public ColorBalanceCMYFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        super.pre();
        this.redBandNumber = 0;
        this.greenBandNumber = 1;
        this.blueBandNumber = 2;
        if (this.getInputBuffer().getDataType() != 0) {
            this.exec = false;
            this.raster = this.rasterResult;
            return;
        }
        if (this.params.get("cyan") != null) {
            this.cyan = (Double)this.params.get("cyan");
        }
        if (this.params.get("magenta") != null) {
            this.magenta = (Double)this.params.get("magenta");
        }
        if (this.params.get("yellow") != null) {
            this.yellow = (Double)this.params.get("yellow");
        }
        if (this.params.get("luminosity") != null) {
            this.luminosity = (Boolean)this.params.get("luminosity");
        }
        this.createARGBBufferResult();
        if (this.colorConversion == null) {
            this.colorConversion = new DefaultColorConversion();
        }
    }

    public String getGroup() {
        return "colores";
    }

    public String[] getNames() {
        return names;
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("cyan", new Double(this.cyan), 3, new String[]{"0", "100", "0", "5", "25"});
        params.setParam("magenta", new Double(this.magenta), 3, new String[]{"0", "100", "0", "5", "25"});
        params.setParam("yellow", new Double(this.yellow), 3, new String[]{"0", "100", "0", "5", "25"});
        params.setParam("luminosity", new Boolean(this.luminosity), 1, null);
        return params;
    }

    public void post() {
    }

    public void process(int x, int y) {
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public boolean isVisible() {
        return true;
    }

    public int getInRasterDataType() {
        return 0;
    }
}

