/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.band.ColorBalanceCMYByteFilter;
import org.gvsig.raster.impl.grid.filter.band.ColorBalanceCMYFilter;
import org.gvsig.raster.impl.grid.filter.correction.MedianByteFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class ColorBalanceCMYManager
extends AbstractRasterFilterManager {
    private static String ID = "ColorBalanceCMY";

    public ColorBalanceCMYManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, ColorBalanceCMYManager.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("colorbalancecmy") == 0) {
            return ColorBalanceCMYFilter.class;
        }
        return null;
    }

    public ColorBalanceCMYManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public void addColorBalanceFilter(double cyan, double magenta, double yellow, boolean luminosity, int[] renderBands) throws FilterTypeException {
        ColorBalanceCMYByteFilter filter = new ColorBalanceCMYByteFilter();
        if (filter != null) {
            filter.addParam("cyan", new Double(cyan));
            filter.addParam("magenta", new Double(magenta));
            filter.addParam("yellow", new Double(yellow));
            filter.addParam("luminosity", new Boolean(luminosity));
            filter.addParam("renderBands", renderBands);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(ColorBalanceCMYFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (ColorBalanceCMYFilter.class.isAssignableFrom(classFilter)) {
            double cyan = 0.0;
            double magenta = 0.0;
            double yellow = 0.0;
            boolean luminosity = false;
            int[] renderBands = new int[]{0, 1, 2, 3};
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("RenderBands") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String) {
                    String[] bands = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue()).split(" ");
                    renderBands[0] = new Integer(bands[0]);
                    renderBands[1] = new Integer(bands[1]);
                    renderBands[2] = new Integer(bands[2]);
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("alphaBand") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    renderBands[3] = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("cyan")) {
                    cyan = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("magenta")) {
                    magenta = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("yellow")) {
                    yellow = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("luminosity")) continue;
                luminosity = (Boolean)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addColorBalanceFilter(cyan, magenta, yellow, luminosity, renderBands);
        }
    }

    public RasterFilter createFilter(Params params) {
        int[] renderBands = new int[]{0, 1, 2};
        String b = (String)params.getParamById("RenderBands").getDefaultValue();
        String[] bands = b.split(" ");
        renderBands[0] = new Integer(bands[0]);
        renderBands[1] = new Integer(bands[1]);
        renderBands[2] = new Integer(bands[2]);
        Double cyan = (Double)params.getParamById("cyan").getDefaultValue();
        Double magenta = (Double)params.getParamById("magenta").getDefaultValue();
        Double yellow = (Double)params.getParamById("yellow").getDefaultValue();
        Double lum = (Double)params.getParamById("luminosity").getDefaultValue();
        MedianByteFilter filter = new MedianByteFilter();
        filter.addParam("cyan", cyan);
        filter.addParam("luminosity", lum);
        filter.addParam("magenta", magenta);
        filter.addParam("yellow", yellow);
        filter.addParam("renderBands", renderBands);
        return filter;
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(ColorBalanceCMYFilter.class, params);
    }
}

