/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.histogramMatching;

import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.HistogramException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.RasterBuffer;
import org.gvsig.raster.impl.datastruct.BufferHistogramImpl;
import org.gvsig.raster.impl.store.ParamsImpl;

public class HistogramMatchingFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"HistogramMatch"};
    public BufferHistogram histogramReference = null;
    private BufferHistogram histogramSource = null;
    private double[][] acumulateS = null;
    private double[][] acumulateR = null;
    public String fileNameOutput = null;
    public byte[][] tableAsign = null;
    public int numbands = 0;

    public String getGroup() {
        return "HistogramMatch";
    }

    public int getInRasterDataType() {
        return 0;
    }

    public String[] getNames() {
        return names;
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        return params;
    }

    public boolean isVisible() {
        return false;
    }

    public void pre() {
        try {
            this.loadParam();
        }
        catch (HistogramException e) {
            this.exec = false;
        }
        catch (ProcessInterruptedException e) {
            this.exec = false;
        }
        double inValue = 0.0;
        this.tableAsign = new byte[this.numbands][256];
        for (int band = 0; band < this.numbands; ++band) {
            for (int i = 0; i < this.tableAsign[0].length; ++i) {
                inValue = this.acumulateS[band][i];
                int value = this.searchInHistogramReference(inValue, band);
                this.tableAsign[band][i] = (byte)value;
            }
        }
    }

    public void post() {
    }

    protected void loadParam() throws HistogramException, ProcessInterruptedException {
        this.raster = (RasterBuffer)((Object)this.params.get("raster"));
        this.height = this.raster.getHeight();
        this.width = this.raster.getWidth();
        this.histogramSource = this.raster.getHistogramComputer().getBufferHistogram();
        this.histogramSource = BufferHistogramImpl.convertHistogramToRGB(this.histogramSource);
        if (!this.histogramSource.isInRangeRGB()) {
            return;
        }
        this.histogramReference = (BufferHistogram)this.params.get("histogramReference");
        this.histogramReference = BufferHistogramImpl.convertHistogramToRGB(this.histogramReference);
        this.numbands = (Integer)this.params.get("numbands");
        this.acumulateS = BufferHistogramImpl.convertTableToNormalizeAccumulate(this.histogramSource.getTable());
        this.acumulateR = BufferHistogramImpl.convertTableToNormalizeAccumulate(this.histogramReference.getTable());
        this.rasterResult = DefaultRasterManager.getInstance().createBuffer(0, this.raster.getWidth(), this.raster.getHeight(), this.numbands, true);
        this.fileNameOutput = (String)this.params.get("fileNameOutput");
    }

    public int searchInHistogramReference(double value, int band) {
        int i = 0;
        while (value > this.acumulateR[band][i]) {
            if (++i != 255) continue;
            return 255;
        }
        if (i == 0) {
            return 0;
        }
        if (this.acumulateR[band][i] - value < this.acumulateR[band][i - 1] - value) {
            return i;
        }
        return i - 1;
    }

    public void process(int x, int y) {
    }
}

