/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.histogramMatching;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.histogramMatching.HistogramMatchingByteFilter;
import org.gvsig.raster.impl.grid.filter.histogramMatching.HistogramMatchingFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class HistogramMatchingListManager
extends AbstractRasterFilterManager {
    private static String ID = "Matching";

    public HistogramMatchingListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, HistogramMatchingListManager.class);
    }

    public HistogramMatchingListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("HistogramMatch") == 0) {
            return HistogramMatchingFilter.class;
        }
        return null;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (HistogramMatchingFilter.class.isAssignableFrom(classFilter)) {
            String fileNameOutput = null;
            RasterDataStore raster = null;
            int numbands = 0;
            HistogramComputer histogramReference = null;
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("raster")) {
                    raster = (RasterDataStore)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("numbands")) {
                    numbands = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("histogramReference")) {
                    histogramReference = (HistogramComputer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("fileNameOutput")) continue;
                fileNameOutput = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue());
            }
            this.addHistogramMatchingFilter(raster, numbands, histogramReference, fileNameOutput);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(HistogramMatchingFilter.class, params);
    }

    public void addHistogramMatchingFilter(RasterDataStore raster, int numbands, HistogramComputer histogramReference, String fileNameOutput) throws FilterTypeException {
        HistogramMatchingByteFilter filter = new HistogramMatchingByteFilter();
        if (filter != null) {
            filter.addParam("raster", raster);
            filter.addParam("histogramReference", histogramReference);
            filter.addParam("numbands", new Integer(numbands));
            filter.addParam("fileNameOutput", fileNameOutput);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public RasterFilter createFilter(Params params) {
        if (params.getParamById("ladoVentana") != null) {
            RasterDataStore raster = (RasterDataStore)params.getParamById("raster").getDefaultValue();
            Integer numbands = (Integer)params.getParamById("numbands").getDefaultValue();
            HistogramComputer histogramReference = (HistogramComputer)params.getParamById("histogramReference").getDefaultValue();
            String fileNameOutput = (String)params.getParamById("fileNameOutput").getDefaultValue();
            HistogramMatchingByteFilter filter = new HistogramMatchingByteFilter();
            filter.addParam("raster", raster);
            filter.addParam("histogramReference", histogramReference);
            filter.addParam("numbands", new Integer(numbands));
            filter.addParam("fileNameOutput", fileNameOutput);
            return filter;
        }
        return null;
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(HistogramMatchingFilter.class);
        return filters;
    }

    public static RasterFilter createHistogramMatchFilter() {
        HistogramMatchingFilter filter = new HistogramMatchingFilter();
        return filter;
    }
}

