/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.pansharp;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.grid.filter.pansharp.PanSharpeningFilter;

public class PanSharpeningByteFilter
extends PanSharpeningFilter {
    public void init() {
        this.loadParam();
        this.checkInput();
        try {
            Object[] bands = null;
            bands = this.bandOrder.toArray();
            int[] bandas = new int[bands.length];
            for (int i = 0; i < bands.length; ++i) {
                bandas[i] = (Integer)bands[i];
            }
            RasterQuery query = DefaultRasterManager.getInstance().createQuery();
            Extent adjustedExtent = this.util.calculateAdjustedView(this.dataset.getExtent(), this.dataset.getAffineTransform(), (double)this.widthMultiespec, (double)this.heightMultiespec);
            query.setDrawableBands(bandas);
            try {
                query.setAreaOfInterest(adjustedExtent, this.widthMultiespec, this.heightMultiespec);
                this.bufferMultiespectral = this.dataset.query(query);
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
            query = DefaultRasterManager.getInstance().createQuery();
            AffineTransform[] at = this.dataset.getAffineTransformByProvider();
            Extent adjustedExtentP = this.util.calculateAdjustedView(this.dataset.getExtent(), at[this.posPancromat], (double)this.widthPancr, (double)this.heightPancr);
            query.setDrawableBands(new int[]{this.posPancromatica});
            try {
                query.setAreaOfInterest(adjustedExtentP, this.widthPancr, this.heightPancr);
                this.bufferPancr = this.dataset.query(query);
            }
            catch (QueryException e) {
                e.printStackTrace();
            }
            this.rasterResult = DefaultRasterManager.getInstance().createBuffer(0, this.widthPancr, this.heightPancr, 3, true);
        }
        catch (ProcessInterruptedException processInterruptedException) {
            // empty catch block
        }
    }

    private void checkInput() {
        this.exec = true;
        if (this.heightMultiespec > this.heightPancr || this.widthMultiespec > this.widthPancr || this.heightMultiespec == 0 || this.widthMultiespec == 0) {
            this.exec = false;
        }
        double[] h = this.dataset.getHeightByProvider();
        double[] w = this.dataset.getWidthByProvider();
        for (int i = 0; i < this.dataset.getProviderCount(); ++i) {
            if (i == this.posPancromat || h[i] == (double)this.heightMultiespec && w[i] == (double)this.widthMultiespec) continue;
            this.exec = false;
            break;
        }
    }

    private void loadParam() {
        this.posPancromatica = (Integer)this.params.get("posPancromatica");
        this.dataset = (RasterDataStore)this.params.get("dataset");
        this.bandOrder = (ArrayList)this.params.get("order");
        this.alpha = (Integer)this.params.get("alpha");
        this.method = (String)this.params.get("method");
        this.coef = (Double)this.params.get("coef");
        this.coefBrovey = (Integer)this.params.get("coefBrovey");
        this.fileNameOutput = (String)this.params.get("fileNameOutput");
        this.heightPancr = (int)this.dataset.getHeightByProvider()[this.posPancromatica];
        this.widthPancr = (int)this.dataset.getWidthByProvider()[this.posPancromatica];
        for (int i = 0; i < this.dataset.getProviderCount(); ++i) {
            if (i == this.posPancromat) continue;
            this.heightMultiespec = (int)this.dataset.getHeightByProvider()[i];
            this.widthMultiespec = (int)this.dataset.getWidthByProvider()[i];
            break;
        }
        if (this.widthMultiespec != 0 && this.heightMultiespec != 0) {
            this.relX = this.widthPancr / this.widthMultiespec;
            this.relY = this.heightPancr / this.heightMultiespec;
        }
    }

    public void execute() {
        this.pre();
        this.init();
        if (this.exec) {
            byte[][] pRGBMultiespectral = null;
            if (this.method.equals("hsl")) {
                for (int iLine = 0; iLine < this.heightMultiespec; ++iLine) {
                    pRGBMultiespectral = this.bufferMultiespectral.getLineByte(iLine);
                    this.processIHS(pRGBMultiespectral, iLine);
                }
            } else {
                for (int iLine = 0; iLine < this.heightMultiespec; ++iLine) {
                    pRGBMultiespectral = this.bufferMultiespectral.getLineByte(iLine);
                    this.processBrovey(pRGBMultiespectral, iLine);
                }
            }
        }
        this.post();
    }

    @Override
    public int getInRasterDataType() {
        return 0;
    }

    @Override
    public int getOutRasterDataType() {
        return 0;
    }

    private void processBrovey(byte[][] bufferInput, int iLine) {
        int r = 0;
        int g = 0;
        int b = 0;
        double r1 = 0.0;
        double g1 = 0.0;
        double b1 = 0.0;
        double scale = 0.0;
        int valorPanc = 0;
        int line = 0;
        int col = 0;
        for (int iElem = 0; iElem < bufferInput[0].length; ++iElem) {
            r = bufferInput[0][iElem] & 0xFF;
            g = bufferInput[1][iElem] & 0xFF;
            b = bufferInput[2][iElem] & 0xFF;
            for (int j = 0; j < this.relX; ++j) {
                for (int k = 0; k < this.relY; ++k) {
                    line = iLine * this.relX + j;
                    col = iElem * this.relY + k;
                    valorPanc = this.bufferPancr.getElemByte(line, col, 0) & 0xFF;
                    scale = (double)(3 * (valorPanc + this.coefBrovey)) / ((double)(r + g + b) + 1.0);
                    r1 = (double)r * scale;
                    g1 = (double)g * scale;
                    b1 = (double)b * scale;
                    this.rasterResult.setElem(line, col, 0, (byte)r1);
                    this.rasterResult.setElem(line, col, 1, (byte)g1);
                    this.rasterResult.setElem(line, col, 2, (byte)b1);
                }
            }
        }
    }

    private void processIHS(byte[][] bufferInput, int iLine) {
        int[] tmp = new int[3];
        int line = 0;
        int col = 0;
        for (int iElem = 0; iElem < bufferInput[0].length; ++iElem) {
            double[] xyz = this.colorConversion.RGBtoHSL(bufferInput[0][iElem] & 0xFF, bufferInput[1][iElem] & 0xFF, bufferInput[2][iElem] & 0xFF);
            for (int j = 0; j < this.relX; ++j) {
                for (int k = 0; k < this.relY; ++k) {
                    line = iLine * this.relX + j;
                    col = iElem * this.relY + k;
                    xyz[2] = (double)(this.bufferPancr.getElemByte(line, col, 0) & 0xFF) / 255.0 + this.coef;
                    tmp[0] = (int)(255.0 * xyz[0] / 360.0 + 0.5);
                    tmp[2] = (int)(xyz[2] * 255.0 + 0.5);
                    tmp[1] = (int)(xyz[1] * 255.0 + 0.5);
                    int[] uvw = this.colorConversion.HSLtoRGB(tmp[0], tmp[1], tmp[2]);
                    this.rasterResult.setElem(line, col, 0, (byte)uvw[0]);
                    this.rasterResult.setElem(line, col, 1, (byte)uvw[1]);
                    this.rasterResult.setElem(line, col, 2, (byte)uvw[2]);
                }
            }
        }
    }
}

