/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.statistics;

import java.util.Arrays;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.store.ParamsImpl;

public class TailTrimFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"tailTrim"};
    protected int count = 0;
    protected int tailSize = 0;
    protected int[] tailSizeList = null;
    protected int nSamples = 0;
    protected boolean removeMaxValue = false;
    protected int incX;
    protected int incY;
    protected double tailPercent = 0.0;
    protected double[] tailPercentList = null;
    public double percentSamples = 0.0;
    protected int[][] sample = null;
    protected double[][] sampleDec = null;
    protected Statistics stats = null;
    protected double[][] result = null;
    protected int posInit = 0;
    protected int posFin = 0;

    public TailTrimFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        block7: {
            block8: {
                super.pre();
                if (this.params.get("tail") != null) {
                    this.tailPercent = (Double)this.params.get("tail");
                }
                this.tailPercentList = (double[])this.params.get("tailList");
                if (this.params.get("samples") != null) {
                    this.percentSamples = (Double)this.params.get("samples");
                }
                if (this.params.get("remove") != null) {
                    this.removeMaxValue = (Boolean)this.params.get("remove");
                }
                this.stats = (Statistics)this.params.get("stats");
                if (this.tailPercentList != null) {
                    this.tailSizeList = new int[this.tailPercentList.length];
                }
                if (!this.exec) break block7;
                this.count = 0;
                if (this.percentSamples != 0.0) break block8;
                this.nSamples = this.height * this.width;
                this.tailSize = (int)Math.round(this.tailPercent * (double)this.nSamples);
                if (this.tailPercentList == null) break block7;
                for (int i = 0; i < this.tailPercentList.length; ++i) {
                    this.tailSizeList[i] = (int)Math.round(this.tailPercentList[i] * (double)this.nSamples);
                }
                break block7;
            }
            this.incX = Math.round(this.width / (int)Math.round(this.percentSamples * (double)this.width));
            this.incY = Math.round(this.height / (int)Math.round(this.percentSamples * (double)this.height));
            this.nSamples = (Math.round(this.width / this.incX) + 1) * (Math.round(this.height / this.incY) + 1);
            this.tailSize = (int)((double)this.nSamples * this.tailPercent);
            if (this.tailPercentList != null) {
                for (int i = 0; i < this.tailPercentList.length; ++i) {
                    this.tailSizeList[i] = (int)((double)this.nSamples * this.tailPercentList[i]);
                }
            }
        }
    }

    public void post() {
        if (this.exec) {
            int i;
            if (this.sample != null) {
                this.posInit = 0;
                this.posFin = this.sample[0].length - 1;
                for (i = 0; i < this.raster.getBandCount(); ++i) {
                    Arrays.sort(this.sample[i]);
                }
            } else {
                this.posInit = 0;
                this.posFin = this.sampleDec[0].length - 1;
                for (i = 0; i < this.raster.getBandCount(); ++i) {
                    Arrays.sort(this.sampleDec[i]);
                }
            }
            if (this.removeMaxValue) {
                if (this.sample != null) {
                    this.calcPosInitEnd();
                }
                if (this.sampleDec != null) {
                    this.calcPosInitEndDec();
                }
            }
            this.nSamples = this.posFin - this.posInit;
            this.tailSize = (int)((double)this.nSamples * this.tailPercent);
            if (this.tailPercentList != null) {
                for (i = 0; i < this.tailPercentList.length; ++i) {
                    this.tailSizeList[i] = (int)((double)this.nSamples * this.tailPercentList[i]);
                }
            }
        }
    }

    private void calcPosInitEnd() {
        int iBand;
        int i;
        for (i = 0; i < this.sample[0].length; ++i) {
            for (iBand = 0; iBand < this.raster.getBandCount(); ++iBand) {
                if (this.sample[iBand][i] == this.sample[iBand][0]) continue;
                this.posInit = i;
                break;
            }
            if (this.posInit != 0) break;
        }
        for (i = this.sample[0].length - 1; i > 0; --i) {
            for (iBand = 0; iBand < this.raster.getBandCount(); ++iBand) {
                if (this.sample[0][i] == this.sample[0][this.sample[0].length - 1]) continue;
                this.posFin = i;
                break;
            }
            if (this.posFin != this.sample[0].length - 1) break;
        }
    }

    private void calcPosInitEndDec() {
        int iBand;
        int i;
        for (i = 0; i < this.sampleDec[0].length; ++i) {
            for (iBand = 0; iBand < this.raster.getBandCount(); ++iBand) {
                if (this.sampleDec[iBand][i] == this.sampleDec[iBand][0]) continue;
                this.posInit = i;
                break;
            }
            if (this.posInit != 0) break;
        }
        for (i = this.sampleDec[0].length - 1; i > 0; --i) {
            for (iBand = 0; iBand < this.raster.getBandCount(); ++iBand) {
                if (this.sampleDec[0][i] == this.sampleDec[0][this.sampleDec[0].length - 1]) continue;
                this.posFin = i;
                break;
            }
            if (this.posFin != this.sampleDec[0].length - 1) break;
        }
    }

    public double getTailPercent() {
        return this.tailPercent;
    }

    public double[] getTailPercentList() {
        return this.tailPercentList;
    }

    public boolean removeMaxValue() {
        return this.removeMaxValue;
    }

    public String getGroup() {
        return "basics";
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("tail", new Double(this.tailPercent), -1, null);
        params.setParam("samples", new Double(this.percentSamples), -1, null);
        params.setParam("remove", new Boolean(this.removeMaxValue), -1, null);
        if (this.tailPercentList != null) {
            params.setParam("tailList", this.tailPercentList, -1, null);
        }
        return params;
    }

    public int getInRasterDataType() {
        return 0;
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public void process(int x, int y) {
    }

    public String[] getNames() {
        return names;
    }

    public boolean isVisible() {
        return false;
    }
}

