/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.process.vector;

import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.process.vector.Vectorization;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.jpotrace.Potrace;
import org.gvsig.jpotrace.PotraceException;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.store.QueryableRaster;

public class PotraceVectorization
implements Vectorization {
    private Buffer buffer = null;
    private Double cornerThreshold = null;
    private Integer despeckle = null;
    private Integer policy = null;
    private Double optimizationTolerance = null;
    private boolean curveOptimization = true;
    private Integer outputQuantization = null;
    private RasterQuery query = null;

    public PotraceVectorization(String file) throws QueryException, NotSupportedExtensionException, RasterDriverException, ProcessInterruptedException {
        this.setFile(file);
    }

    public PotraceVectorization(QueryableRaster dataset) throws ProcessInterruptedException, QueryException {
        this.setDataSource((RasterDataStore)dataset);
    }

    public PotraceVectorization(RasterDataStore dataSource) throws ProcessInterruptedException, QueryException {
        this.setDataSource(dataSource);
    }

    private void setFile(String file) throws QueryException, NotSupportedExtensionException, RasterDriverException, ProcessInterruptedException {
        RasterDataStore ds = null;
        try {
            ds = DefaultRasterManager.getInstance().getProviderServices().open(file);
        }
        catch (InitializeException e) {
            throw new RasterDriverException("Error opening file", (Exception)((Object)e));
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("Error opening file", (Exception)((Object)e));
        }
        this.setDataSource(ds);
    }

    private void setDataSource(RasterDataStore dataSource) throws ProcessInterruptedException, QueryException {
        this.query.setAllDrawableBands();
        this.query.setAreaOfInterest();
        this.setRasterBuffer(dataSource.query(this.query));
    }

    private void setRasterBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    private int enableBit(int value, int pos) {
        return value |= 1 << pos;
    }

    public void setCornerThreshold(double value) {
        this.cornerThreshold = new Double(value);
    }

    public void setOutputQuantization(int value) {
        this.outputQuantization = new Integer(value);
    }

    public void setDespeckle(int value) {
        this.despeckle = new Integer(value);
    }

    public void setPolicy(int value) {
        this.policy = new Integer(value);
    }

    public void setOptimizationTolerance(double value) {
        this.optimizationTolerance = new Double(value);
    }

    public boolean isEnabledCurveOptimization() {
        return this.curveOptimization;
    }

    public void setEnabledCurveOptimization(boolean value) {
        this.curveOptimization = value;
    }

    private String[] getParams() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("./potrace");
        if (this.cornerThreshold != null) {
            params.add("-a");
            params.add(this.cornerThreshold.toString());
        }
        if (this.despeckle != null) {
            params.add("-t");
            params.add(this.despeckle.toString());
        }
        if (this.outputQuantization != null) {
            params.add("-u");
            params.add(this.outputQuantization.toString());
        }
        if (this.policy != null) {
            String param = null;
            switch (this.policy) {
                case 0: {
                    param = "black";
                    break;
                }
                case 1: {
                    param = "white";
                    break;
                }
                case 3: {
                    param = "left";
                    break;
                }
                case 2: {
                    param = "right";
                    break;
                }
                case 4: {
                    param = "minority";
                    break;
                }
                case 5: {
                    param = "majority";
                    break;
                }
                case 6: {
                    param = "random";
                }
            }
            if (param != null) {
                params.add("-z");
                params.add(param);
            }
        }
        if (this.optimizationTolerance != null) {
            params.add("-O");
            params.add(this.optimizationTolerance.toString());
        }
        if (!this.curveOptimization) {
            params.add("-n");
        }
        String[] strings = new String[params.size()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = (String)params.get(i);
        }
        return strings;
    }

    public double[] VectorizeBuffer() {
        int dy = (this.buffer.getWidth() + 32 - 1) / 32;
        int[] bufferBits = new int[this.buffer.getHeight() * dy];
        for (int i = 0; i < bufferBits.length; ++i) {
            bufferBits[i] = 0;
        }
        int bit = 0;
        int pos = 0;
        for (int i = 0; i < this.buffer.getHeight(); ++i) {
            pos = (this.buffer.getHeight() - i - 1) * dy;
            bit = 0;
            for (int j = 0; j < this.buffer.getWidth(); ++j) {
                byte data = this.buffer.getElemByte(i, j, 0);
                if (data == 0) {
                    bufferBits[pos] = this.enableBit(bufferBits[pos], 31 - bit);
                }
                if (++bit < 32) continue;
                bit = 0;
                ++pos;
            }
        }
        try {
            return Potrace.vectorizeBufferRaster((int[])bufferBits, (int)this.buffer.getWidth(), (int)this.buffer.getHeight(), (String[])this.getParams());
        }
        catch (PotraceException potraceException) {
            return null;
        }
    }
}

