/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider.fusion;

import java.awt.geom.Rectangle2D;
import java.util.List;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.fusion.AbstractFusionMethod;
import org.gvsig.raster.impl.provider.fusion.FirstFusionMethod;
import org.gvsig.raster.impl.provider.fusion.PixelSquareStructure;

public class BufferListFusion {
    public static int FIRST = 0;
    public static int LAST = 0;
    public static int MIXED = 0;
    public static int MINIMUM = 0;
    public static int MAXIMUM = 0;
    public static int AVERAGE = 0;
    public static int COLOR_STATISTICS = 0;
    public static int COLOR_HISTOGRAM = 0;
    public static int COLOR_LINEAR_CORRELATION = 0;
    private List<Buffer> bufferList = null;
    private List<Extent> bboxList = null;
    private PixelSquareStructure pxSquare = null;
    private AbstractFusionMethod fusion = null;
    private int alphaBandNumber = -1;

    public BufferListFusion(List<Buffer> bufferList, PixelSquareStructure pxSquare, int fusionMethod) {
        this.bufferList = bufferList;
        if (pxSquare.bbox == null) {
            Extent bbox;
            pxSquare.bbox = bbox = this.getBoundingBox();
        }
        this.pxSquare = pxSquare;
        if (fusionMethod == FIRST) {
            this.fusion = new FirstFusionMethod(bufferList, pxSquare);
        }
    }

    public Buffer getWindow() {
        int col;
        int row;
        if (this.pxSquare.dataType == 0) {
            for (row = 0; row < this.pxSquare.buffer.getHeight(); ++row) {
                for (col = 0; col < this.pxSquare.buffer.getWidth(); ++col) {
                    int band;
                    boolean hasData = false;
                    for (band = 0; band < this.fusion.getBandCount(); ++band) {
                        Byte value = this.fusion.getByteValue(row, col, band);
                        if (value == null) continue;
                        this.pxSquare.buffer.setElem(row, col, band, value.byteValue());
                        hasData = true;
                        value = null;
                    }
                    for (band = this.fusion.getBandCount(); band < this.pxSquare.buffer.getBandCount(); ++band) {
                        this.pxSquare.buffer.setElem(row, col, band, (byte)-1);
                    }
                    if (this.alphaBandNumber == -1 || this.alphaBandNumber >= this.pxSquare.buffer.getBandCount()) continue;
                    if (hasData) {
                        this.pxSquare.buffer.setElem(row, col, this.alphaBandNumber, (byte)-1);
                        continue;
                    }
                    this.pxSquare.buffer.setElem(row, col, this.alphaBandNumber, (byte)0);
                }
            }
        }
        if (this.pxSquare.dataType == 4) {
            for (row = 0; row < this.pxSquare.buffer.getHeight(); ++row) {
                for (col = 0; col < this.pxSquare.buffer.getWidth(); ++col) {
                    int band;
                    for (band = 0; band < this.fusion.getBandCount(); ++band) {
                        this.pxSquare.buffer.setElem(row, col, band, this.fusion.getFloatValue(row, col, band).floatValue());
                    }
                    for (band = this.fusion.getBandCount(); band < this.pxSquare.buffer.getBandCount(); ++band) {
                        this.pxSquare.buffer.setElem(row, col, band, 0.0f);
                    }
                }
            }
        }
        return this.pxSquare.buffer;
    }

    protected void clearMaskBuffer(Buffer buf) {
        if (buf.getDataType() == 0) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                        buf.setElem(i, j, iBand, this.pxSquare.nodata.getValue().byteValue());
                    }
                }
            }
            return;
        }
        if (buf.getDataType() == 2) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                        buf.setElem(i, j, iBand, this.pxSquare.nodata.getValue().shortValue());
                    }
                }
            }
            return;
        }
        if (buf.getDataType() == 3) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                        buf.setElem(i, j, iBand, this.pxSquare.nodata.getValue().intValue());
                    }
                }
            }
            return;
        }
        if (buf.getDataType() == 4) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                        buf.setElem(i, j, iBand, this.pxSquare.nodata.getValue().floatValue());
                    }
                }
            }
            return;
        }
        if (buf.getDataType() == 5) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    for (int iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                        buf.setElem(i, j, iBand, this.pxSquare.nodata.getValue().doubleValue());
                    }
                }
            }
            return;
        }
    }

    private Extent getBoundingBox() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        if (this.bboxList != null) {
            for (int i = 0; i < this.bboxList.size(); ++i) {
                Extent e = this.bboxList.get(i);
                if (e.getMin().getX() < minX) {
                    minX = e.getMin().getX();
                }
                if (e.getMin().getY() < minY) {
                    minY = e.getMin().getY();
                }
                if (e.getMax().getX() > maxX) {
                    maxX = e.getMax().getX();
                }
                if (!(e.getMax().getY() > maxY)) continue;
                maxY = e.getMax().getY();
            }
        } else {
            for (int i = 0; i < this.bufferList.size(); ++i) {
                Rectangle2D e = this.bufferList.get(i).getDataExtent();
                if (e.getX() < minX) {
                    minX = e.getX();
                }
                if (e.getY() - e.getHeight() < minY) {
                    minY = e.getY() - e.getHeight();
                }
                if (e.getX() + e.getWidth() > maxX) {
                    maxX = e.getX() + e.getWidth();
                }
                if (!(e.getY() > maxY)) continue;
                maxY = e.getY();
            }
        }
        return new ExtentImpl(minX, minY, maxX, maxY);
    }

    public void dispose() {
        for (int i = 0; i < this.bufferList.size(); ++i) {
            this.bufferList.get(i).dispose();
        }
        this.bufferList.clear();
    }

    public void setAlphaBand(int alphaBandNumber) {
        this.alphaBandNumber = alphaBandNumber;
    }
}

