/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.raster.impl.datastruct.ColorItemImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DataStoreColorTable
implements ColorTable,
Cloneable {
    public static final String PERSISTENT_NAME = "DataStoreColorTable_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "DataStoreColorTable Persistent";
    private boolean paletteActive = true;
    protected List<ColorItem> colorItems = null;
    protected boolean interpolated = true;
    protected double[] range = null;
    protected byte[][] paletteByBand = null;
    protected String[] nameClass = null;
    protected String name = null;
    protected String filePath = null;
    private int errorColor = 8;

    public DataStoreColorTable() {
        this.name = "";
    }

    public DataStoreColorTable(String name) {
        this.name = name;
    }

    public DataStoreColorTable(ColorTable fp) {
        if (fp == null) {
            return;
        }
        DataStoreColorTable palette = null;
        if (!(fp instanceof DataStoreColorTable)) {
            return;
        }
        palette = (DataStoreColorTable)fp;
        this.range = palette.getRange();
        this.paletteActive = true;
        this.paletteByBand = palette.getColorTableByBand();
        this.nameClass = palette.getNameClass();
        this.name = palette.getName();
        this.filePath = palette.getFilePath();
        this.colorItems = palette.getColorItems();
        this.interpolated = palette.isInterpolated();
    }

    public DataStoreColorTable(List<ColorItem> colorItems, boolean compress) {
        this.colorItems = colorItems;
        this.sortPalette(colorItems);
        this.setInterpolated(false);
        if (compress) {
            this.compressPalette(colorItems);
        }
        this.applyPalette(colorItems);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void createPaletteFromColorItems(List<ColorItem> colorItems, boolean compress) {
        this.colorItems = colorItems;
        this.sortPalette(colorItems);
        if (compress) {
            this.compressPalette(colorItems);
        }
        this.applyPalette(colorItems);
        this.removeDuplicatedValues();
    }

    private boolean isEqualColor(Color c1, Color c2, int error) {
        if (c2 == null && c1 != null) {
            return false;
        }
        if (c1 == null && c2 != null) {
            return false;
        }
        if (c2.getRed() < c1.getRed() - error) {
            return false;
        }
        if (c2.getGreen() < c1.getGreen() - error) {
            return false;
        }
        if (c2.getBlue() < c1.getBlue() - error) {
            return false;
        }
        if (c2.getAlpha() < c1.getAlpha() - error) {
            return false;
        }
        if (c2.getRed() > c1.getRed() + error) {
            return false;
        }
        if (c2.getGreen() > c1.getGreen() + error) {
            return false;
        }
        if (c2.getBlue() > c1.getBlue() + error) {
            return false;
        }
        return c2.getAlpha() <= c1.getAlpha() + error;
    }

    private boolean isCorrectColor(ColorItem c1, ColorItem c2, ColorItem c3) {
        if (c3.getNameClass() != null && c3.getNameClass().length() > 0) {
            return false;
        }
        if (c3.getInterpolated() != 50.0) {
            return false;
        }
        if (c2.getInterpolated() != 50.0) {
            return false;
        }
        double max = c2.getValue() - c1.getValue();
        int r = c1.getColor().getRed() + (int)((double)(c2.getColor().getRed() - c1.getColor().getRed()) * (c3.getValue() - c1.getValue()) / max);
        int g = c1.getColor().getGreen() + (int)((double)(c2.getColor().getGreen() - c1.getColor().getGreen()) * (c3.getValue() - c1.getValue()) / max);
        int b = c1.getColor().getBlue() + (int)((double)(c2.getColor().getBlue() - c1.getColor().getBlue()) * (c3.getValue() - c1.getValue()) / max);
        int a = c1.getColor().getAlpha() + (int)((double)(c2.getColor().getAlpha() - c1.getColor().getAlpha()) * (c3.getValue() - c1.getValue()) / max);
        Color aux = new Color(r & 0xFF, g & 0xFF, b & 0xFF, a & 0xFF);
        return this.isEqualColor(c3.getColor(), aux, this.errorColor);
    }

    private boolean canDelete(int first, int last) {
        if (first >= this.getColorItems().size()) {
            return false;
        }
        if (last >= this.getColorItems().size()) {
            return false;
        }
        ColorItem c1 = this.getColorItems().get(first);
        ColorItem c2 = this.getColorItems().get(last);
        for (int i = first + 1; i < last; ++i) {
            if (this.isCorrectColor(c1, c2, this.getColorItems().get(i))) continue;
            return false;
        }
        return true;
    }

    public void removeDuplicatedValues() {
        for (int i = this.colorItems.size() - 2; i >= 0; --i) {
            if (i + 1 >= this.colorItems.size()) continue;
            ColorItem colorItem = this.colorItems.get(i + 1);
            ColorItem colorItem2 = this.colorItems.get(i);
            if (colorItem.getValue() != colorItem2.getValue() || !colorItem.getColor().equals(colorItem2.getColor())) continue;
            if (colorItem.getNameClass() == null || colorItem.getNameClass().length() == 0) {
                this.colorItems.remove(i + 1);
                continue;
            }
            if (colorItem2.getNameClass() == null || colorItem2.getNameClass().length() == 0) {
                this.colorItems.remove(i);
                continue;
            }
            if (colorItem.getNameClass() == null && !colorItem.getNameClass().equals(colorItem2.getNameClass())) continue;
            this.colorItems.remove(i);
        }
    }

    public boolean hasAlpha() {
        for (int i = 0; i < this.colorItems.size(); ++i) {
            ColorItem colorItem = this.colorItems.get(i);
            if (colorItem.getColor().getAlpha() == 255) continue;
            return true;
        }
        return false;
    }

    public void compressPalette() {
        this.compressPalette(this.colorItems);
    }

    public boolean isCompressible() {
        List cloneList = (List)((ArrayList)this.getColorItems()).clone();
        this.compressPalette(cloneList);
        return cloneList.size() != this.getColorItems().size();
    }

    private void compressPalette(List<ColorItem> colorItems) {
        this.removeDuplicatedValues();
        int size = -1;
        while (size != colorItems.size()) {
            int init = 0;
            int posMax = 2;
            size = colorItems.size();
            while (init < colorItems.size()) {
                if (posMax < colorItems.size() && this.canDelete(init, posMax)) {
                    ++posMax;
                    continue;
                }
                if (init + 2 < posMax && this.canDelete(init, posMax - 1)) {
                    for (int i = posMax - 2; i > init; --i) {
                        if (i >= colorItems.size()) continue;
                        colorItems.remove(i);
                    }
                }
                posMax = ++init + 2;
            }
        }
    }

    public byte[][] getColorTableByBand() {
        return this.paletteByBand;
    }

    public void setColorTable(int[] palette) {
        this.paletteByBand = new byte[palette.length][4];
        for (int i = 0; i < palette.length; ++i) {
            this.paletteByBand[i][0] = (byte)((palette[i] & 0xFF0000) >> 16);
            this.paletteByBand[i][1] = (byte)((palette[i] & 0xFF00) >> 8);
            this.paletteByBand[i][2] = (byte)(palette[i] & 0xFF);
            this.paletteByBand[i][3] = (byte)(palette[i] & 0xFFFFFFFF);
        }
    }

    public String[] getNameClass() {
        return this.nameClass;
    }

    public void setNameClass(String[] names) {
        this.nameClass = names;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Object clone() {
        DataStoreColorTable clone = null;
        try {
            clone = (DataStoreColorTable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.colorItems != null) {
            clone.colorItems = new ArrayList<ColorItem>();
            for (int i = 0; i < this.colorItems.size(); ++i) {
                clone.colorItems.add((ColorItemImpl)((ColorItemImpl)this.colorItems.get(i)).clone());
            }
        }
        clone.interpolated = this.interpolated;
        if (this.filePath != null) {
            clone.filePath = new String(this.filePath);
        }
        if (this.name != null) {
            clone.name = new String(this.name);
        }
        if (this.nameClass != null) {
            clone.nameClass = new String[this.nameClass.length];
            for (int i = 0; i < this.nameClass.length; ++i) {
                clone.nameClass[i] = this.nameClass[i];
            }
        }
        if (this.paletteByBand != null) {
            clone.paletteByBand = (byte[][])this.paletteByBand.clone();
            for (int i = 0; i < this.paletteByBand.length; ++i) {
                clone.paletteByBand[i] = (byte[])this.paletteByBand[i].clone();
            }
        }
        if (this.range != null) {
            clone.range = (double[])this.range.clone();
        }
        return clone;
    }

    private Color interpolatedColor(double value, int pos) {
        double perc2;
        double perc1;
        Color color2;
        Color color1;
        if (this.colorItems.size() <= 0) {
            return Color.black;
        }
        if (pos + 1 == this.colorItems.size()) {
            return this.colorItems.get(pos).getColor();
        }
        if (value <= this.colorItems.get(0).getValue()) {
            return this.colorItems.get(0).getColor();
        }
        ColorItem item1 = this.colorItems.get(pos);
        ColorItem item2 = this.colorItems.get(pos + 1);
        double percValue = (value - item1.getValue()) * 100.0 / (item2.getValue() - item1.getValue());
        Color halfColor = new Color(item2.getColor().getRed() + item1.getColor().getRed() >> 1, item2.getColor().getGreen() + item1.getColor().getGreen() >> 1, item2.getColor().getBlue() + item1.getColor().getBlue() >> 1, item2.getColor().getAlpha() + item1.getColor().getAlpha() >> 1);
        if (percValue > item2.getInterpolated()) {
            color1 = halfColor;
            color2 = item2.getColor();
            perc1 = item2.getInterpolated();
            perc2 = 100.0;
        } else {
            color1 = item1.getColor();
            color2 = halfColor;
            perc1 = 0.0;
            perc2 = item2.getInterpolated();
        }
        double percNew = (percValue - perc1) / (perc2 - perc1);
        Color newColor = new Color((int)((double)color1.getRed() + (double)(color2.getRed() - color1.getRed()) * percNew) & 0xFF, (int)((double)color1.getGreen() + (double)(color2.getGreen() - color1.getGreen()) * percNew) & 0xFF, (int)((double)color1.getBlue() + (double)(color2.getBlue() - color1.getBlue()) * percNew) & 0xFF, (int)((double)color1.getAlpha() + (double)(color2.getAlpha() - color1.getAlpha()) * percNew) & 0xFF);
        return newColor;
    }

    public byte[] getRGBAByBand(double value) {
        for (int i = 1; i <= this.range.length; ++i) {
            if (i < this.range.length) {
                if (!(value < this.range[i])) continue;
                return this.paletteByBand[i - 1];
            }
            return this.paletteByBand[i - 1];
        }
        return new byte[4];
    }

    private void sortPalette(List<ColorItem> colorItems) {
        for (int i = 0; i < colorItems.size(); ++i) {
            for (int j = i + 1; j < colorItems.size(); ++j) {
                if (!(colorItems.get(j).getValue() < colorItems.get(i).getValue())) continue;
                ColorItem aux = colorItems.get(i);
                colorItems.set(i, colorItems.get(j));
                colorItems.set(j, aux);
            }
        }
    }

    private void applyPalette(List<ColorItem> colorItems) {
        int i;
        double max;
        ArrayList<ColorItemImpl> arrayColors = new ArrayList<ColorItemImpl>();
        this.range = new double[0];
        this.nameClass = new String[0];
        if (colorItems.size() == 0) {
            return;
        }
        double min = colorItems.get(0).getValue();
        if (min > (max = colorItems.get(colorItems.size() - 1).getValue())) {
            double aux = max;
            max = min;
            min = aux;
        }
        Color color = Color.white;
        Color colorOld = null;
        int defaultColors = RasterLibrary.defaultNumberOfColors;
        for (i = 0; i < defaultColors; ++i) {
            double value = min + (double)i * (max - min) / (double)(defaultColors - 1);
            int pos = 0;
            for (int j = 1; j <= colorItems.size(); ++j) {
                if (j < colorItems.size()) {
                    if (!(value < colorItems.get(j).getValue())) continue;
                    pos = j - 1;
                    break;
                }
                pos = j - 1;
                break;
            }
            if (this.interpolated) {
                color = this.interpolatedColor(value, pos);
            } else {
                double max2;
                double min2;
                if (pos + 1 < colorItems.size() && (min2 = colorItems.get(pos).getValue()) + ((max2 = colorItems.get(pos + 1).getValue()) - min2) * colorItems.get(pos + 1).getInterpolated() / 100.0 < value) {
                    ++pos;
                }
                color = colorItems.get(pos).getColor();
            }
            if (!this.isEqualColor(color, colorOld, 0)) {
                ColorItemImpl colorItem = new ColorItemImpl();
                colorItem.setValue(value);
                colorItem.setColor(color);
                arrayColors.add(colorItem);
            }
            colorOld = color;
        }
        this.paletteByBand = new byte[arrayColors.size()][4];
        this.range = new double[arrayColors.size()];
        this.nameClass = new String[arrayColors.size()];
        for (i = 0; i < arrayColors.size(); ++i) {
            this.paletteByBand[i][0] = (byte)((ColorItem)arrayColors.get(i)).getColor().getRed();
            this.paletteByBand[i][1] = (byte)((ColorItem)arrayColors.get(i)).getColor().getGreen();
            this.paletteByBand[i][2] = (byte)((ColorItem)arrayColors.get(i)).getColor().getBlue();
            this.paletteByBand[i][3] = (byte)((ColorItem)arrayColors.get(i)).getColor().getAlpha();
            this.range[i] = ((ColorItem)arrayColors.get(i)).getValue();
            this.nameClass[i] = ((ColorItem)arrayColors.get(i)).getNameClass();
        }
    }

    public double[] getRange() {
        return this.range;
    }

    public void setRange(double[] range) {
        this.range = range;
    }

    public List<ColorItem> getColorItems() {
        return this.colorItems;
    }

    public boolean isInterpolated() {
        return this.interpolated;
    }

    public void setInterpolated(boolean interpolated) {
        this.interpolated = interpolated;
        this.applyPalette(this.colorItems);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.colorItems == null ? 0 : this.colorItems.hashCode());
        result = 31 * result + this.errorColor;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.interpolated ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + DataStoreColorTable.hashCode(this.nameClass);
        result = 31 * result + DataStoreColorTable.hashCode((Object[])this.paletteByBand);
        result = 31 * result + DataStoreColorTable.hashCode(this.range);
        return result;
    }

    private static int hashCode(Object[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
        }
        return result;
    }

    private static int hashCode(double[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            long temp = Double.doubleToLongBits(array[index]);
            result = 31 * result + (int)(temp ^ temp >>> 32);
        }
        return result;
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataStoreColorTable other = (DataStoreColorTable)obj;
        if (this.colorItems == null && other.colorItems != null || this.colorItems != null && other.colorItems == null) {
            return false;
        }
        if (this.colorItems != null) {
            if (this.colorItems.size() != other.colorItems.size()) {
                return false;
            }
            for (i = 0; i < this.colorItems.size(); ++i) {
                if (this.colorItems.get(i).equals(other.colorItems.get(i))) continue;
                return false;
            }
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nameClass != null) {
            if (other.nameClass == null) {
                return false;
            }
            if (this.nameClass.length != other.nameClass.length) {
                return false;
            }
            for (i = 0; i < this.nameClass.length; ++i) {
                if (!(this.nameClass[i] != null ? !this.nameClass[i].equals(other.nameClass[i]) : other.nameClass[i] != null)) continue;
                return false;
            }
        }
        if (this.paletteByBand == null && other.paletteByBand != null || this.paletteByBand != null && other.paletteByBand == null) {
            return false;
        }
        if (this.paletteByBand != null) {
            for (i = 0; i < this.paletteByBand.length; ++i) {
                for (int j = 0; j < this.paletteByBand[i].length; ++j) {
                    if (this.paletteByBand[i][j] == other.paletteByBand[i][j]) continue;
                    return false;
                }
            }
        }
        if (!Arrays.equals(this.range, other.range)) {
            return false;
        }
        return (this.colorItems != null || other.colorItems == null) && (this.colorItems == null || other.colorItems != null);
    }

    public void createColorTableInRange(double min, double max, boolean compress) {
        ColorItem colorItem;
        int i;
        double max2 = Double.NEGATIVE_INFINITY;
        double min2 = Double.POSITIVE_INFINITY;
        if (min > max) {
            double aux = min;
            min = max;
            max = aux;
        }
        ArrayList<ColorItem> arrayList = new ArrayList<ColorItem>();
        List<ColorItem> items = this.getColorItems();
        for (i = 0; i < items.size(); ++i) {
            colorItem = items.get(i);
            if (colorItem.getValue() > max2) {
                max2 = colorItem.getValue();
            }
            if (!(colorItem.getValue() < min2)) continue;
            min2 = colorItem.getValue();
        }
        if (items.size() > 0) {
            colorItem = items.get(0);
        } else {
            colorItem = new ColorItemImpl();
            colorItem.setValue(0.0);
            colorItem.setColor(Color.black);
        }
        arrayList.add(colorItem);
        for (i = 0; i < items.size(); ++i) {
            colorItem = items.get(i);
            colorItem.setValue(min + (colorItem.getValue() - min2) * (max - min) / (max2 - min2));
            arrayList.add(colorItem);
        }
        if (items.size() > 0) {
            colorItem = items.get(items.size() - 1);
        } else {
            colorItem = new ColorItemImpl();
            colorItem.setValue(255.0);
            colorItem.setColor(Color.white);
        }
        arrayList.add(colorItem);
        this.createPaletteFromColorItems(arrayList, compress);
    }

    public boolean isPaletteActive() {
        return this.paletteActive;
    }

    public void setPaletteActive(boolean paletteActive) {
        this.paletteActive = paletteActive;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List aux;
        List colorItems;
        List nameClass;
        this.paletteActive = state.getBoolean("paletteActive");
        this.interpolated = state.getBoolean("interpolated");
        this.errorColor = state.getInt("errorColor");
        this.filePath = state.getString("filePath");
        this.name = state.getString("name");
        List range = state.getList("range");
        if (range != null) {
            this.range = new double[range.size()];
            for (int i = 0; i < range.size(); ++i) {
                this.range[i] = (Double)range.get(i);
            }
        }
        if ((nameClass = state.getList("nameClass")) != null) {
            this.nameClass = new String[nameClass.size()];
            nameClass.toArray(this.nameClass);
        }
        if ((colorItems = state.getList("colorItems")) != null) {
            this.colorItems = new ArrayList<ColorItem>();
            this.colorItems.addAll(colorItems);
        }
        if ((aux = state.getList("paletteByBand")) != null) {
            this.paletteByBand = null;
            for (int i = 0; i < aux.size(); ++i) {
                String[] values = ((String)aux.get(i)).split("#");
                if (this.paletteByBand == null) {
                    if (values.length == 3) {
                        this.paletteByBand = new byte[aux.size()][3];
                    }
                    if (values.length == 4) {
                        this.paletteByBand = new byte[aux.size()][4];
                    }
                }
                this.paletteByBand[i][0] = Byte.valueOf(values[0]);
                this.paletteByBand[i][1] = Byte.valueOf(values[1]);
                this.paletteByBand[i][2] = Byte.valueOf(values[2]);
                if (values.length != 4) continue;
                this.paletteByBand[i][3] = Byte.valueOf(values[3]);
            }
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("paletteActive", this.paletteActive);
        state.set("interpolated", this.interpolated);
        state.set("errorColor", this.errorColor);
        state.set("filePath", this.filePath);
        state.set("name", this.name);
        state.set("range", this.range);
        state.set("nameClass", this.nameClass);
        state.set("colorItems", this.colorItems);
        ArrayList<String> list = new ArrayList<String>();
        if (this.paletteByBand != null) {
            String entry = null;
            for (int i = 0; i < this.paletteByBand.length; ++i) {
                entry = this.paletteByBand[i][0] + "#" + this.paletteByBand[i][1] + "#" + this.paletteByBand[i][2];
                if (this.paletteByBand[0].length > 3) {
                    entry = entry + "#" + this.paletteByBand[i][3];
                }
                list.add(entry);
            }
            state.set("paletteByBand", list);
        } else {
            state.setNull("paletteByBand");
        }
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DataStoreColorTable.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldBoolean("paletteActive").setMandatory(true);
            definition.addDynFieldBoolean("interpolated").setMandatory(true);
            definition.addDynFieldInt("errorColor").setMandatory(false);
            definition.addDynFieldString("filePath").setMandatory(false);
            definition.addDynFieldString("name").setMandatory(false);
            definition.addDynFieldList("range").setClassOfItems(Double.class).setMandatory(false);
            definition.addDynFieldList("nameClass").setClassOfItems(String.class).setMandatory(false);
            definition.addDynFieldList("colorItems").setClassOfItems(ColorItem.class).setMandatory(false);
            definition.addDynFieldList("paletteByBand").setClassOfItems(String.class).setMandatory(false);
        }
    }
}

