/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.RemoteRasterProvider;
import org.gvsig.raster.impl.store.properties.SimpleProviderStatistics;

public class RemoteDataStoreStatistics
extends SimpleProviderStatistics {
    public RemoteDataStoreStatistics(RasterProvider prov) {
        super(prov);
    }

    @Override
    public void calculate(double scale) throws FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        int iBand;
        if (this.provider == null || !(this.provider instanceof RemoteRasterProvider)) {
            return;
        }
        RemoteRasterProvider prov = (RemoteRasterProvider)this.provider;
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        this.percent = 0;
        this.bandCount = this.provider.getBandCount();
        this.max = new double[this.bandCount];
        this.min = new double[this.bandCount];
        this.secondMax = new double[this.bandCount];
        this.secondMin = new double[this.bandCount];
        this.maxByteUnsigned = new double[this.bandCount];
        this.minByteUnsigned = new double[this.bandCount];
        this.secondMaxByteUnsigned = new double[this.bandCount];
        this.secondMinByteUnsigned = new double[this.bandCount];
        this.mean = new double[this.bandCount];
        this.variance = new double[this.bandCount];
        long[] iValues = new long[this.bandCount];
        boolean[] initializedBand = new boolean[this.bandCount];
        int[] type = new int[this.bandCount];
        double z = 0.0;
        double rgb = 0.0;
        for (int iBand2 = 0; iBand2 < this.bandCount; ++iBand2) {
            this.max[iBand2] = Double.NEGATIVE_INFINITY;
            this.min[iBand2] = Double.POSITIVE_INFINITY;
            this.secondMax[iBand2] = Double.NEGATIVE_INFINITY;
            this.secondMin[iBand2] = Double.POSITIVE_INFINITY;
            this.maxByteUnsigned[iBand2] = 0.0;
            this.minByteUnsigned[iBand2] = 255.0;
            this.secondMaxByteUnsigned[iBand2] = 0.0;
            this.secondMinByteUnsigned[iBand2] = 255.0;
            initializedBand[iBand2] = false;
            type[iBand2] = this.provider.getDataType()[iBand2];
        }
        Buffer buf = prov.getBufferLastRequest();
        if (buf == null) {
            return;
        }
        for (iBand = 0; iBand < buf.getBandCount(); ++iBand) {
            for (int col = 0; col < buf.getWidth(); ++col) {
                for (int row = 0; row < buf.getHeight(); ++row) {
                    double d = buf.getDataType() == 0 ? (double)buf.getElemByte(row, col, iBand) : (buf.getDataType() == 2 ? (double)buf.getElemShort(row, col, iBand) : (buf.getDataType() == 5 ? buf.getElemDouble(row, col, iBand) : (buf.getDataType() == 4 ? (double)buf.getElemFloat(row, col, iBand) : (z = buf.getDataType() == 3 ? (double)buf.getElemInt(row, col, iBand) : 0.0))));
                    if (this.provider.getNoDataValue().isDefined() && z == this.provider.getNoDataValue().getValue().doubleValue() || Double.isNaN(z)) continue;
                    rgb = 0.0;
                    if (buf.getDataType() == 0) {
                        rgb = (byte)z & 0xFF;
                        int n = iBand;
                        this.mean[n] = this.mean[n] + rgb;
                        int n2 = iBand;
                        this.variance[n2] = this.variance[n2] + rgb * rgb;
                    } else {
                        int n = iBand;
                        this.mean[n] = this.mean[n] + z;
                        int n3 = iBand;
                        this.variance[n3] = this.variance[n3] + z * z;
                    }
                    int n = iBand;
                    iValues[n] = iValues[n] + 1L;
                    if (!initializedBand[iBand]) {
                        this.secondMin[iBand] = this.min[iBand];
                        this.secondMax[iBand] = this.max[iBand];
                        this.min[iBand] = z;
                        this.max[iBand] = z;
                        this.secondMinByteUnsigned[iBand] = this.minByteUnsigned[iBand];
                        this.secondMaxByteUnsigned[iBand] = this.maxByteUnsigned[iBand];
                        this.minByteUnsigned[iBand] = rgb;
                        this.maxByteUnsigned[iBand] = rgb;
                        initializedBand[iBand] = true;
                        continue;
                    }
                    if (z < this.secondMin[iBand]) {
                        if (z < this.min[iBand]) {
                            this.secondMin[iBand] = this.min[iBand];
                            this.min[iBand] = z;
                        } else if (z > this.min[iBand]) {
                            this.secondMin[iBand] = z;
                        }
                    }
                    if (z > this.secondMax[iBand]) {
                        if (z > this.max[iBand]) {
                            this.secondMax[iBand] = this.max[iBand];
                            this.max[iBand] = z;
                        } else if (z < this.max[iBand]) {
                            this.secondMax[iBand] = z;
                        }
                    }
                    if (rgb < this.secondMinByteUnsigned[iBand]) {
                        if (rgb < this.minByteUnsigned[iBand]) {
                            this.secondMinByteUnsigned[iBand] = this.minByteUnsigned[iBand];
                            this.minByteUnsigned[iBand] = rgb;
                        } else if (rgb > this.minByteUnsigned[iBand]) {
                            this.secondMinByteUnsigned[iBand] = rgb;
                        }
                    }
                    if (!(rgb > this.secondMaxByteUnsigned[iBand])) continue;
                    if (rgb > this.maxByteUnsigned[iBand]) {
                        this.secondMaxByteUnsigned[iBand] = this.maxByteUnsigned[iBand];
                        this.maxByteUnsigned[iBand] = rgb;
                        continue;
                    }
                    if (!(rgb < this.maxByteUnsigned[iBand])) continue;
                    this.secondMaxByteUnsigned[iBand] = rgb;
                }
            }
            if (task.getEvent() != null) {
                task.manageEvent(task.getEvent());
            }
            this.percent = this.bandCount * 100 / buf.getBandCount();
        }
        this.percent = 100;
        for (iBand = 0; iBand < this.bandCount; ++iBand) {
            if (iValues[iBand] <= 0L) continue;
            this.mean[iBand] = this.mean[iBand] / (double)iValues[iBand];
            this.variance[iBand] = this.variance[iBand] / (double)iValues[iBand] - this.mean[iBand] * this.mean[iBand];
        }
        this.calculated = true;
        this.forceToRecalc = false;
        try {
            this.provider.saveObjectToRmf(Statistics.class, this);
        }
        catch (RmfSerializerException rmfSerializerException) {
            // empty catch block
        }
    }
}

