/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.serializer;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class GeoInfoRmfSerializer
extends ClassSerializer {
    public static final String MAIN_TAG = "FLyrGeoRaster";
    public static final String EXTENT = "Extent";
    public static final String X = "X";
    public static final String Y = "Y";
    public static final String ROTX = "RotationX";
    public static final String ROTY = "RotationY";
    public static final String PSX = "PixelSizeX";
    public static final String PSY = "PixelSizeY";
    public static final String W = "Width";
    public static final String H = "Height";
    public static final String DIM = "Dimension";
    public static final String IMGW = "ImagePxWidth";
    public static final String IMGH = "ImagePxHeight";
    private AbstractRasterProvider provider = null;
    private AffineTransform at = null;
    private Point2D dim = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append("GeoInfo", "", GeoInfoRmfSerializer.class);
    }

    public GeoInfoRmfSerializer(AbstractRasterProvider dataset) {
        this.provider = dataset;
    }

    public GeoInfoRmfSerializer(AffineTransform at, Point2D dim) {
        this.at = at;
        this.dim = dim;
    }

    public GeoInfoRmfSerializer() {
    }

    @Override
    public void read(String xml) throws ParsingException {
        double x = 0.0;
        double y = 0.0;
        double rotX = 0.0;
        double rotY = 0.0;
        double psX = 0.0;
        double psY = 0.0;
        double imgW = 0.0;
        double imgH = 0.0;
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        try {
            int tag = parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, MAIN_TAG);
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo(MAIN_TAG) != 0) break;
                            x = Double.parseDouble(this.parserString(parser, X, null));
                            y = Double.parseDouble(this.parserString(parser, Y, null));
                            rotX = Double.parseDouble(this.parserString(parser, ROTX, null));
                            rotY = Double.parseDouble(this.parserString(parser, ROTY, null));
                            psX = Double.parseDouble(this.parserString(parser, PSX, null));
                            psY = Double.parseDouble(this.parserString(parser, PSY, null));
                            Double.parseDouble(this.parserString(parser, W, null));
                            Double.parseDouble(this.parserString(parser, H, null));
                            imgW = Double.parseDouble(this.parserString(parser, IMGW, null));
                            imgH = Double.parseDouble(this.parserString(parser, IMGH, null));
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
            ((Reader)reader).close();
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        catch (IOException e) {
            throw new ParsingException(xml);
        }
        this.dim = new Point2D.Double(imgW, imgH);
        this.at = new AffineTransform(psX, rotY, rotX, psY, x, y);
        if (this.provider != null) {
            this.provider.setAffineTransform(this.at);
        }
    }

    @Override
    public String write() {
        StringBuffer b = new StringBuffer();
        if (this.provider != null) {
            this.at = this.provider.getAffineTransform();
            this.dim = new Point2D.Double(this.provider.getWidth(), this.provider.getHeight());
        }
        b.append("<FLyrGeoRaster>\n");
        b.append("\t<Extent>\n");
        this.putProperty(b, X, this.at.getTranslateX(), 3);
        this.putProperty(b, Y, this.at.getTranslateY(), 3);
        this.putProperty(b, ROTX, this.at.getShearX(), 3);
        this.putProperty(b, ROTY, this.at.getShearY(), 3);
        double wd = 0.0;
        double hd = 0.0;
        if (this.provider != null) {
            wd = this.provider.getExtent().getMax().getX() - this.provider.getExtent().getMin().getX();
            hd = this.provider.getExtent().getMax().getY() - this.provider.getExtent().getMin().getY();
        }
        this.putProperty(b, PSX, this.at.getScaleX(), 3);
        this.putProperty(b, PSY, this.at.getScaleY(), 3);
        this.putProperty(b, W, wd, 3);
        this.putProperty(b, H, hd, 3);
        b.append("\t</Extent>\n");
        b.append("\t<Dimension>\n");
        this.putProperty(b, IMGW, this.dim.getX(), 3);
        this.putProperty(b, IMGH, this.dim.getY(), 3);
        b.append("\t</Dimension>\n");
        b.append("</FLyrGeoRaster>\n");
        return b.toString();
    }

    @Override
    public Object getResult() {
        return this.provider;
    }

    @Override
    public String getMainTag() {
        return MAIN_TAG;
    }
}

