/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.serializer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class ROIFileRmfSerializer
extends ClassSerializer {
    private final String MAIN_TAG = "ROI";
    private List<File> fileList = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append("ROI", "", ROIFileRmfSerializer.class);
    }

    public ROIFileRmfSerializer(List<File> file) {
        this.fileList = file;
    }

    public ROIFileRmfSerializer() {
    }

    @Override
    public String getMainTag() {
        return "ROI";
    }

    @Override
    public Object getResult() {
        return this.fileList;
    }

    @Override
    public void read(String xml) throws ParsingException {
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        try {
            int tag = parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, "ROI");
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (!parser.getName().equals("ROIFile")) break;
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                if (!parser.getAttributeName(i).equals("value")) continue;
                                if (this.fileList == null) {
                                    this.fileList = new ArrayList<File>();
                                }
                                this.fileList.add(new File(parser.getAttributeValue(i)));
                            }
                            break;
                        }
                    }
                    tag = parser.next();
                }
            }
            ((Reader)reader).close();
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        catch (IOException e) {
            throw new ParsingException(xml);
        }
    }

    @Override
    public String write() throws IOException {
        if (this.fileList == null || this.fileList.size() == 0) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        b.append("<ROI>\n");
        for (int i = 0; i < this.fileList.size(); ++i) {
            if (this.fileList.get(i) == null) continue;
            b.append("\t<ROIFile");
            b.append(" value=\"" + this.fileList.get(i).getAbsolutePath() + "\"/>\n");
            b.append("</ROI>\n");
        }
        return b.toString();
    }
}

