/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.util;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.raster.impl.datastruct.BufferHistogramImpl;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.store.rmf.RmfBlocksManager;
import org.gvsig.raster.impl.store.serializer.GeoInfoRmfSerializer;
import org.gvsig.raster.roi.ROI;

public class DefaultRasterUtils
implements RasterUtils {
    public static final int MAX_BYTE_BIT_VALUE = 255;
    public static final int MAX_SHORT_BIT_VALUE = 65535;

    public boolean loadInMemory(RasterDataStore datasource) {
        return datasource.getFileSize() < RasterLibrary.cacheSize * 0x100000L;
    }

    public boolean isBufferTooBig(double[] coords, int bands) {
        int h;
        int w = (int)Math.abs(coords[2] - coords[0]);
        long windowSize = w * (h = (int)Math.abs(coords[3] - coords[1])) * bands;
        return windowSize > RasterLibrary.cacheSize * 0x100000L;
    }

    public boolean isBufferTooBig(double[] coords, double resolution, int bands) {
        double wPx = (coords[0] - coords[2]) / resolution;
        double hPx = (coords[1] - coords[3]) / resolution;
        return this.isBufferTooBig(new double[]{0.0, 0.0, wPx, hPx}, bands);
    }

    public int getRasterBufTypeFromMrSIDType(int mrsidType) {
        switch (mrsidType) {
            case 0: {
                return 32;
            }
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 5: 
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
        }
        return 32;
    }

    public int getBytesFromRasterBufType(int rasterBufType) {
        switch (rasterBufType) {
            case 0: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case -1: 
            case 3: 
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
        }
        return 0;
    }

    public long getBytesFromRaster(int width, int height, int rasterType, int nBands) {
        int typeSize = this.getBytesFromRasterBufType(rasterType);
        return (long)width * (long)height * (long)nBands * (long)typeSize;
    }

    public String typesToString(int type) {
        switch (type) {
            case -1: {
                return new String("Image");
            }
            case 0: {
                return new String("Byte");
            }
            case 5: {
                return new String("Double");
            }
            case 4: {
                return new String("Float");
            }
            case 3: {
                return new String("Integer");
            }
            case 1: 
            case 2: {
                return new String("Short");
            }
            case 32: {
                return new String("Undefined");
            }
        }
        return null;
    }

    public String parserGdalProj(String proj) {
        if (proj == null) {
            return "";
        }
        String[] list = proj.split(",");
        int level = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].indexOf("[") >= 0) {
                ++level;
                String spaces = "";
                for (int j = 0; j < level; ++j) {
                    spaces = spaces + "&nbsp;&nbsp;";
                }
                list[i] = spaces + list[i];
            }
            if (list[i].indexOf("]]") >= 0) {
                level -= 2;
                continue;
            }
            if (list[i].indexOf("]") < 0) continue;
            --level;
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            if (i >= list.length) continue;
            if (i + 1 < list.length && list[i + 1].indexOf("[") >= 0) {
                str.append(list[i] + ",<BR>");
                continue;
            }
            str.append(list[i] + ",");
        }
        return str.toString();
    }

    public Rectangle2D getPxRectFromMapRect(Rectangle2D extent, double widthPx, double heightPx, Rectangle2D window) {
        double widthWC = extent.getWidth();
        double heightWC = extent.getHeight();
        double wWindowWC = Math.abs(window.getMaxX() - window.getMinX());
        double hWindowWC = Math.abs(window.getMaxY() - window.getMinY());
        double wWindowPx = wWindowWC * widthPx / widthWC;
        double hWindowPx = hWindowWC * heightPx / heightWC;
        double initDistanceX = Math.abs(window.getMinX() - extent.getMinX());
        double initDistanceY = Math.abs(window.getMaxY() - extent.getMaxY());
        double initPxX = initDistanceX * widthPx / widthWC;
        double initPxY = initDistanceY * heightPx / heightWC;
        Rectangle2D.Double pxRec = new Rectangle2D.Double(initPxX, initPxY, wWindowPx, hWindowPx);
        return pxRec;
    }

    public Rectangle2D getMapRectFromPxRect(Rectangle2D extent, double widthPx, double heightPx, Rectangle2D pxWindow) {
        double wWindowWC = pxWindow.getWidth() * extent.getWidth() / widthPx;
        double hWindowWC = pxWindow.getHeight() * extent.getHeight() / heightPx;
        double initWCX = extent.getMinX() + pxWindow.getMinX() * extent.getWidth() / widthPx;
        double initWCY = extent.getMaxY() - pxWindow.getMinY() * extent.getHeight() / heightPx;
        Rectangle2D.Double mapRec = new Rectangle2D.Double(initWCX, initWCY - hWindowWC, wWindowWC, hWindowWC);
        return mapRec;
    }

    public Point2D worldPointToRaster(Point2D p, Extent ext, int pxWidth, int pxHeight) {
        double x = p.getX() - ext.getMin().getX();
        double y = p.getY() - ext.getMin().getY();
        int pxX = (int)(x * (double)pxWidth / ext.width());
        int pxY = (int)(y * (double)pxHeight / ext.height());
        return new Point2D.Double(pxX, pxY);
    }

    public boolean intersects(Extent e1, Extent e2, AffineTransform at) throws NoninvertibleTransformException {
        Point2D.Double ulPxE1 = new Point2D.Double();
        Point2D.Double lrPxE1 = new Point2D.Double();
        Point2D.Double ulPxE2 = new Point2D.Double();
        Point2D.Double lrPxE2 = new Point2D.Double();
        at.inverseTransform(new Point2D.Double(e1.getULX(), e1.getULY()), ulPxE1);
        at.inverseTransform(new Point2D.Double(e1.getLRX(), e1.getLRY()), lrPxE1);
        at.inverseTransform(new Point2D.Double(e2.getULX(), e2.getULY()), ulPxE2);
        at.inverseTransform(new Point2D.Double(e2.getLRX(), e2.getLRY()), lrPxE2);
        return (((Point2D)ulPxE1).getX() <= ((Point2D)lrPxE2).getX() && ((Point2D)lrPxE1).getX() >= ((Point2D)lrPxE2).getX() || ((Point2D)ulPxE1).getX() <= ((Point2D)ulPxE2).getX() && ((Point2D)lrPxE1).getX() >= ((Point2D)ulPxE2).getX() || ((Point2D)ulPxE1).getX() >= ((Point2D)ulPxE2).getX() && ((Point2D)lrPxE1).getX() <= ((Point2D)lrPxE2).getX()) && (((Point2D)ulPxE1).getY() <= ((Point2D)lrPxE2).getY() && ((Point2D)lrPxE1).getY() >= ((Point2D)lrPxE2).getY() || ((Point2D)ulPxE1).getY() <= ((Point2D)ulPxE2).getY() && ((Point2D)lrPxE1).getY() >= ((Point2D)ulPxE2).getY() || ((Point2D)ulPxE1).getY() >= ((Point2D)ulPxE2).getY() && ((Point2D)lrPxE1).getY() <= ((Point2D)lrPxE2).getY());
    }

    public Extent intersection(Extent e1, Extent e2) {
        if (e1.getMin().getX() > e2.getMax().getX() || e1.getMax().getX() < e2.getMin().getX() || e1.getMin().getY() > e2.getMax().getY() || e1.getMax().getY() < e2.getMin().getY()) {
            return null;
        }
        double ulx = Math.max(e1.getULX(), e2.getULX());
        double uly = Math.min(e1.getULY(), e2.getULY());
        double lrx = Math.min(e1.getLRX(), e2.getLRX());
        double lry = Math.max(e1.getLRY(), e2.getLRY());
        return new ExtentImpl(ulx, uly, lrx, lry);
    }

    public boolean isInside(Point2D p1, Extent e1, AffineTransform at) {
        Point2D.Double p1Px = new Point2D.Double();
        Point2D.Double ulPx = new Point2D.Double();
        Point2D.Double lrPx = new Point2D.Double();
        try {
            at.inverseTransform(p1, p1Px);
            at.inverseTransform(new Point2D.Double(e1.getULX(), e1.getULY()), ulPx);
            at.inverseTransform(new Point2D.Double(e1.getLRX(), e1.getLRY()), lrPx);
        }
        catch (NoninvertibleTransformException e) {
            return false;
        }
        return ((Point2D)p1Px).getX() >= ((Point2D)ulPx).getX() && ((Point2D)p1Px).getX() <= ((Point2D)lrPx).getX() && ((Point2D)p1Px).getY() >= ((Point2D)ulPx).getY() && ((Point2D)p1Px).getY() <= ((Point2D)lrPx).getY();
    }

    public boolean isInside(Extent e1, Extent e2) {
        return e1.getMin().getX() >= e2.getMin().getX() && e1.getMin().getY() >= e2.getMin().getY() && e1.getMax().getX() <= e2.getMax().getX() && e1.getMax().getY() <= e2.getMax().getY();
    }

    public boolean isInside(Point2D p1, Extent e1) {
        return p1.getX() >= e1.getMin().getX() && p1.getX() <= e1.getMax().getX() && p1.getY() >= e1.getMin().getY() && p1.getY() <= e1.getMax().getY();
    }

    public boolean isOutside(Extent e1, Extent ref) {
        return e1.getMin().getX() > ref.getMax().getX() || e1.getMin().getY() > ref.getMax().getY() || e1.getMax().getX() < ref.getMin().getX() || e1.getMax().getY() < ref.getMin().getY();
    }

    public boolean compareExtents(Extent e1, Extent e2) {
        return e1.getMin().getX() == e2.getMin().getX() && e1.getMin().getY() == e2.getMin().getY() && e1.getMax().getX() == e2.getMax().getX() && e1.getMax().getY() == e2.getMax().getY();
    }

    public double[] cornersToWorldFile(Point2D[] esq, Dimension size) {
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double d = 0.0;
        double e = 0.0;
        double f = 0.0;
        double x1 = esq[0].getX();
        double y1 = esq[0].getY();
        double x2 = esq[1].getX();
        double y2 = esq[1].getY();
        double x3 = esq[2].getX();
        double y3 = esq[2].getY();
        double x4 = esq[3].getX();
        double y4 = esq[3].getY();
        a = Math.abs(Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2)) / size.getWidth());
        e = -Math.abs(Math.sqrt((x1 - x4) * (x1 - x4) + (y1 - y4) * (y1 - y4)) / size.getHeight());
        c = x1;
        f = y1;
        b = (a * size.getWidth() + c - x3) / size.getHeight() * -1.0;
        d = (e * size.getHeight() + f - y3) / size.getWidth() * -1.0;
        double[] wf = new double[]{a, d, b, e, c, f};
        return wf;
    }

    public void adjustToPixelSize(Point2D[] points, Point2D dim) {
        for (int i = 0; i < points.length; ++i) {
            if (points[i].getX() < 0.0) {
                points[i].setLocation(0.0, points[i].getY());
            }
            if ((double)((int)points[i].getX()) > dim.getX() - 1.0) {
                points[i].setLocation(dim.getX() - 1.0, points[i].getY());
            }
            if (points[i].getY() < 0.0) {
                points[i].setLocation(points[i].getX(), 0.0);
            }
            if (!((double)((int)points[i].getY()) > dim.getY() - 1.0)) continue;
            points[i].setLocation(points[i].getX(), dim.getY() - 1.0);
        }
    }

    public String getTrace(Exception e) {
        int i;
        Throwable throwable = e;
        String r = "";
        StackTraceElement[] elemList = throwable.getStackTrace();
        for (i = 0; i < elemList.length; ++i) {
            r = r + "   !!!-" + elemList[i].toString() + "\n";
        }
        while (throwable.getCause() != null) {
            elemList = throwable.getCause().getStackTrace();
            for (i = 0; i < elemList.length; ++i) {
                r = r + "   !!!-" + elemList[i].toString() + "\n";
            }
            throwable = throwable.getCause();
        }
        return r;
    }

    public String formatTime(long time) {
        int days = 0;
        int hours = 0;
        int minuts = 0;
        int seconds = (int)((double)time / 1000.0);
        if (seconds >= 60) {
            minuts = seconds / 60;
            seconds -= minuts * 60;
            if (minuts >= 60) {
                hours = minuts / 60;
                minuts -= hours * 60;
                if (hours >= 24) {
                    days = hours / 24;
                    hours -= days * 24;
                }
            }
        }
        StringBuffer s = new StringBuffer();
        if (days != 0) {
            s.append(days + " d ");
        }
        if (hours != 0) {
            s.append(hours + " h ");
        }
        if (minuts != 0) {
            s.append(minuts + " min ");
        }
        if (seconds != 0) {
            s.append(seconds + " s ");
        }
        if (s.length() == 0) {
            s.append(" < 1s");
        }
        return s.toString();
    }

    public String[] getCoord(double minx, double miny, double maxx, double maxy, int dec) {
        String[] coordPx = new String[4];
        int indexPoint = String.valueOf(minx).indexOf(46);
        try {
            coordPx[0] = String.valueOf(minx).substring(0, indexPoint + dec);
        }
        catch (StringIndexOutOfBoundsException ex) {
            coordPx[0] = String.valueOf(minx);
        }
        indexPoint = String.valueOf(miny).indexOf(46);
        try {
            coordPx[1] = String.valueOf(miny).substring(0, indexPoint + dec);
        }
        catch (StringIndexOutOfBoundsException ex) {
            coordPx[1] = String.valueOf(miny);
        }
        indexPoint = String.valueOf(maxx).indexOf(46);
        try {
            coordPx[2] = String.valueOf(maxx).substring(0, indexPoint + dec);
        }
        catch (StringIndexOutOfBoundsException ex) {
            coordPx[2] = String.valueOf(maxx);
        }
        indexPoint = String.valueOf(maxy).indexOf(46);
        try {
            coordPx[3] = String.valueOf(maxy).substring(0, indexPoint + dec);
        }
        catch (StringIndexOutOfBoundsException ex) {
            coordPx[3] = String.valueOf(maxy);
        }
        return coordPx;
    }

    public Extent calculateAdjustedView(Extent extToAdj, Extent imgExt) {
        double vx = extToAdj.minX();
        double vy = extToAdj.minY();
        double vx2 = extToAdj.maxX();
        double vy2 = extToAdj.maxY();
        if (extToAdj.minX() < imgExt.minX()) {
            vx = imgExt.minX();
        }
        if (extToAdj.minY() < imgExt.minY()) {
            vy = imgExt.minY();
        }
        if (extToAdj.maxX() > imgExt.maxX()) {
            vx2 = imgExt.maxX();
        }
        if (extToAdj.maxY() > imgExt.maxY()) {
            vy2 = imgExt.maxY();
        }
        return new ExtentImpl(vx, vy, vx2, vy2);
    }

    public Extent calculateAdjustedView(Extent extToAdj, AffineTransform at, double w, double h) {
        Point2D.Double src_ul = new Point2D.Double(extToAdj.getULX(), extToAdj.getULY());
        Point2D.Double src_lr = new Point2D.Double(extToAdj.getLRX(), extToAdj.getLRY());
        Point2D.Double ul = new Point2D.Double();
        Point2D.Double lr = new Point2D.Double();
        try {
            at.inverseTransform(src_ul, ul);
            at.inverseTransform(src_lr, lr);
        }
        catch (NoninvertibleTransformException e) {
            return extToAdj;
        }
        if (((Point2D)ul).getX() < 0.0) {
            ((Point2D)ul).setLocation(0.0, ((Point2D)ul).getY());
        }
        if (((Point2D)ul).getX() >= w) {
            ((Point2D)ul).setLocation(w, ((Point2D)ul).getY());
        }
        if (((Point2D)ul).getY() < 0.0) {
            ((Point2D)ul).setLocation(((Point2D)ul).getX(), 0.0);
        }
        if (((Point2D)ul).getY() >= h) {
            ((Point2D)ul).setLocation(((Point2D)ul).getX(), h);
        }
        if (((Point2D)lr).getX() < 0.0) {
            ((Point2D)lr).setLocation(0.0, ((Point2D)lr).getY());
        }
        if (((Point2D)lr).getX() >= w) {
            ((Point2D)lr).setLocation(w, ((Point2D)lr).getY());
        }
        if (((Point2D)lr).getY() < 0.0) {
            ((Point2D)lr).setLocation(((Point2D)lr).getX(), 0.0);
        }
        if (((Point2D)lr).getY() >= h) {
            ((Point2D)lr).setLocation(((Point2D)lr).getX(), h);
        }
        Point2D.Double real_ul = new Point2D.Double();
        Point2D.Double real_lr = new Point2D.Double();
        at.transform(ul, real_ul);
        at.transform(lr, real_lr);
        return new ExtentImpl(real_ul, real_lr);
    }

    public void saveGeoInfo(String outRmf, AffineTransform at, Point2D dim) throws IOException {
        RmfBlocksManager manager = new RmfBlocksManager(outRmf + ".rmf");
        GeoInfoRmfSerializer ser3 = new GeoInfoRmfSerializer(at, dim);
        manager.addClient(ser3);
        manager.write();
    }

    public Extent getROIsMaximunExtent(List<ROI> rois) {
        double minx = 0.0;
        double miny = 0.0;
        double maxx = 0.0;
        double maxy = 0.0;
        for (int i = 0; i < rois.size(); ++i) {
            Extent ext = rois.get(i).getROIExtent();
            if (i == 0) {
                minx = ext.minX();
                miny = ext.minY();
                maxx = ext.maxX();
                maxy = ext.maxY();
                continue;
            }
            if (ext.minX() < minx) {
                minx = ext.minX();
            }
            if (ext.minY() < miny) {
                miny = ext.minY();
            }
            if (ext.maxX() > maxx) {
                maxx = ext.maxX();
            }
            if (!(ext.maxY() > maxy)) continue;
            maxy = ext.maxY();
        }
        return RasterLocator.getManager().getDataStructFactory().createExtent(minx, miny, maxx, maxy);
    }

    public BufferHistogram convertHistogramToRGB(BufferHistogram histogram) {
        int j;
        int i;
        if (histogram == null || !(histogram instanceof BufferHistogramImpl)) {
            return null;
        }
        BufferHistogramImpl histImp = (BufferHistogramImpl)histogram;
        if (histImp.getDataType() != 0) {
            return histogram;
        }
        double min = histImp.getMin(0);
        double max = histImp.getMax(0);
        long[][] table2 = histImp.getTable();
        long[][] newTable = new long[table2.length][table2[0].length];
        for (i = 0; i < table2.length; ++i) {
            for (j = 0; j < table2[i].length; ++j) {
                newTable[i][j] = 0L;
            }
        }
        for (i = 0; i < table2.length; ++i) {
            for (j = 0; j < table2[i].length; ++j) {
                double val = (double)j * (max - min) / 255.0 + min;
                int pos = (int)val & 0xFF;
                if (pos < 0) {
                    pos = 0;
                }
                if (pos >= newTable[i].length) {
                    pos = newTable[i].length - 1;
                }
                long[] lArray = newTable[i];
                int n = pos;
                lArray[n] = lArray[n] + table2[i][j];
            }
        }
        double[] mins = new double[histImp.getNumBands()];
        double[] maxs = new double[histImp.getNumBands()];
        for (int i2 = 0; i2 < mins.length; ++i2) {
            mins[i2] = 0.0;
            maxs[i2] = 255.0;
        }
        BufferHistogramImpl histogramNew = new BufferHistogramImpl(histImp.getNumBands(), mins, maxs, 0);
        histogramNew.setTable(newTable);
        return histogramNew;
    }

    public void copyToBuffer(Buffer bufResult, Extent tileExtent, Buffer buf, Extent ex, double rel, boolean hasAlphaBand) {
        int j;
        int i;
        int iBand;
        double distx = Math.abs(ex.getULX() - tileExtent.getULX());
        double disty = Math.abs(ex.getULY() - tileExtent.getULY());
        int distpxx = (int)Math.round(distx / rel);
        int distpxy = (int)Math.round(disty / rel);
        int lastBandNumber = bufResult.getBandCount() - 1;
        if (bufResult.getDataType() == 0) {
            for (iBand = 0; iBand < lastBandNumber; ++iBand) {
                if (iBand == 0) {
                    for (i = distpxy; i < bufResult.getHeight() && i - distpxy < buf.getHeight(); ++i) {
                        for (j = distpxx; j < bufResult.getWidth() && j - distpxx < buf.getWidth(); ++j) {
                            bufResult.setElem(i, j, iBand, buf.getElemByte(i - distpxy, j - distpxx, iBand));
                            bufResult.setElem(i, j, lastBandNumber, (byte)-1);
                        }
                    }
                    continue;
                }
                for (i = distpxy; i < bufResult.getHeight() && i - distpxy < buf.getHeight(); ++i) {
                    for (j = distpxx; j < bufResult.getWidth() && j - distpxx < buf.getWidth(); ++j) {
                        bufResult.setElem(i, j, iBand, buf.getElemByte(i - distpxy, j - distpxx, iBand));
                    }
                }
            }
            if (hasAlphaBand) {
                for (int i2 = distpxy; i2 < bufResult.getHeight() && i2 - distpxy < buf.getHeight(); ++i2) {
                    for (int j2 = distpxx; j2 < bufResult.getWidth() && j2 - distpxx < buf.getWidth(); ++j2) {
                        byte value = buf.getElemByte(i2 - distpxy, j2 - distpxx, lastBandNumber);
                        if (value == 255) continue;
                        bufResult.setElem(i2, j2, lastBandNumber, value);
                    }
                }
            }
        }
        if (bufResult.getDataType() == 2) {
            for (iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                for (i = distpxy; i < bufResult.getHeight() && i - distpxy < buf.getHeight(); ++i) {
                    for (j = distpxx; j < bufResult.getWidth() && j - distpxx < buf.getWidth(); ++j) {
                        bufResult.setElem(i, j, iBand, buf.getElemShort(i - distpxy, j - distpxx, iBand));
                    }
                }
            }
        }
        if (bufResult.getDataType() == 3) {
            for (iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                for (i = distpxy; i < bufResult.getHeight() && i - distpxy < buf.getHeight(); ++i) {
                    for (j = distpxx; j < bufResult.getWidth() && j - distpxx < buf.getWidth(); ++j) {
                        bufResult.setElem(i, j, iBand, buf.getElemInt(i - distpxy, j - distpxx, iBand));
                    }
                }
            }
        }
        if (bufResult.getDataType() == 4) {
            for (iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                for (i = distpxy; i < bufResult.getHeight() && i - distpxy < buf.getHeight(); ++i) {
                    for (j = distpxx; j < bufResult.getWidth() && j - distpxx < buf.getWidth(); ++j) {
                        bufResult.setElem(i, j, iBand, buf.getElemFloat(i - distpxy, j - distpxx, iBand));
                    }
                }
            }
        }
        if (bufResult.getDataType() == 5) {
            for (iBand = 0; iBand < buf.getBandCount(); ++iBand) {
                for (i = distpxy; i < bufResult.getHeight() && i - distpxy < buf.getHeight(); ++i) {
                    for (j = distpxx; j < bufResult.getWidth() && j - distpxx < buf.getWidth(); ++j) {
                        bufResult.setElem(i, j, iBand, buf.getElemDouble(i - distpxy, j - distpxx, iBand));
                    }
                }
            }
        }
    }
}

