/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypePanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.ReferenceNotRegisteredException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFeatureTypeForVCSGisRepository
extends AbstractAction {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExportFeatureTypeForVCSGisRepository.class);

    public ExportFeatureTypeForVCSGisRepository() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("Name", i18n.getTranslation("_Export_for_a_VCSGis_repository"));
        this.putValue("ActionCommandKey", "ExportFeatureTypeForVCSGisRepository");
    }

    @Override
    public Object getValue(String key) {
        if ("Name".equals(key)) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            return i18n.getTranslation("_Export_for_a_VCSGis_repository");
        }
        return super.getValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JDBCServerExplorer explorer = null;
        try {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            FeatureTypePanel featureTypePanel = (FeatureTypePanel)e.getSource();
            EditableFeatureType featureType = featureTypePanel.fetch(null);
            String tableName = featureType.getTags().getString("vcsgis.storename", null);
            if (StringUtils.isBlank((CharSequence)tableName)) {
                dialogs.messageDialog("Es preciso asignar el tag 'vcsgis.storename' indicando el nombre de la tabla del repositorio para poder realizar esta operacion.", i18n.getTranslation("_Export_for_a_VCSGis_repository"), 0);
                return;
            }
            JDBCProviderNamesPanel accesory = new JDBCProviderNamesPanel();
            Object[] f = dialogs.showChooserDialog("Fichero SQL", 1, 0, false, null, null, false, (JComponent)accesory);
            if (ArrayUtils.isEmpty((Object[])f)) {
                return;
            }
            String providerName = accesory.getProviderName();
            DataManager dataManager = DALLocator.getDataManager();
            DataServerExplorerParameters params = dataManager.createServerExplorerParameters(providerName);
            explorer = (JDBCServerExplorer)dataManager.openServerExplorer(providerName, params);
            SQLBuilder sqlbuilder = explorer.createSQLBuilder();
            String json = featureType.toJsonBuilder().toString();
            String sql = "UPDATE VCSGISREPO_ENTITIES SET ENT_FEATURETYPE = " + sqlbuilder.as_clob(json) + " WHERE ENT_NAME = '" + tableName + "';";
            FileUtils.write((File)f[0], (CharSequence)sql, (Charset)StandardCharsets.UTF_8);
            DisposeUtils.disposeQuietly((Disposable)explorer);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't create SQL file", (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly(explorer);
        }
    }

    public static void selfRegister() {
        try {
            ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
            cfgActionsManager.addConfigurableAction("FeatureTypePanel", (Action)new ExportFeatureTypeForVCSGisRepository());
        }
        catch (ReferenceNotRegisteredException ex) {
            LOGGER.warn("Can't register ExportFeatureTypeForVCSGisRepository action.", (Throwable)ex);
        }
    }

    private static class JDBCProviderNamesPanel
    extends JPanel {
        private JComboBox<String> cboProviderNames;

        public JDBCProviderNamesPanel() {
            this.initComponents();
        }

        private void initComponents() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.setLayout(new GridBagLayout());
            JLabel lblLabel = new JLabel(i18n.getTranslation("_Database"));
            lblLabel.setAlignmentX(0.0f);
            this.add((Component)lblLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 19, 2, new Insets(1, 2, 1, 2), 0, 0));
            this.cboProviderNames = new JComboBox();
            this.add(this.cboProviderNames, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 19, 2, new Insets(1, 2, 1, 2), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 19, 1, new Insets(0, 0, 0, 0), 0, 0));
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            model.addElement("H2Spatial");
            model.addElement("PostgreSQL");
            model.addElement("Oracle");
            this.cboProviderNames.setModel(model);
            this.cboProviderNames.setSelectedIndex(0);
        }

        public String getProviderName() {
            return (String)this.cboProviderNames.getSelectedItem();
        }
    }
}

