/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionDialog;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceDescriptor;
import org.gvsig.vcsgis.swing.VCSWorkspacePickerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSWorkspacePickerControllerImpl
extends AbstractPickerController<VCSGisWorkspace>
implements VCSWorkspacePickerController,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSWorkspacePickerControllerImpl.class);
    private final JComboBox<VCSGisWorkspaceDescriptor> cboWorkspace;
    private final JButton btnWorkspace;

    public static final void selfRegister() {
        ToolsSwingUtils.registerIcons(VCSWorkspacePickerControllerImpl.class, (String)"/org/gvsig/vcsgis/swing/impl/images", (String)"VCSGis", (String[][])new String[][]{{"picker", "picker-vcsgis-workingcopy", "picker-vcsgis"}});
    }

    public VCSWorkspacePickerControllerImpl(JComboBox cboWorkspaces, JButton btnInitWorkspace) {
        this.cboWorkspace = cboWorkspaces;
        if (btnInitWorkspace == null) {
            btnInitWorkspace = new JButton();
        }
        this.btnWorkspace = btnInitWorkspace;
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnWorkspace, (String)"_Select_a_working_copy", (String)"picker-vcsgis-workingcopy", e -> this.doAddConnection(), null);
        this.fillWorkspaces(this.cboWorkspace);
        this.cboWorkspace.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VCSGisWorkspaceDescriptor descriptor = (VCSGisWorkspaceDescriptor)VCSWorkspacePickerControllerImpl.this.cboWorkspace.getSelectedItem();
                    LOGGER.info("WorkspacePiccker fireChangeEvent" + Objects.toString(descriptor));
                    String url = "";
                    if (descriptor.getExplorerParameters() != null) {
                        url = descriptor.getExplorerParameters().getUrl();
                    }
                    VCSWorkspacePickerControllerImpl.this.cboWorkspace.setToolTipText(url);
                    SwingUtilities.invokeLater(() -> VCSWorkspacePickerControllerImpl.this.fireChangeEvent(new ChangeEvent(e)));
                }
            }
        });
    }

    private void doAddConnection() {
        JDBCConnectionDialog dialog = DALSwingLocator.getSwingManager().createJDBCConectionDialog();
        dialog.showDialog();
        if (dialog.isCanceled()) {
            return;
        }
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerPool pool = dataManager.getDataServerExplorerPool();
        JDBCServerExplorerParameters connectionParameters = dialog.getServerExplorerParameters();
        pool.add(dialog.getConnectionName(), (DataServerExplorerParameters)connectionParameters);
        this.fillWorkspaces(this.cboWorkspace);
        ListElement.setSelected(this.cboWorkspace, (Object)connectionParameters);
    }

    public VCSGisWorkspace get() {
        VCSGisWorkspaceDescriptor descriptor = (VCSGisWorkspaceDescriptor)this.cboWorkspace.getSelectedItem();
        if (descriptor == null) {
            return null;
        }
        return descriptor.getWorkspace();
    }

    public void set(VCSGisWorkspace value) {
        if (value == null) {
            this.cboWorkspace.setSelectedIndex(-1);
            return;
        }
        ComboBoxModel<VCSGisWorkspaceDescriptor> model = this.cboWorkspace.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            VCSGisWorkspaceDescriptor descriptor = (VCSGisWorkspaceDescriptor)model.getElementAt(i);
            if (!descriptor.getCode().equalsIgnoreCase(value.getCode())) continue;
            this.cboWorkspace.setSelectedIndex(i);
            String url = "";
            if (descriptor.getExplorerParameters() != null) {
                url = descriptor.getExplorerParameters().getUrl();
            }
            this.cboWorkspace.setToolTipText(url);
            return;
        }
        this.cboWorkspace.setToolTipText("");
        this.cboWorkspace.setSelectedIndex(-1);
    }

    public void coerceAndSet(Object value) {
        VCSGisWorkspace workspace;
        try {
            workspace = (VCSGisWorkspace)value;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't coerce value to vcsgisWorkspace", ex);
        }
        this.set(workspace);
    }

    public void setEnabled(boolean enabled) {
        this.cboWorkspace.setEnabled(enabled);
        this.btnWorkspace.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.cboWorkspace.isEnabled();
    }

    private void fillWorkspaces(JComboBox cboWorkspaces) {
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        Map workspaceDescriptors = manager.getWorkspaces();
        cboWorkspaces.removeAllItems();
        ArrayList descriptors = new ArrayList(workspaceDescriptors.values());
        descriptors.sort(new CompareUtils.NullSafeComparator<VCSGisWorkspaceDescriptor>(){

            public int safeCompare(VCSGisWorkspaceDescriptor o1, VCSGisWorkspaceDescriptor o2) {
                return StringUtils.compare((String)o1.getLabel(), (String)o2.getLabel());
            }
        });
        for (VCSGisWorkspaceDescriptor workspaceDescriptor : descriptors) {
            cboWorkspaces.addItem(workspaceDescriptor);
        }
        cboWorkspaces.setSelectedIndex(-1);
    }

    public void dispose() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

