/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.importhistory;

import java.io.File;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.documentfilters.IntegerDocumentFilter;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisEntitySelectorController;
import org.gvsig.vcsgis.swing.VCSGisJImportHistory;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.VCSGisSwingCommons;
import org.gvsig.vcsgis.swing.impl.importhistory.ImportHistoryView;
import org.gvsig.vcsgis.swing.impl.importhistory.ImportProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHistoryImpl
extends ImportHistoryView
implements Component,
VCSGisJImportHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportHistoryImpl.class);
    private static final int HISTORY_TYPE_UNKNOWN = -1;
    private static final int HISTORY_WITH_REVISION_DATE = 0;
    private static final int HISTORY_WITH_REVISION_NUMBER = 1;
    private static final int TAB_LAYERS_INDEX = 0;
    private static final int TAB_TABLES_INDEX = 1;
    private PickerController<VCSGisWorkspace> workspacePicker;
    private Dialog dialog;
    private boolean processing = false;
    private TaskStatusController taskStatusController;
    private AttributeDescriptorPickerController identifierFieldPicker;
    private AttributeDescriptorPickerController sortFieldPicker;
    private AttributeDescriptorPickerController efectiveDateFieldPicker;
    private AttributeDescriptorPickerController revisionDateFieldPicker;
    private AttributeDescriptorPickerController revisionNumberFieldPicker;
    private VCSGisEntitySelectorController targetEntitySelector;
    private ExpressionPickerController deletedConditionPicker;
    private File lastLog = null;

    public ImportHistoryImpl() {
        this.initComponents();
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        DataSwingManager dalSwingManager = DALSwingLocator.getDataSwingManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.translate();
        this.taskStatusController = taskStatusManager.createTaskStatusController(null, this.lblStatusTitle, this.lblStatusMessages, this.pbStatus, this.btnStatusCancel, null);
        this.taskStatusController.setShowCancelButton(true);
        this.taskStatusController.setShowRemoveTaskButton(false);
        SwingUtilities.invokeLater(() -> this.setVisibleStatus(false));
        this.txtNumberInsertToChangeToAppendMode.setText("20");
        this.txtNumberInsertToChangeToAppendMode.setEnabled(false);
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspace, this.btnWorkspace);
        this.workspacePicker.addChangeListener(e -> this.doChangeWorkspace());
        this.tabAddToWorkspace.addChangeListener(e -> this.doChangedSourceStore());
        this.targetEntitySelector = VCSGisSwingLocator.getVCSGisSwingManager().createEntitySelectorController(this.cboTargetTable);
        this.targetEntitySelector.setFilter(VCSGisEntitySelectorController.LOCAL_ENTITIES);
        this.targetEntitySelector.setViewFilter(VCSGisEntitySelectorController.LOCAL_ENTITIES);
        this.targetEntitySelector.setChecksEnabled(false);
        this.targetEntitySelector.addChangeListener(e -> this.doChangedTargetEntity());
        this.targetEntitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 2: {
                    this.doUpdateComponents();
                }
            }
        });
        this.treeLayers.setModel(services.getFeatureStoresTreeModel());
        this.treeLayers.getSelectionModel().setSelectionMode(1);
        this.treeLayers.getSelectionModel().addTreeSelectionListener(e -> this.doChangedSourceStore());
        this.treeLayers.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public java.awt.Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof FeatureStore) {
                    label.setText(((FeatureStore)value).getName());
                }
                return label;
            }
        });
        this.lstTables.setModel(services.getFeatureStoresListModel());
        this.lstTables.getSelectionModel().setSelectionMode(0);
        this.lstTables.getSelectionModel().addListSelectionListener(e -> this.doChangedSourceStore());
        this.lstTables.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public java.awt.Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof FeatureStore) {
                    label.setText(((FeatureStore)value).getName());
                }
                return label;
            }
        });
        this.identifierFieldPicker = dalSwingManager.createAttributeDescriptorPickerController(this.cboIdentifierField, t -> {
            if (t.getType() == 66) {
                return false;
            }
            return !t.isComputed();
        });
        this.identifierFieldPicker.setAllowNull(true);
        this.identifierFieldPicker.addChangeListener(e -> SwingUtilities.invokeLater(() -> this.doChangedIdentifierField()));
        this.sortFieldPicker = dalSwingManager.createAttributeDescriptorPickerController(this.cboSortField, t -> {
            if (t.getType() == 66) {
                return false;
            }
            return !t.isComputed();
        });
        this.sortFieldPicker.setAllowNull(true);
        this.sortFieldPicker.addChangeListener(e -> SwingUtilities.invokeLater(() -> this.doChangedSortField()));
        this.efectiveDateFieldPicker = dalSwingManager.createAttributeDescriptorPickerController(this.cboEfectiveDateField, t -> {
            if (t.getType() == 66) {
                return false;
            }
            return !t.isComputed();
        });
        this.efectiveDateFieldPicker.setAllowNull(true);
        this.revisionDateFieldPicker = dalSwingManager.createAttributeDescriptorPickerController(this.cboRevisionDateField, t -> {
            if (t.getType() == 66) {
                return false;
            }
            return !t.isComputed();
        });
        this.revisionDateFieldPicker.setAllowNull(true);
        this.revisionDateFieldPicker.addChangeListener(e -> SwingUtilities.invokeLater(() -> this.doChangedDateField()));
        this.revisionNumberFieldPicker = dalSwingManager.createAttributeDescriptorPickerController(this.cboRevisionCodeField, t -> {
            if (!t.getDataType().isNumeric()) {
                return false;
            }
            return !t.isComputed();
        });
        this.revisionNumberFieldPicker.setAllowNull(true);
        this.revisionNumberFieldPicker.addChangeListener(e -> SwingUtilities.invokeLater(() -> this.doChangedRevisionNumberField()));
        this.deletedConditionPicker = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtDeletedCondition, this.btnDeletedConditionBuilder, this.btnDeletedConditionBookmarks, this.btnDeletedConditionHistory);
        this.rdbMinimizeMemory.setSelected(true);
        this.rdbMinimizeTime.setSelected(false);
        this.rdbBalancesTimeAndMemory.setSelected(false);
        IntegerDocumentFilter.install((JTextField)this.txtTimeInterval);
        this.txtTimeInterval.setText("1");
        DefaultComboBoxModel<LabeledValueImpl> timeIntervalUnitsModel = new DefaultComboBoxModel<LabeledValueImpl>();
        timeIntervalUnitsModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Minutes"), (Object)ChronoUnit.MINUTES));
        timeIntervalUnitsModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Hours"), (Object)ChronoUnit.HOURS));
        timeIntervalUnitsModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Days"), (Object)ChronoUnit.DAYS));
        timeIntervalUnitsModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Weeks"), (Object)ChronoUnit.WEEKS));
        timeIntervalUnitsModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Months"), (Object)ChronoUnit.MONTHS));
        timeIntervalUnitsModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Years"), (Object)ChronoUnit.YEARS));
        this.cboTimeIntervalUnit.setModel(timeIntervalUnitsModel);
        this.cboTimeIntervalUnit.setSelectedIndex(2);
        this.rdbMinimizeMemory.setSelected(false);
        this.rdbMinimizeTime.setSelected(false);
        this.rdbBalancesTimeAndMemory.setSelected(true);
        this.tabHistoryType.setEnabled(true);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)24, (int)90, (int)26, (int)110);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.doUpdateComponents();
    }

    private FeatureStore getTargetStore() {
        VCSGisWorkspace workspace = this.getWorkspace();
        if (workspace == null) {
            return null;
        }
        VCSGisEntity targetEntity = this.targetEntitySelector.getSelectedEntity();
        if (targetEntity == null) {
            return null;
        }
        FeatureStore targetStore = workspace.openFeatureStore(targetEntity.getEntityName(), false);
        return targetStore;
    }

    private void doChangedTargetEntity() {
        this.checkIdentifier(true);
        this.doUpdateComponents();
    }

    private boolean checkIdentifier(boolean showRecommendations) {
        FeatureType targetFeatureType = null;
        FeatureStore targetStore = this.getTargetStore();
        if (targetStore != null) {
            targetFeatureType = targetStore.getDefaultFeatureTypeQuietly();
        }
        if (targetFeatureType == null) {
            return false;
        }
        FeatureAttributeDescriptor sourceAttrIdentifier = (FeatureAttributeDescriptor)this.identifierFieldPicker.get();
        if (sourceAttrIdentifier == null) {
            return false;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        FeatureAttributeDescriptor targetAttrIdentifier = targetFeatureType.getAttributeDescriptor(sourceAttrIdentifier.getName());
        if (targetAttrIdentifier == null) {
            dialogs.messageDialog(i18n.getTranslation("_The_field_selected_as_identifier_must_exist_in_the_target_table"), i18n.getTranslation("_VCS_Import_history"), 2);
            return false;
        }
        if (!targetAttrIdentifier.isIndexed() && !targetAttrIdentifier.isPrimaryKey()) {
            if (showRecommendations) {
                dialogs.messageDialog(i18n.getTranslation("_With_large_tables_it_is_highly_recommended_to_have_an_index_on_the_identifier_field"), i18n.getTranslation("_VCS_Import_history"), 1);
            }
            return true;
        }
        return true;
    }

    private void doChangedIdentifierField() {
        this.checkIdentifier(true);
        this.doUpdateComponents();
    }

    private void doChangedSortField() {
        this.doUpdateComponents();
        FeatureAttributeDescriptor sortfield = (FeatureAttributeDescriptor)this.sortFieldPicker.get();
        if (sortfield == null) {
            return;
        }
        if (sortfield.isIndexed() || sortfield.isPrimaryKey()) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        dialogs.messageDialog(i18n.getTranslation("_With_large_tables_it_is_highly_recommended_to_have_an_index_on_the_sort_field"), i18n.getTranslation("_VCS_Import_history"), 1);
    }

    private void doChangedDateField() {
        this.doUpdateComponents();
        FeatureAttributeDescriptor sortfield = (FeatureAttributeDescriptor)this.revisionDateFieldPicker.get();
        if (sortfield == null) {
            return;
        }
        if (sortfield.isIndexed() || sortfield.isPrimaryKey()) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        dialogs.messageDialog(i18n.getTranslation("_With_large_tables_it_is_highly_recommended_to_have_an_index_on_the_revision_date_field"), i18n.getTranslation("_VCS_Import_history"), 1);
    }

    private void doChangedRevisionNumberField() {
        this.doUpdateComponents();
        FeatureAttributeDescriptor revisionNumberfield = (FeatureAttributeDescriptor)this.revisionNumberFieldPicker.get();
        if (revisionNumberfield == null) {
            return;
        }
        if (revisionNumberfield.isIndexed() || revisionNumberfield.isPrimaryKey()) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        dialogs.messageDialog(i18n.getTranslation("_With_large_tables_it_is_highly_recommended_to_have_an_index_on_the_revision_number_field"), i18n.getTranslation("_VCS_Import_history"), 1);
    }

    private void doChangedSourceStore() {
        FeatureStore store = this.getSourceFeatureStore();
        if (store == null) {
            this.identifierFieldPicker.setFeatureType(null);
            this.sortFieldPicker.setFeatureType(null);
            this.revisionDateFieldPicker.setFeatureType(null);
            this.deletedConditionPicker.set(null);
            this.doUpdateComponents();
            return;
        }
        FeatureType featureType = store.getDefaultFeatureTypeQuietly();
        this.identifierFieldPicker.setFeatureType(featureType);
        this.sortFieldPicker.setFeatureType(featureType);
        this.revisionDateFieldPicker.setFeatureType(featureType);
        this.efectiveDateFieldPicker.setFeatureType(featureType);
        this.revisionNumberFieldPicker.setFeatureType(featureType);
        DataSwingManager dalSwingManager = DALSwingLocator.getDataSwingManager();
        this.deletedConditionPicker.getConfig().removeAllSymbolTables();
        dalSwingManager.configureExpressionBuilder(this.deletedConditionPicker.getConfig(), store);
        this.doUpdateComponents();
    }

    private void doUpdateComponents() {
        boolean okbuttonEnabled = true;
        boolean isProcessing = this.processing;
        this.tabAddToWorkspace.setEnabled(!isProcessing);
        this.workspacePicker.setEnabled(!isProcessing);
        VCSGisWorkspace workspace = this.getWorkspace();
        if (workspace == null) {
            this.targetEntitySelector.setEnabled(false);
        } else {
            this.targetEntitySelector.setEnabled(!isProcessing);
        }
        VCSGisEntity targetEntity = this.targetEntitySelector.getSelectedEntity();
        if (targetEntity == null || !this.hasSourceStore()) {
            this.identifierFieldPicker.setEnabled(false);
            this.sortFieldPicker.setEnabled(false);
            this.deletedConditionPicker.setEnabled(false);
            this.cboRevisionDateField.setEnabled(false);
            this.txtTimeInterval.setEnabled(false);
            this.cboTimeIntervalUnit.setEnabled(false);
            this.cboEfectiveDateField.setEnabled(false);
            this.cboRevisionCodeField.setEnabled(false);
        } else {
            this.identifierFieldPicker.setEnabled(!isProcessing);
            this.sortFieldPicker.setEnabled(!isProcessing);
            this.deletedConditionPicker.setEnabled(!isProcessing);
            this.cboRevisionDateField.setEnabled(!isProcessing);
            this.txtTimeInterval.setEnabled(!isProcessing);
            this.cboTimeIntervalUnit.setEnabled(!isProcessing);
            this.cboEfectiveDateField.setEnabled(!isProcessing);
            this.cboRevisionCodeField.setEnabled(!isProcessing);
        }
        this.rdbMinimizeMemory.setEnabled(!isProcessing);
        this.rdbMinimizeTime.setEnabled(!isProcessing);
        this.rdbBalancesTimeAndMemory.setEnabled(!isProcessing);
        FeatureAttributeDescriptor identifier = (FeatureAttributeDescriptor)this.identifierFieldPicker.get();
        okbuttonEnabled = identifier == null ? false : okbuttonEnabled && !isProcessing;
        switch (this.getHistoryType()) {
            case -1: {
                okbuttonEnabled = false;
                break;
            }
            case 0: {
                FeatureAttributeDescriptor revisionDate = (FeatureAttributeDescriptor)this.revisionDateFieldPicker.get();
                if (revisionDate == null) {
                    okbuttonEnabled = false;
                } else {
                    boolean bl = okbuttonEnabled = okbuttonEnabled && !isProcessing;
                }
                if (this.getTimeInterval() < 0) {
                    okbuttonEnabled = false;
                    break;
                }
                okbuttonEnabled = okbuttonEnabled && !isProcessing;
                break;
            }
            case 1: {
                FeatureAttributeDescriptor revisionNumber = (FeatureAttributeDescriptor)this.revisionNumberFieldPicker.get();
                if (revisionNumber == null) {
                    okbuttonEnabled = false;
                    break;
                }
                boolean bl = okbuttonEnabled = okbuttonEnabled && !isProcessing;
            }
        }
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, okbuttonEnabled);
        }
        this.pbStatus.setVisible(isProcessing);
        this.lblStatusTitle.setVisible(isProcessing);
    }

    private boolean hasSourceStore() {
        switch (this.tabAddToWorkspace.getSelectedIndex()) {
            case 0: {
                TreePath selection = this.treeLayers.getSelectionModel().getSelectionPath();
                if (selection != null) {
                    Object[] path = selection.getPath();
                    boolean isLeaf = this.treeLayers.getModel().isLeaf(path[path.length - 1]);
                    Object obj = path[path.length - 1];
                    if (isLeaf && obj instanceof FeatureStore) {
                        return true;
                    }
                }
            }
            case 1: {
                Object selected = this.lstTables.getSelectedValue();
                if (!(selected instanceof FeatureStore)) break;
                return true;
            }
        }
        return false;
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblWorkspace);
        toolsSwingManager.translate(this.lblTargetTable);
        toolsSwingManager.translate(this.tabAddToWorkspace);
        toolsSwingManager.translate(this.lblIdentifierField);
        toolsSwingManager.translate(this.lblSortField);
        toolsSwingManager.translate(this.lblRevisionDateField);
        toolsSwingManager.translate(this.lblRevisionCodeField);
        toolsSwingManager.translate(this.lblTimeInterval);
        toolsSwingManager.translate(this.tabHistoryType);
        toolsSwingManager.translate(this.lblEfectiveDateField);
        toolsSwingManager.translate(this.lblDeletedCondition);
        toolsSwingManager.translate((AbstractButton)this.rdbMinimizeMemory);
        toolsSwingManager.translate((AbstractButton)this.rdbMinimizeTime);
        toolsSwingManager.translate((AbstractButton)this.rdbBalancesTimeAndMemory);
        toolsSwingManager.translate(this.tabImportHistory);
        toolsSwingManager.translate(this.lblWarningMemoryExausted);
        toolsSwingManager.translate(this.lblNumberInsertToChangeToAppendMode);
        toolsSwingManager.translate((AbstractButton)this.chkOnlyUploadLocallyNoCommits);
    }

    public VCSGisWorkspace getWorkspace() {
        VCSGisWorkspace workspace = (VCSGisWorkspace)this.workspacePicker.get();
        return workspace;
    }

    private FeatureStore getSourceFeatureStore() {
        switch (this.tabAddToWorkspace.getSelectedIndex()) {
            case 0: {
                TreePath selection = this.treeLayers.getSelectionModel().getSelectionPath();
                if (selection != null) {
                    Object[] path = selection.getPath();
                    boolean isLeaf = this.treeLayers.getModel().isLeaf(path[path.length - 1]);
                    Object obj = path[path.length - 1];
                    if (isLeaf && obj instanceof FeatureStore) {
                        return (FeatureStore)obj;
                    }
                }
            }
            case 1: {
                Object selected = this.lstTables.getSelectedValue();
                if (!(selected instanceof FeatureStore)) break;
                return (FeatureStore)selected;
            }
        }
        return null;
    }

    private int getTimeInterval() {
        int timeInterval = IntegerDocumentFilter.getValue((JTextField)this.txtTimeInterval);
        return timeInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importHistory() {
        VCSGisWorkspace workspace = this.getWorkspace();
        if (workspace == null) {
            return 24;
        }
        FeatureStore sourceStore = this.getSourceFeatureStore();
        if (sourceStore == null) {
            return 24;
        }
        VCSGisEntity targetEntity = this.targetEntitySelector.getSelectedEntity();
        if (targetEntity == null) {
            return 24;
        }
        if (!this.checkIdentifier(false)) {
            return 24;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_VCS_Import_history"));
        status.add();
        this.taskStatusController.bind((TaskStatus)status);
        try {
            this.processing = true;
            this.doUpdateComponents();
            FeatureAttributeDescriptor identifierField = (FeatureAttributeDescriptor)this.identifierFieldPicker.get();
            FeatureAttributeDescriptor revisionDateField = (FeatureAttributeDescriptor)this.revisionDateFieldPicker.get();
            FeatureAttributeDescriptor revisionField = (FeatureAttributeDescriptor)this.revisionNumberFieldPicker.get();
            boolean onlyLocal = this.chkOnlyUploadLocallyNoCommits.isSelected();
            ImportProcess process = null;
            switch (this.getHistoryType()) {
                case 0: {
                    process = ImportProcess.createImportHistoryProcessWithDate(onlyLocal, this.getOptimizeMode(), workspace, sourceStore, targetEntity, identifierField.getName(), revisionDateField.getName(), this.sortFieldPicker.getName(), Objects.toString(this.cboSortFieldOrder.getSelectedItem(), "Asc"), this.deletedConditionPicker.get(), this.getTimeInterval(), this.getTimeIntervalUnit(), status);
                    break;
                }
                case 1: {
                    process = ImportProcess.createImportHistoryProcessWithRevisionNumber(onlyLocal, this.getOptimizeMode(), workspace, sourceStore, targetEntity, identifierField.getName(), revisionField.getName(), this.efectiveDateFieldPicker.getName(), this.sortFieldPicker.getName(), Objects.toString(this.cboSortFieldOrder.getSelectedItem(), "Asc"), this.deletedConditionPicker.get(), status);
                }
            }
            if (process == null) {
                int n = 25;
                return n;
            }
            int result = process.process();
            this.lastLog = process.getLogFile();
            LOGGER.info("Import history, total time " + process.getTotalTimeFormatted() + ", total commits " + process.getTotalCommits());
            int n = result;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Import history canceled", (Throwable)ex);
            int n = 25;
            return n;
        }
        finally {
            this.processing = false;
            status.remove();
            this.doUpdateComponents();
        }
    }

    private ChronoUnit getTimeIntervalUnit() {
        LabeledValue x = (LabeledValue)this.cboTimeIntervalUnit.getSelectedItem();
        if (x == null) {
            return null;
        }
        return (ChronoUnit)x.getValue();
    }

    private int getOptimizeMode() {
        if (this.rdbMinimizeMemory.isSelected()) {
            return 0;
        }
        if (this.rdbMinimizeTime.isSelected()) {
            return 2;
        }
        if (this.rdbBalancesTimeAndMemory.isSelected()) {
            return 1;
        }
        return -1;
    }

    public void setVisibleStatus(boolean visible) {
        if (VCSGisSwingCommons.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.lblStatusTitle.setVisible(visible);
        this.pbStatus.setVisible(visible);
        this.lblStatusMessages.setVisible(true);
    }

    public boolean isProcessing() {
        return this.processing;
    }

    private void doChangeWorkspace() {
        VCSGisWorkspace workspace = this.getWorkspace();
        this.targetEntitySelector.setWorkspace(workspace);
        if (workspace == null) {
            this.doUpdateComponents();
            return;
        }
        if (!workspace.isTheRepositoryLocal()) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_Importing_a_history_is_a_heavy_operation_You_have_selected_a_working_copy_that_is_using_a_remote_repository_It_is_recommended_that_your_working_copy_use_a_local_repository_to_perform_this_operation_Also_some_functionality_such_as_setting_the_revision_date_is_not_available_with_remote_repositories"), i18n.getTranslation("_VCS_Import_history"), 1);
        }
    }

    private int getHistoryType() {
        switch (this.tabHistoryType.getSelectedIndex()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public File getLastLogFile() {
        return this.lastLog;
    }
}

