/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.importhistory;

import java.io.File;
import java.time.temporal.ChronoUnit;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.impl.importhistory.AbstractImportProcess;
import org.gvsig.vcsgis.swing.impl.importhistory.process.ImportHistoryWithDate_balanced;
import org.gvsig.vcsgis.swing.impl.importhistory.process.ImportHistoryWithDate_minimize_memory;
import org.gvsig.vcsgis.swing.impl.importhistory.process.ImportHistoryWithDate_minimize_time;
import org.gvsig.vcsgis.swing.impl.importhistory.process.ImportHistoryWithRevision_balanced;
import org.gvsig.vcsgis.swing.impl.importhistory.process.ImportHistoryWithRevision_minimize_memory;
import org.gvsig.vcsgis.swing.impl.importhistory.process.ImportHistoryWithRevision_minimize_time;

public interface ImportProcess {
    public static final int MODE_UNKNOWN = -1;
    public static final int MODE_MINIMIZE_MEMORY = 0;
    public static final int MODE_BALANCED = 1;
    public static final int MODE_MINIMIZE_TIME = 2;

    public int process();

    public long getTotalCommits();

    public long getTotalTime();

    public String getTotalTimeFormatted();

    public File getLogFile();

    public static ImportProcess createImportHistoryProcessWithDate(boolean onlyLocal, int mode, VCSGisWorkspace workspace, FeatureStore sourceStore, VCSGisEntity targetEntity, String fieldCodeName, String fieldDateName, String fieldOrderName, String sortOrder, Expression deletedCondition, long groupEvery, ChronoUnit groupEveryUnit, SimpleTaskStatus status) {
        AbstractImportProcess process;
        switch (mode) {
            case 0: {
                process = new ImportHistoryWithDate_minimize_memory(onlyLocal, workspace, sourceStore, targetEntity, fieldCodeName, fieldDateName, fieldOrderName, sortOrder, deletedCondition, groupEvery, groupEveryUnit, status);
                break;
            }
            case 1: {
                process = new ImportHistoryWithDate_balanced(onlyLocal, workspace, sourceStore, targetEntity, fieldCodeName, fieldDateName, fieldOrderName, sortOrder, deletedCondition, groupEvery, groupEveryUnit, status);
                break;
            }
            case 2: {
                process = new ImportHistoryWithDate_minimize_time(onlyLocal, workspace, sourceStore, targetEntity, fieldCodeName, fieldDateName, fieldOrderName, sortOrder, deletedCondition, groupEvery, groupEveryUnit, status);
                break;
            }
            default: {
                return null;
            }
        }
        return process;
    }

    public static ImportProcess createImportHistoryProcessWithRevisionNumber(boolean onlyLocal, int mode, VCSGisWorkspace workspace, FeatureStore sourceStore, VCSGisEntity targetEntity, String fieldCodeName, String fieldRevisionName, String fieldEfectiveDateName, String fieldOrderName, String sortOrder, Expression deletedCondition, SimpleTaskStatus status) {
        AbstractImportProcess process;
        switch (mode) {
            case 0: {
                process = new ImportHistoryWithRevision_minimize_memory(onlyLocal, workspace, sourceStore, targetEntity, fieldCodeName, fieldRevisionName, fieldEfectiveDateName, fieldOrderName, sortOrder, deletedCondition, status);
                break;
            }
            case 1: {
                process = new ImportHistoryWithRevision_balanced(onlyLocal, workspace, sourceStore, targetEntity, fieldCodeName, fieldRevisionName, fieldEfectiveDateName, fieldOrderName, sortOrder, deletedCondition, status);
                break;
            }
            case 2: {
                process = new ImportHistoryWithRevision_minimize_time(onlyLocal, workspace, sourceStore, targetEntity, fieldCodeName, fieldRevisionName, fieldEfectiveDateName, fieldOrderName, sortOrder, deletedCondition, status);
                break;
            }
            default: {
                return null;
            }
        }
        return process;
    }
}

