/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.swing.impl.logout;

import java.awt.Dimension;
import javax.swing.JComponent;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJLogout;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;
import org.gvsig.vcsgis.swing.impl.logout.VCSGisJLogoutView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisJLogoutImpl
extends VCSGisJLogoutView
implements Component,
VCSGisJLogout {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisJLogoutImpl.class);
    private Dialog dialog;
    private PickerController<VCSGisWorkspace> workspacePicker;

    public VCSGisJLogoutImpl() {
        this.translate();
        this.initComponents();
    }

    private void initComponents() {
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisSwingServices services = swingManager.getDefaultServices();
        this.workspacePicker = swingManager.createWorkspacePickerController(this.cboWorkspaces, this.btnInitWorkspace);
        this.workspacePicker.addChangeListener(e -> this.doChangeWorkspace());
        this.setPreferredSize(new Dimension(300, 60));
    }

    public JComponent asJComponent() {
        return this;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    private void doChangeWorkspace() {
        VCSGisWorkspace ws = this.getWorkspace();
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, ws != null);
        }
    }

    public VCSGisWorkspace getWorkspace() {
        return (VCSGisWorkspace)this.workspacePicker.get();
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate(this.lblWorkspace);
    }

    public void logout() {
        VCSGisWorkspace ws = this.getWorkspace();
        if (ws == null) {
            return;
        }
        ws.logout();
    }

    public boolean isProcessing() {
        return false;
    }
}

