/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.control;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.georeferencing.swing.control.GeorefControlPanel;
import org.gvsig.raster.georeferencing.swing.control.GeorefControlPanelListener;

public class GeorefControlPanelImpl
extends JPanel
implements GeorefControlPanel,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel buttonsPanel = null;
    private JButton bSaveToXml = null;
    private JButton bLoadFromXml = null;
    private JButton bSaveToAscii = null;
    private JButton bLoadFromAscii = null;
    private JButton bOptions = null;
    private JButton bTest = null;
    private JButton bEndTest = null;
    private JButton bEndGeoref = null;
    private JButton bCenterView = null;
    private JToggleButton bMovePoint = null;
    private JToggleButton bDragPoint = null;
    private DataInputContainer error = null;
    private String pathToImagesForTest = "/src/main/resources/image/";

    public GeorefControlPanelImpl() {
        this.init();
    }

    public int getButtonIDPressed(Object source) {
        if (source == this.bSaveToXml) {
            return 0;
        }
        if (source == this.bLoadFromXml) {
            return 1;
        }
        if (source == this.bSaveToAscii) {
            return 2;
        }
        if (source == this.bLoadFromAscii) {
            return 3;
        }
        if (source == this.bTest) {
            return 5;
        }
        if (source == this.bOptions) {
            return 4;
        }
        if (source == this.bEndTest) {
            return 6;
        }
        if (source == this.bEndGeoref) {
            return 7;
        }
        if (source == this.bCenterView) {
            return 8;
        }
        if (source == this.bMovePoint) {
            return 9;
        }
        if (source == this.bDragPoint) {
            return 10;
        }
        return -1;
    }

    public JPanel getComponent() {
        return this;
    }

    public void setListener(GeorefControlPanelListener listener) {
        this.getSaveToXMLButton().addActionListener((ActionListener)listener);
        this.getLoadFromXMLButton().addActionListener((ActionListener)listener);
        this.getExporToCSVButton().addActionListener((ActionListener)listener);
        this.getLoadFromCSVButton().addActionListener((ActionListener)listener);
        this.getOptionsButton().addActionListener((ActionListener)listener);
        this.getCenterButton().addActionListener((ActionListener)listener);
        this.getMovePointButton().addActionListener((ActionListener)listener);
        this.getDragPointButton().addActionListener((ActionListener)listener);
        this.getEndGeorefButton().addActionListener((ActionListener)listener);
        this.getTestButton().addActionListener((ActionListener)listener);
        this.getEndTestButton().addActionListener((ActionListener)listener);
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = new Insets(0, 0, 0, 0);
        gb.fill = 2;
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridx = 0;
        this.add((Component)new JPanel(), gb);
        gb.gridx = 2;
        this.add((Component)new JPanel(), gb);
        gb.fill = 0;
        gb.weightx = 0.0;
        gb.gridx = 1;
        this.add((Component)this.getButtonsPanel(), gb);
    }

    public JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.insets = new Insets(0, 0, 1, 1);
            gb.fill = 0;
            gb.weightx = 0.0;
            gb.gridy = 0;
            gb.gridx = 0;
            this.buttonsPanel.add((Component)this.getMovePointButton(), gb);
            gb.gridy = 0;
            gb.gridx = 1;
            this.buttonsPanel.add((Component)this.getDragPointButton(), gb);
            gb.gridy = 0;
            gb.gridx = 2;
            this.buttonsPanel.add((Component)this.getCenterButton(), gb);
            gb.insets = new Insets(0, 4, 1, 1);
            gb.gridy = 0;
            gb.gridx = 3;
            this.buttonsPanel.add((Component)this.getSaveToXMLButton(), gb);
            gb.insets = new Insets(0, 0, 1, 1);
            gb.gridy = 0;
            gb.gridx = 4;
            this.buttonsPanel.add((Component)this.getLoadFromXMLButton(), gb);
            gb.gridy = 0;
            gb.gridx = 5;
            this.buttonsPanel.add((Component)this.getExporToCSVButton(), gb);
            gb.gridy = 0;
            gb.gridx = 6;
            this.buttonsPanel.add((Component)this.getLoadFromCSVButton(), gb);
            gb.insets = new Insets(0, 4, 1, 1);
            gb.gridy = 0;
            gb.gridx = 7;
            this.buttonsPanel.add((Component)this.getOptionsButton(), gb);
            gb.insets = new Insets(0, 0, 1, 1);
            gb.gridy = 0;
            gb.gridx = 8;
            this.buttonsPanel.add((Component)this.getEndTestButton(), gb);
            gb.gridy = 0;
            gb.gridx = 9;
            this.buttonsPanel.add((Component)this.getTestButton(), gb);
            gb.gridy = 0;
            gb.gridx = 10;
            this.buttonsPanel.add((Component)this.getEndGeorefButton(), gb);
            gb.gridy = 0;
            gb.gridx = 11;
            this.buttonsPanel.add((Component)this.getError(), gb);
        }
        return this.buttonsPanel;
    }

    public DataInputContainer getError() {
        if (this.error == null) {
            this.error = new DataInputContainer();
            this.error.setLabelText("RMS");
            this.error.setPreferredSize(new Dimension(85, 35));
        }
        return this.error;
    }

    public JButton getEndGeorefButton() {
        if (this.bEndGeoref == null) {
            this.bEndGeoref = new JButton();
            this.bEndGeoref.setPreferredSize(new Dimension(22, 22));
            this.bEndGeoref.setIcon(this.loadIcon("exit-icon"));
            this.bEndGeoref.setToolTipText(Messages.getText((String)"end_georef"));
        }
        return this.bEndGeoref;
    }

    public JButton getTestButton() {
        if (this.bTest == null) {
            this.bTest = new JButton();
            this.bTest.setPreferredSize(new Dimension(22, 22));
            this.bTest.setToolTipText(Messages.getText((String)"test_georef"));
            this.bTest.setIcon(this.loadIcon("process-icon"));
        }
        return this.bTest;
    }

    public JButton getEndTestButton() {
        if (this.bEndTest == null) {
            this.bEndTest = new JButton();
            this.bEndTest.setPreferredSize(new Dimension(22, 22));
            this.bEndTest.setToolTipText(Messages.getText((String)"end_test_georef"));
            this.bEndTest.setIcon(this.loadIcon("endprocess-icon"));
        }
        return this.bEndTest;
    }

    public JButton getLoadFromCSVButton() {
        if (this.bLoadFromAscii == null) {
            this.bLoadFromAscii = new JButton();
            this.bLoadFromAscii.setPreferredSize(new Dimension(22, 22));
            this.bLoadFromAscii.setToolTipText(Messages.getText((String)"load_from_ascii"));
            this.bLoadFromAscii.setIcon(this.loadIcon("importfromcsv-icon"));
        }
        return this.bLoadFromAscii;
    }

    public JButton getExporToCSVButton() {
        if (this.bSaveToAscii == null) {
            this.bSaveToAscii = new JButton();
            this.bSaveToAscii.setPreferredSize(new Dimension(22, 22));
            this.bSaveToAscii.setToolTipText(Messages.getText((String)"save_to_ascii"));
            this.bSaveToAscii.setIcon(this.loadIcon("exporttocsv-icon"));
        }
        return this.bSaveToAscii;
    }

    public JButton getLoadFromXMLButton() {
        if (this.bLoadFromXml == null) {
            this.bLoadFromXml = new JButton();
            this.bLoadFromXml.setPreferredSize(new Dimension(22, 22));
            this.bLoadFromXml.setToolTipText(Messages.getText((String)"load_from_xml"));
            this.bLoadFromXml.setIcon(this.loadIcon("tfwload-icon"));
        }
        return this.bLoadFromXml;
    }

    private ImageIcon loadIcon(String iconName) {
        ImageIcon icon = null;
        try {
            icon = IconThemeHelper.getImageIcon((String)iconName);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String file = System.getProperty("user.dir") + this.pathToImagesForTest + iconName;
        if (icon == null && new File(file + ".png").exists()) {
            icon = new ImageIcon(file + ".png", "");
        }
        if (icon == null && new File(file + ".gif").exists()) {
            icon = new ImageIcon(file + ".gif", "");
        }
        return icon;
    }

    public JButton getSaveToXMLButton() {
        if (this.bSaveToXml == null) {
            this.bSaveToXml = new JButton();
            this.bSaveToXml.setPreferredSize(new Dimension(22, 22));
            this.bSaveToXml.setToolTipText(Messages.getText((String)"save_gcp_to_xml"));
            this.bSaveToXml.setIcon(this.loadIcon("save-icon"));
        }
        return this.bSaveToXml;
    }

    public JButton getOptionsButton() {
        if (this.bOptions == null) {
            this.bOptions = new JButton();
            this.bOptions.setPreferredSize(new Dimension(22, 22));
            this.bOptions.setToolTipText(Messages.getText((String)"options"));
            this.bOptions.setIcon(this.loadIcon("options-icon"));
        }
        return this.bOptions;
    }

    public JToggleButton getMovePointButton() {
        if (this.bMovePoint == null) {
            this.bMovePoint = new JToggleButton();
            this.bMovePoint.setPreferredSize(new Dimension(22, 22));
            this.bMovePoint.setToolTipText(Messages.getText((String)"move-point"));
            this.bMovePoint.setIcon(this.loadIcon("move-icon"));
            this.bMovePoint.addActionListener(this);
        }
        return this.bMovePoint;
    }

    public JToggleButton getDragPointButton() {
        if (this.bDragPoint == null) {
            this.bDragPoint = new JToggleButton();
            this.bDragPoint.setPreferredSize(new Dimension(22, 22));
            this.bDragPoint.setToolTipText(Messages.getText((String)"drag_point"));
            this.bDragPoint.setIcon(this.loadIcon("drag-icon"));
            this.bDragPoint.addActionListener(this);
        }
        return this.bDragPoint;
    }

    public JButton getCenterButton() {
        if (this.bCenterView == null) {
            this.bCenterView = new JButton();
            this.bCenterView.setPreferredSize(new Dimension(22, 22));
            this.bCenterView.setToolTipText(Messages.getText((String)"center_view"));
            this.bCenterView.setIcon(this.loadIcon("centerpoint-icon"));
        }
        return this.bCenterView;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getMovePointButton() && this.getMovePointButton().isSelected()) {
            this.getDragPointButton().setSelected(false);
        }
        if (e.getSource() == this.getDragPointButton() && this.getDragPointButton().isSelected()) {
            this.getMovePointButton().setSelected(false);
        }
    }
}

