/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.option;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.georeferencing.Geotransformation;
import org.gvsig.raster.georeferencing.swing.impl.option.CellSizeOptionsPanel;
import org.gvsig.raster.georeferencing.swing.model.GeoreferencingOptionsDataModel;
import org.gvsig.raster.swing.basepanel.AbstractButtonsPanel;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellSizeDialog
extends AbstractButtonsPanel
implements DataInputContainerListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CellSizeDialog.class);
    private CellSizeOptionsPanel cellSizePanel = null;
    private JPanel panel = null;
    private JLabel labelText = null;
    private JLabel xsizeText = null;
    private JLabel ysizeText = null;
    private GeoreferencingOptionsDataModel dataModel = null;

    public CellSizeDialog(GeoreferencingOptionsDataModel dataModel, ButtonsPanelListener listener) {
        this.dataModel = dataModel;
        this.getButtonsPanel().getButton(3).setVisible(false);
        this.getButtonsPanel().addButtonPressedListener(listener);
        this.init();
        if (dataModel != null) {
            this.calculateTransformation();
        }
    }

    public void init() {
        this.labelText = new JLabel(Messages.getText((String)"recomended_size"));
        this.xsizeText = new JLabel("X:- px");
        this.ysizeText = new JLabel("Y:- px");
        this.xsizeText.setForeground(Color.red);
        this.ysizeText.setForeground(Color.red);
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridy = 1;
        this.add(this.getCellSizePanel(), gbc);
        gbc.gridy = 2;
        this.add(this.getPanel(), gbc);
    }

    public CellSizeOptionsPanel getCellSizePanel() {
        if (this.cellSizePanel == null) {
            this.cellSizePanel = new CellSizeOptionsPanel();
            this.cellSizePanel.getXCellSizeTextField().setListener(this);
            this.cellSizePanel.getYCellSizeTextField().setListener(this);
        }
        return this.cellSizePanel;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.gridy = 1;
            this.panel.add((Component)this.labelText, gbc);
            gbc.gridy = 2;
            this.panel.add((Component)this.xsizeText, gbc);
            gbc.gridy = 3;
            this.panel.add((Component)this.ysizeText, gbc);
        }
        return this.panel;
    }

    public void setEnabled(boolean enable) {
        this.cellSizePanel.setEnabled(enable);
    }

    public void actionValueChanged(EventObject e) {
        this.calculateTransformation();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.calculateTransformation();
        }
    }

    private void calculateTransformation() {
        double yCellSize;
        double xCellSize;
        if (this.dataModel == null) {
            return;
        }
        String cs1 = this.getCellSizePanel().getXCellSizeTextField().getValue();
        String cs2 = this.getCellSizePanel().getYCellSizeTextField().getValue();
        try {
            xCellSize = Double.valueOf(cs1);
            yCellSize = Double.valueOf(cs2);
        }
        catch (NumberFormatException e) {
            this.xsizeText.setText("X: ? px");
            this.ysizeText.setText("Y: ? px");
            return;
        }
        try {
            DataProcess transform = RasterBaseAlgorithmLibrary.getManager().createRasterTask("GeotransformProcess");
            transform.addParam("gcps", (Object)this.dataModel.getGCPList().getGeoPointList());
            transform.addParam("Order", (Object)this.dataModel.getDegree());
            transform.execute();
            int w = (int)this.dataModel.getDataStore().getWidth();
            int h = (int)this.dataModel.getDataStore().getHeight();
            HashMap map = transform.getResult();
            Geotransformation gt = (Geotransformation)map.get("RESULT");
            double[] p1 = gt.getCoordMap(0.0, 0.0);
            double[] p2 = gt.getCoordMap((double)w, 0.0);
            double[] p3 = gt.getCoordMap(0.0, (double)h);
            double[] p4 = gt.getCoordMap((double)w, (double)h);
            double xmin = Math.min(Math.min(p1[0], p3[0]), Math.min(p2[0], p4[0]));
            double ymin = Math.min(Math.min(p3[1], p4[1]), Math.min(p1[1], p2[1]));
            double xmax = Math.max(Math.max(p2[0], p4[0]), Math.max(p1[0], p3[0]));
            double ymax = Math.max(Math.max(p1[1], p2[1]), Math.max(p3[1], p4[1]));
            if (xCellSize > 0.0 && yCellSize > 0.0) {
                w = (int)((xmax - xmin) / xCellSize);
                h = (int)((ymax - ymin) / yCellSize);
            } else {
                xCellSize = (xmax - xmin) / (double)w;
                yCellSize = (ymax - ymin) / (double)h;
                this.getCellSizePanel().getXCellSizeTextField().setValue(Double.toString(xCellSize));
                this.getCellSizePanel().getYCellSizeTextField().setValue(Double.toString(yCellSize));
            }
            if (this.dataModel.getAlgorithm() == 1) {
                this.xsizeText.setText("X: " + (int)this.dataModel.getDataStore().getWidth() + " px (native)");
                this.ysizeText.setText("Y: " + (int)this.dataModel.getDataStore().getHeight() + " px (native)");
            } else {
                this.xsizeText.setText("X: " + w + " px");
                this.ysizeText.setText("Y: " + h + " px");
            }
            this.dataModel.setXCellSize(xCellSize);
            this.dataModel.setYCellSize(yCellSize);
        }
        catch (ProcessInterruptedException transform) {
        }
        catch (Exception e) {
            LOGGER.warn("Can't calculate transform", (Throwable)e);
            this.xsizeText.setText("X: ? px");
            this.ysizeText.setText("Y: ? px");
        }
    }
}

