/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.tool;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLibrary;
import org.gvsig.raster.georeferencing.swing.impl.tool.BaseViewTool;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.ToolEvent;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;

public class PanTool
extends BaseViewTool
implements MouseListener,
MouseMotionListener {
    private Point2D initPoint = null;
    private Point2D distance = null;
    private Rectangle2D result = null;

    public PanTool(ToolListener listener, GeoreferencingView parentView) {
        super(parentView.getCanvas(), listener, parentView);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.type = GeoreferencingSwingLibrary.PAN_TOOL;
    }

    @Override
    public void draw(Graphics g) {
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isActive()) {
            this.initPoint = e.getPoint();
        }
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.onTool(new ToolEvent((Object)this, this.getParentView(), null));
        } else {
            this.offTool(new ToolEvent((Object)this, this.getParentView(), null));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isActive()) {
            double endX = (double)e.getX() - this.initPoint.getX();
            double endY = (double)e.getY() - this.initPoint.getY();
            AffineTransform at = this.canvas.getPanAffineTransform();
            at.setToTranslation(endX, endY);
            this.canvas.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isActive()) {
            AffineTransform at = this.canvas.getPanAffineTransform();
            this.canvas.setZoomAffineTransform(at.getScaleX(), at.getScaleY(), at.getTranslateX(), at.getTranslateY());
            this.canvas.repaint();
            this.canvas.setActiveMoveRedraw(false);
            at.setToIdentity();
            Point endPoint = e.getPoint();
            double x = this.initPoint.getX() - ((Point2D)endPoint).getX();
            double y = this.initPoint.getY() - ((Point2D)endPoint).getY();
            this.distance = new Point2D.Double(x, y);
            Point2D pInit = this.canvas.viewCoordsToWorld(new Point2D.Double(this.distance.getX(), this.distance.getY()));
            Point2D pEnd = this.canvas.viewCoordsToWorld(new Point2D.Double(this.distance.getX() + (double)this.canvas.getWidth(), this.distance.getY() + (double)this.canvas.getHeight()));
            this.result = this.canvas.getMinxMaxyUL() ? new Rectangle2D.Double(pInit.getX(), pEnd.getY(), Math.abs(pInit.getX() - pEnd.getX()), Math.abs(pInit.getY() - pEnd.getY())) : new Rectangle2D.Double(pInit.getX(), pInit.getY(), Math.abs(pInit.getX() - pEnd.getX()), Math.abs(pInit.getY() - pEnd.getY()));
            this.initPoint = null;
            new Drawer().start();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public class Drawer
    extends Thread {
        @Override
        public void run() {
            for (int i = 0; i < PanTool.this.listeners.size(); ++i) {
                ((ToolListener)PanTool.this.listeners.get(i)).endAction(new ToolEvent((Object)this, PanTool.this.getParentView(), null));
            }
            PanTool.this.canvas.setActiveMoveRedraw(true);
            PanTool.this.canvas.repaint();
        }
    }
}

