/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.tool;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLibrary;
import org.gvsig.raster.georeferencing.swing.impl.tool.BaseViewTool;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.ToolEvent;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;

public class ZoomRectangleTool
extends BaseViewTool
implements MouseListener,
MouseMotionListener {
    private Point2D initPoint = null;
    private double x = 0.0;
    private double y = 0.0;
    private double w = 0.0;
    private double h = 0.0;
    private Rectangle2D result = null;

    public ZoomRectangleTool(ToolListener listener, GeoreferencingView parentView) {
        super(parentView.getCanvas(), listener, parentView);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.type = GeoreferencingSwingLibrary.ZOOM_RECTANGLE_TOOL;
    }

    @Override
    public void draw(Graphics g) {
        if (this.initPoint == null || this.w == 0.0 || this.h == 0.0) {
            return;
        }
        g.setColor(Color.RED);
        g.drawRect((int)this.x, (int)this.y, (int)this.w, (int)this.h);
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isActive()) {
            this.initPoint = e.getPoint();
            this.x = this.initPoint.getX();
            this.y = this.initPoint.getY();
            this.w = 30.0;
            this.h = 10.0;
            this.result = null;
        }
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.onTool(new ToolEvent((Object)this, this.getParentView(), null));
        } else {
            this.offTool(new ToolEvent((Object)this, this.getParentView(), null));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isActive()) {
            this.x = this.initPoint.getX();
            this.y = this.initPoint.getY();
            this.w = Math.abs((double)e.getX() - this.x);
            this.h = Math.abs((double)e.getY() - this.y);
            if ((double)e.getX() < this.x) {
                this.x = e.getX();
            }
            if ((double)e.getY() < this.y) {
                this.y = e.getY();
            }
            Graphics g1 = this.canvas.getGraphics();
            g1.setColor(Color.RED);
            g1.drawRect((int)this.x, (int)this.y, (int)this.w, (int)this.h);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isActive()) {
            double centerX = this.x + this.w / 2.0;
            double centerY = this.y + this.h / 2.0;
            if (this.w < this.h) {
                if ((double)this.canvas.getWidth() / (double)this.canvas.getHeight() <= this.w / this.h) {
                    this.h = (double)this.canvas.getHeight() * this.w / (double)this.canvas.getWidth();
                    this.y = centerY - this.h / 2.0;
                } else {
                    this.w = (double)this.canvas.getWidth() * this.h / (double)this.canvas.getHeight();
                    this.x = centerX - this.w / 2.0;
                }
            } else if ((double)this.canvas.getWidth() / (double)this.canvas.getHeight() >= this.w / this.h) {
                this.w = (double)this.canvas.getWidth() * this.h / (double)this.canvas.getHeight();
                this.x = centerX - this.w / 2.0;
            } else {
                this.h = (double)this.canvas.getHeight() * this.w / (double)this.canvas.getWidth();
                this.y = centerY - this.h / 2.0;
            }
            Point2D pInit = this.canvas.viewCoordsToWorld(new Point2D.Double(this.x, this.y));
            Point2D pEnd = this.canvas.viewCoordsToWorld(new Point2D.Double(this.x + this.w, this.y + this.h));
            this.result = this.canvas.getMinxMaxyUL() ? new Rectangle2D.Double(pInit.getX(), pEnd.getY(), Math.abs(pInit.getX() - pEnd.getX()), Math.abs(pInit.getY() - pEnd.getY())) : new Rectangle2D.Double(pInit.getX(), pInit.getY(), Math.abs(pInit.getX() - pEnd.getX()), Math.abs(pInit.getY() - pEnd.getY()));
            double scaleX = (double)this.canvas.getWidth() / this.w;
            double scaleY = (double)this.canvas.getHeight() / this.h;
            double shiftX = (double)(this.canvas.getWidth() / 2) - (this.x + this.w / 2.0) * scaleX;
            double shiftY = (double)(this.canvas.getHeight() / 2) - (this.y + this.h / 2.0) * scaleY;
            this.canvas.setActiveMoveRedraw(false);
            this.canvas.setZoomAffineTransform(scaleX, scaleY, shiftX, shiftY);
            this.canvas.repaint();
            this.initPoint = null;
            this.h = 0.0;
            this.w = 0.0;
            this.y = 0.0;
            this.x = 0.0;
            new Drawer().start();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public class Drawer
    extends Thread {
        @Override
        public void run() {
            for (int i = 0; i < ZoomRectangleTool.this.listeners.size(); ++i) {
                ((ToolListener)ZoomRectangleTool.this.listeners.get(i)).endAction(new ToolEvent((Object)this, ZoomRectangleTool.this.getParentView(), null));
            }
            ZoomRectangleTool.this.canvas.setActiveMoveRedraw(true);
            ZoomRectangleTool.this.canvas.repaint();
        }
    }
}

