/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.DropDown;
import org.gvsig.tools.swing.impl.DefaultActionListenerSupport;
import org.gvsig.tools.util.LabeledValue;

public class DropDownComboBox
implements DropDown {
    final JComboBox combo;
    private List<ImageIcon> icons;
    private boolean readonly;
    private final Color warningBackgroundColor;
    private final Color backgroundColor;
    private final ActionListenerSupport dropdownListsnersHelper;

    public DropDownComboBox(JComboBox combo, Color warningBackgroundColor) {
        this.combo = combo;
        this.warningBackgroundColor = warningBackgroundColor;
        this.backgroundColor = combo.getBackground();
        this.dropdownListsnersHelper = new DefaultActionListenerSupport();
        this.combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ActionEvent ev = new ActionEvent(this, 0, null);
                DropDownComboBox.this.dropdownListsnersHelper.fireActionEvent(ev);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public JComponent asJComponent() {
        return this.combo;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
        this.combo.setEnabled(!readOnly);
    }

    public void setVisibleDropdownArrow(boolean visible) {
    }

    public boolean isVisibleDropdownArrow() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEditable(enabled);
    }

    public void setModel(ComboBoxModel model) {
        this.combo.setModel(model);
        this.combo.setBackground(this.backgroundColor);
    }

    public ComboBoxModel getModel() {
        return this.combo.getModel();
    }

    public void addItemListener(ItemListener itemListener) {
        this.combo.addItemListener(itemListener);
    }

    public void setSelectedIndex(int i) {
        this.combo.setSelectedIndex(i);
        this.combo.setBackground(this.backgroundColor);
    }

    public void setValue(Object value) {
        ComboBoxModel model = this.getModel();
        if (model == null) {
            throw new IllegalStateException("Can't set value when model is null");
        }
        for (int i = 0; i < model.getSize(); ++i) {
            Object item = model.getElementAt(i);
            if (item instanceof LabeledValue) {
                item = ((LabeledValue)item).getValue();
            }
            if (!Objects.equals(item, value)) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.combo.setSelectedItem(value);
        this.combo.setBackground(this.warningBackgroundColor);
    }

    public Object getSelectedItem() {
        return this.combo.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this.combo.getSelectedIndex();
    }

    public Object[] getSelectedObjects() {
        return this.combo.getSelectedObjects();
    }

    public void removeItemListener(ItemListener l) {
        this.combo.removeItemListener(l);
    }

    public void setIcons(List<ImageIcon> icons) {
        this.icons = icons;
    }

    public List<ImageIcon> getIcons() {
        return this.icons;
    }

    public void addDropdownListener(ActionListener listener) {
        this.dropdownListsnersHelper.addActionListener(listener);
    }

    public void removeDropdownListener(ActionListener listener) {
        this.dropdownListsnersHelper.removeActionListener(listener);
    }
}

