/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.bufferedImage;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import org.gvsig.tools.ToolsLocator;

public class VirtualBufferedImageHelper {
    public static DataBuffer createVirtualDataBuffer(int type, int size, int numBanks) throws IOException {
        switch (type) {
            case 0: {
                return new DataBufferByte(size, numBanks);
            }
            case 1: {
                return new DataBufferUShort(size, numBanks);
            }
            case 3: {
                return new DataBufferInt(size, numBanks);
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + type);
    }

    public static BufferedImage createVirtualBufferedImage(int width, int height, int type) {
        BufferedImage temp = new BufferedImage(1, 1, type);
        SampleModel sampleModel = temp.getSampleModel().createCompatibleSampleModel(width, height);
        ColorModel colorModel = temp.getColorModel();
        BufferedImage x = VirtualBufferedImageHelper.createVirtualBufferedImage(width, height, sampleModel, colorModel);
        return x;
    }

    public static BufferedImage createVirtualBufferedImage(int width, int height, SampleModel sampleModel, ColorModel colorModel) throws IORuntimeException {
        DataBuffer buffer;
        try {
            buffer = VirtualBufferedImageHelper.createVirtualDataBuffer(sampleModel.getTransferType(), width * height * sampleModel.getNumDataElements(), 1);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        WritableRaster raster = new WritableRaster(sampleModel, buffer);
        BufferedImage x = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        return x;
    }

    public static class IORuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -4461981890554048338L;

        public IORuntimeException(IOException ex) {
            super(ex.getMessage(), ex);
        }
    }

    private static class WritableRaster
    extends java.awt.image.WritableRaster {
        public WritableRaster(SampleModel model, DataBuffer buffer) {
            super(model, buffer, new Point());
        }
    }

    private static class DataBufferInt
    extends VirtualDataBuffer {
        public DataBufferInt(int size, int numBanks) throws IOException {
            super(3, size, numBanks);
        }

        @Override
        public int getElem(int bank, int i) {
            return ((IntBuffer)this.buffer).get(bank * this.size + i);
        }

        @Override
        public void setElem(int bank, int i, int val) {
            ((IntBuffer)this.buffer).put(bank * this.size + i, val);
        }
    }

    private static class DataBufferUShort
    extends VirtualDataBuffer {
        public DataBufferUShort(int size, int numBanks) throws IOException {
            super(1, size, numBanks);
        }

        @Override
        public int getElem(int bank, int i) {
            return ((ShortBuffer)this.buffer).get(bank * this.size + i) & 0xFFFF;
        }

        @Override
        public void setElem(int bank, int i, int val) {
            ((ShortBuffer)this.buffer).put(bank * this.size + i, (short)val);
        }
    }

    public static class DataBufferByte
    extends VirtualDataBuffer {
        public DataBufferByte(int size, int numBanks) throws IOException {
            super(0, size, numBanks);
        }

        @Override
        public int getElem(int bank, int i) {
            return ((ByteBuffer)this.buffer).get(bank * this.size + i) & 0xFF;
        }

        @Override
        public void setElem(int bank, int i, int val) {
            ((ByteBuffer)this.buffer).put(bank * this.size + i, (byte)val);
        }
    }

    public static abstract class VirtualDataBuffer
    extends DataBuffer {
        protected final Buffer buffer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected VirtualDataBuffer(int type, int size, int numBanks) throws IOException {
            super(type, size, numBanks);
            if (size < 0) {
                throw new IllegalArgumentException("size can't be less than zero");
            }
            int componentSize = DataBuffer.getDataTypeSize(type) / 8;
            File tempFile = ToolsLocator.getFoldersManager().getUniqueTemporaryFile(new String[]{"BufferedImage.dat"});
            try {
                RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");
                long length = (long)size * (long)componentSize * (long)numBanks;
                raf.setLength(length);
                try (FileChannel channel = raf.getChannel();){
                    MappedByteBuffer byteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, length);
                    switch (type) {
                        case 0: {
                            this.buffer = byteBuffer;
                            return;
                        }
                        case 1: {
                            this.buffer = byteBuffer.asShortBuffer();
                            return;
                        }
                        case 3: {
                            this.buffer = byteBuffer.asIntBuffer();
                            return;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported data type: " + type);
                        }
                    }
                }
            }
            finally {
                tempFile.deleteOnExit();
            }
        }
    }
}

