/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.controls.comboscale;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.gui.beans.controls.IControl;

public class ComboScale
extends JPanel
implements IControl {
    private static final long serialVersionUID = 6483498713300082876L;
    private JLabel jLabel = null;
    private JComboBox jComboBox = null;
    private List<ActionListener> actionCommandListeners = new ArrayList<ActionListener>();
    private boolean bDoCallListeners = true;
    private static int eventId = Integer.MIN_VALUE;
    private Double lastValue = null;

    public ComboScale() {
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout(1, 0, 0);
        this.jLabel = new JLabel();
        this.jLabel.setText("1:");
        this.setLayout(flowLayout);
        this.add((Component)this.jLabel, null);
        this.add((Component)this.getJComboBox(), null);
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setEditable(true);
            this.jComboBox.setMaximumRowCount(5);
            this.jComboBox.setBackground(SystemColor.window);
            this.jComboBox.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("comboBoxChanged")) {
                        Object item = ComboScale.this.jComboBox.getSelectedItem();
                        double scale = 0.0;
                        if (item instanceof String) {
                            StringBuffer sb = new StringBuffer((String)item);
                            String digits = "0123456789";
                            BitSet deleteChars = new BitSet();
                            for (int i = sb.charAt(0) == '-' ? 1 : 0; i < sb.length(); ++i) {
                                if ("0123456789".indexOf(sb.charAt(i)) != -1) continue;
                                deleteChars.set(i);
                            }
                            for (int k = deleteChars.size(); k >= 0; --k) {
                                if (!deleteChars.get(k)) continue;
                                sb.deleteCharAt(k);
                            }
                            ComboScale.this.jComboBox.removeItem(item);
                            try {
                                scale = Double.parseDouble(sb.toString());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            scale = ((ComboScaleItem)ComboScale.this.jComboBox.getSelectedItem()).getValue();
                        }
                        ComboScale.this.setScale(scale, false);
                        ComboScale.this.callActionCommandListeners(scale);
                    }
                }
            });
        }
        return this.jComboBox;
    }

    @Override
    public Object getValue() {
        return this.lastValue;
    }

    public void setItems(long[] items) {
        ComboScaleItem[] scales = new ComboScaleItem[items.length];
        for (int i = 0; i < items.length; ++i) {
            scales[i] = new ComboScaleItem(items[i]);
        }
        DefaultComboBoxModel<ComboScaleItem> newModel = new DefaultComboBoxModel<ComboScaleItem>(scales);
        this.getJComboBox().setModel(newModel);
    }

    public void setScale(double scale) {
        this.setScale(scale, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setScale(double scale, boolean temporal) {
        this.bDoCallListeners = false;
        try {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.jComboBox.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ComboScaleItem itemScale = (ComboScaleItem)model.getElementAt(i);
                if (!itemScale.isTemporal()) continue;
                model.removeElement(itemScale);
                break;
            }
            this.getJComboBox().setSelectedItem(new ComboScaleItem(scale, temporal));
        }
        finally {
            this.bDoCallListeners = true;
        }
    }

    private void callActionCommandListeners(double scale) {
        if (!this.bDoCallListeners) {
            return;
        }
        this.lastValue = scale;
        for (ActionListener listener : this.actionCommandListeners) {
            listener.actionPerformed(new ActionEvent(this, eventId, "view-change-scale"));
        }
        ++eventId;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    public double getScale() {
        return ((ComboScaleItem)this.jComboBox.getSelectedItem()).getValue();
    }

    public void setLabel(String label) {
        this.jLabel.setText(label);
    }

    public String getLabel() {
        return this.jLabel.getText();
    }

    @Override
    public Object setValue(Object value) {
        try {
            double scale = Double.parseDouble((String)value);
            if (scale >= 1.0) {
                scale = Math.round(scale);
            }
            if (scale < 0.0) {
                return null;
            }
            ComboScaleItem item = new ComboScaleItem(scale);
            if (item.equals(this.jComboBox.getSelectedItem())) {
                return item;
            }
            this.setScale(scale);
            return item;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.jComboBox.isEnabled();
        this.jComboBox.setEnabled(enabled);
        this.jComboBox.firePropertyChange("enabled", oldEnabled, enabled);
        if (enabled != oldEnabled) {
            this.jComboBox.repaint();
        }
    }

    private class ComboScaleItem {
        private double value;
        private boolean temporal;

        public ComboScaleItem(double itemScale) {
            this.value = itemScale;
            this.temporal = false;
        }

        public ComboScaleItem(double itemScale, boolean temporal) {
            this.value = itemScale;
            this.temporal = temporal;
        }

        public String toString() {
            return NumberFormat.getNumberInstance().format(this.value);
        }

        public boolean equals(Object obj) {
            return obj instanceof ComboScaleItem && ((ComboScaleItem)obj).getValue() == this.value;
        }

        public double getValue() {
            return this.value;
        }

        public boolean isTemporal() {
            return this.temporal;
        }
    }
}

