/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.numberTextField;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class NumberTextField
extends JFormattedTextField
implements FocusListener {
    private static final long serialVersionUID = 1045806433744300963L;
    private NumberFormat format = NumberFormat.getInstance();

    public NumberTextField() {
        this.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(this.format)));
        this.initialize();
    }

    public NumberTextField(int columns) {
        this();
        this.setColumns(columns);
    }

    public NumberTextField(double value, int columns) {
        this();
        this.setColumns(columns);
        super.setValue(value);
    }

    public NumberTextField(int value, int columns) {
        this();
        this.setColumns(columns);
        super.setValue(value);
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    private void initialize() {
        this.addFocusListener(this);
        this.setHorizontalAlignment(4);
    }

    public void setValue(double value) {
        this.setValue((Object)value);
    }

    public void setValue(int value) {
        this.setValue((Object)value);
    }

    public void setValue(long value) {
        this.setValue((Object)value);
    }

    public double getDoubleValue() {
        Object value = this.getValue();
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        return 0.0;
    }

    public int getIntValue() {
        Object value = this.getValue();
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public long getLongValue() {
        Object value = this.getValue();
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return 0L;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            this.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

