/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.treeTable;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gvsig.gui.beans.swing.treeTable.AbstractCellEditor;
import org.gvsig.gui.beans.swing.treeTable.TreeTableCellRenderer;
import org.gvsig.gui.beans.swing.treeTable.TreeTableModel;
import org.gvsig.gui.beans.swing.treeTable.TreeTableModelAdapter;

public class TreeTable
extends JTable {
    private static final long serialVersionUID = 6630322246955414756L;
    protected TreeTableCellRenderer tree;

    public TreeTable(TreeTableModel treeTableModel) {
        this.setModel(treeTableModel);
    }

    public TreeTable(TreeTableModel treeTableModel, TreeCellRenderer cellRenderer, TreeCellEditor cellEditor) {
        this.setModel(treeTableModel, cellRenderer, cellEditor);
    }

    public void setModel(TreeTableModel treeTableModel, TreeCellRenderer cellRenderer, TreeCellEditor cellEditor) {
        this.tree = new TreeTableCellRenderer(treeTableModel, this, cellRenderer, cellEditor);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        this.setModel();
    }

    public void setModel(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel, this);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        this.setModel();
    }

    private void setModel() {
        this.tree.setSelectionModel(new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = 2719965083562067462L;
            {
                TreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.tree.setRowHeight(this.getRowHeight());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public void deleteIcons() {
        this.setLeafIcon(null);
        this.setClosedIcon(null);
        this.setOpenIcon(null);
    }

    public void setRootVisible(boolean rootVisible) {
        this.tree.setRootVisible(rootVisible);
    }

    public void setLeafIcon(Icon newIcon) {
        TreeTableCellRenderer renderer = (TreeTableCellRenderer)this.getTree();
        DefaultTreeCellRenderer treeRenderer = (DefaultTreeCellRenderer)renderer.getCellRenderer();
        treeRenderer.setLeafIcon(newIcon);
    }

    public void setOpenIcon(Icon newIcon) {
        TreeTableCellRenderer renderer = (TreeTableCellRenderer)this.getTree();
        DefaultTreeCellRenderer treeRenderer = (DefaultTreeCellRenderer)renderer.getCellRenderer();
        treeRenderer.setOpenIcon(newIcon);
    }

    public void setClosedIcon(Icon newIcon) {
        TreeTableCellRenderer renderer = (TreeTableCellRenderer)this.getTree();
        DefaultTreeCellRenderer treeRenderer = (DefaultTreeCellRenderer)renderer.getCellRenderer();
        treeRenderer.setClosedIcon(newIcon);
    }

    public Component getTree() {
        return this.tree;
    }

    public int expandJTreeNode(Object node, int row) {
        TreeModel model = this.tree.getModel();
        if (node != null && !model.isLeaf(node)) {
            this.tree.expandRow(row);
            for (int index = 0; row + 1 < this.tree.getRowCount() && index < model.getChildCount(node); ++index) {
                TreePath path;
                ++row;
                Object child = model.getChild(node, index);
                if (child == null) break;
                while ((path = this.tree.getPathForRow(row)) != null && path.getLastPathComponent() != child) {
                    this.tree.expandRow(row);
                    ++row;
                }
                if (path == null) break;
                row = this.expandJTreeNode(child, row);
            }
        }
        return row;
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return TreeTable.this.tree;
        }
    }
}

