/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.expressionbuilderformatter;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.oracle.dal.OracleSQLBuilder;

class And
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value> formatter;
    private final OracleSQLBuilder builder;

    public And(OracleSQLBuilder builder, Formatter<ExpressionBuilder.Value> formatter) {
        this.builder = builder;
        this.formatter = formatter;
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.BinaryOperator) {
            return StringUtils.equalsIgnoreCase((CharSequence)"AND", (CharSequence)((ExpressionBuilder.BinaryOperator)value).name());
        }
        return false;
    }

    public String format(ExpressionBuilder.Value function) {
        ExpressionBuilder.BinaryOperator operator = (ExpressionBuilder.BinaryOperator)function;
        ExpressionBuilder.Value p1 = operator.left();
        ExpressionBuilder.Value p2 = operator.right();
        String s1 = this.builder.canBeBoolean(p1) ? this.builder.formatAsBoolean(this.formatter, p1) : p1.toString(this.formatter);
        String s2 = this.builder.canBeBoolean(p2) ? this.builder.formatAsBoolean(this.formatter, p2) : p2.toString(this.formatter);
        String r = MessageFormat.format("( ({0}) AND ({1}) )", s1, s2);
        return r;
    }
}

