/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.app.extension.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.installer.app.extension.execution.InstallPackageWindow;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallPackageExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(InstallPackageExtension.class);

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String actionCommand, Object[] args) {
        if ("tools-addonsmanager".equalsIgnoreCase(actionCommand)) {
            this.showInternalAddonsManager(args);
        }
    }

    private void showExternalAddonsManager() {
        InstallerManager installManager = InstallerLocator.getInstallerManager();
        PluginsManager pluginManager = PluginsLocator.getManager();
        boolean useInternalAddonsManager = false;
        if ("win".equalsIgnoreCase(installManager.getOperatingSystem())) {
            String cmd = "runas /noprofile /user:Administrator " + pluginManager.getApplicationFolder() + File.separator + "gvsig-package-installer.exe --install";
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                if (p.exitValue() != 0) {
                    useInternalAddonsManager = true;
                }
            }
            catch (IOException ex) {
                logger.warn("Can't execute command '" + cmd + "'.", (Throwable)ex);
                useInternalAddonsManager = true;
            }
        } else {
            String cmd = "pkexec " + pluginManager.getApplicationFolder() + File.separator + "/gvSIG.sh --install";
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                if (p.exitValue() != 0) {
                    useInternalAddonsManager = true;
                }
            }
            catch (IOException ex) {
                logger.warn("Can't execute command '" + cmd + "'.", (Throwable)ex);
                useInternalAddonsManager = true;
            }
        }
        if (useInternalAddonsManager) {
            logger.warn("Use internal addons manager.");
            this.showInternalAddonsManager(null);
        }
    }

    private void showInternalAddonsManager(Object[] args) {
        String subcmd;
        boolean skipBundleSelection = false;
        if (args != null && args.length > 0 && "skipBundleSelection".equalsIgnoreCase(subcmd = (String)args[0])) {
            skipBundleSelection = true;
        }
        PluginsManager manager = PluginsLocator.getManager();
        try {
            PluginServices.getMDIManager().addCentredWindow((IWindow)new InstallPackageWindow(manager.getApplicationFolder(), manager.getInstallFolder(), skipBundleSelection));
        }
        catch (Error e) {
            logger.warn("Error creating the wizard to install a package ", (Throwable)e);
        }
        catch (Throwable e) {
            logger.warn("Error creating the wizard to install a package ", e);
        }
    }

    public void initialize() {
        PluginsManager pm = PluginsLocator.getManager();
        PackageInfo packageInfo = pm.getPackageInfo();
        Version version = packageInfo.getVersion();
        InstallerLocator.getInstallerManager().setVersion(version);
        try {
            IconThemeHelper.registerIcon((String)"action", (String)"tools-addonsmanager", (Object)((Object)this));
            SwingInstallerManager manager = SwingInstallerLocator.getSwingInstallerManager();
            try {
                manager.setDefaultDownloadURL(new File(pm.getApplicationFolder(), "gvsig-installer-urls.config"));
                manager.setDefaultDownloadURL(new File(pm.getPlugin((Object)this).getPluginDirectory(), "defaultDownloadsURLs"));
                if (packageInfo.getState().startsWith("beta") || packageInfo.getState().startsWith("RC") || packageInfo.getState().equalsIgnoreCase("final")) {
                    String installURL = manager.getInstallerManager().getDownloadBaseURL().toString() + "dists/<%Version%>/builds/<%Build%>/packages.gvspki ## Official gvSIG repository (frozen in this version)";
                    manager.addDefaultDownloadURL(installURL);
                }
            }
            catch (Throwable th) {
                logger.info("Error. Can't select default gvspki", th);
            }
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/defaultDownloadsURLs");
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String line = in.readLine();
            while (line != null) {
                try {
                    manager.addDefaultDownloadURL(line);
                }
                catch (MalformedURLException e) {
                    logger.warn("Error creating the default packages download URL pointing to " + line, (Throwable)e);
                }
                line = in.readLine();
            }
            manager.getInstallerManager().setVersion(version);
        }
        catch (Throwable e) {
            logger.warn("Error reading the default packages download URL file /defaultDownloadsURLs", e);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }
}

