/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.mainplugin.beans.createlayer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.Utilities;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.fmap.dal.coverage.util.PropertyEvent;
import org.gvsig.fmap.dal.coverage.util.PropertyListener;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.util.ExtendedFileFilter;

public class NewLayerPanel
implements PropertyListener {
    private JPanel panel = null;
    private JRadioButton jRBFileGenerate = null;
    private JRadioButton jRBOpenMemory = null;
    private JTextField filenameTextField = null;
    private JLabel labelFilename = null;
    private JPanel panelNameFile = null;
    private boolean compress = false;
    private FLyrRaster lyr = null;
    protected FileUtils fileUtil = RasterLocator.getManager().getFileUtils();

    public NewLayerPanel(FLyrRaster lyr) {
        this.lyr = lyr;
        this.initialize();
        this.translate();
    }

    public JPanel getJPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
        }
        return this.panel;
    }

    private void initialize() {
        this.getJPanel().setLayout(new GridBagLayout());
        this.getJPanel().setBorder(BorderFactory.createTitledBorder(""));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.getRadioFileGenerate());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        this.getJPanel().add((Component)this.getRadioFileGenerate(), gridBagConstraints);
        buttonGroup2.add(this.getRadioOpenMemory());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getJPanel().add((Component)this.getRadioOpenMemory(), gridBagConstraints);
    }

    private void translate() {
        this.getRadioFileGenerate().setText(PluginServices.getText((Object)this, (String)"generar_fichero"));
        this.getRadioOpenMemory().setText(PluginServices.getText((Object)this, (String)"abrir_memoria"));
        this.getLabelFilename().setText(PluginServices.getText((Object)this, (String)"nombre_capa") + ":");
    }

    public JRadioButton getRadioFileGenerate() {
        if (this.jRBFileGenerate == null) {
            this.jRBFileGenerate = new JRadioButton();
            this.jRBFileGenerate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jRBFileGenerate.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.jRBFileGenerate;
    }

    public JRadioButton getRadioOpenMemory() {
        if (this.jRBOpenMemory == null) {
            this.jRBOpenMemory = new JRadioButton();
            this.jRBOpenMemory.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jRBOpenMemory.setMargin(new Insets(0, 0, 0, 0));
            this.jRBOpenMemory.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    NewLayerPanel.this.jRBOpenMemoryStateChanged(evt);
                }
            });
            this.jRBOpenMemory.setSelected(true);
        }
        return this.jRBOpenMemory;
    }

    private JTextField getFilenameTextField() {
        if (this.filenameTextField == null) {
            this.filenameTextField = new JTextField();
            this.filenameTextField.setPreferredSize(new Dimension(150, this.filenameTextField.getPreferredSize().height));
            this.fileUtil.addOnlyLayerNameListener((PropertyListener)this);
        }
        return this.filenameTextField;
    }

    public JPanel getFileNamePanel() {
        if (this.panelNameFile == null) {
            this.panelNameFile = new JPanel();
            this.panelNameFile.add(this.getLabelFilename());
            this.panelNameFile.add(this.getFilenameTextField());
            this.updateNewLayerText();
        }
        return this.panelNameFile;
    }

    private JLabel getLabelFilename() {
        if (this.labelFilename == null) {
            this.labelFilename = new JLabel();
        }
        return this.labelFilename;
    }

    public void setFilenameEnabled(boolean value) {
        this.getFilenameTextField().setEnabled(value);
        this.getLabelFilename().setEnabled(value);
    }

    protected void jRBOpenMemoryStateChanged(ItemEvent evt) {
        if (this.getRadioOpenMemory().getSelectedObjects() != null) {
            this.setFilenameEnabled(true);
        } else {
            this.setFilenameEnabled(false);
        }
    }

    public void updateNewLayerText() {
        this.getFilenameTextField().setText(this.fileUtil.getOnlyLayerName());
    }

    public void setLabelFilename(String text) {
        this.getLabelFilename().setText(text);
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public String getFileSelected() {
        String path = "";
        if (this.getRadioFileGenerate().isSelected()) {
            JFileChooser chooser = new JFileChooser("NEW_LAYER_RASTER_PANEL", JFileChooser.getLastPath((String)"NEW_LAYER_RASTER_PANEL", null));
            chooser.setDialogTitle(PluginServices.getText((Object)this, (String)"seleccionar_fichero"));
            ArrayList extList = new ArrayList();
            try {
                extList = RasterLocator.getManager().getProviderServices().getExtensionsSupported(this.lyr.getDataStore().getDataType()[0], this.lyr.getDataStore().getBandCount());
            }
            catch (RasterDriverException e2) {
                RasterSwingLibrary.messageBoxError((String)"error_extensiones_soportadas", (Object)chooser, (Exception)((Object)e2));
                return null;
            }
            ExtendedFileFilter selected = null;
            for (int i = 0; i < extList.size(); ++i) {
                ExtendedFileFilter filter = new ExtendedFileFilter((String)extList.get(i));
                if (((String)extList.get(i)).equals("tif")) {
                    selected = filter;
                }
                chooser.addChoosableFileFilter((FileFilter)filter);
            }
            if (selected != null) {
                chooser.setFileFilter(selected);
            }
            chooser.setAcceptAllFileFilterUsed(false);
            IWindow w = PluginServices.getMDIManager().getActiveWindow();
            if (!(w instanceof Component)) {
                w = null;
            }
            if (chooser.showSaveDialog((Component)w) != 0) {
                return null;
            }
            JFileChooser.setLastPath((String)"NEW_LAYER_RASTER_PANEL", (File)chooser.getSelectedFile());
            ExtendedFileFilter fileFilter = (ExtendedFileFilter)chooser.getFileFilter();
            path = fileFilter.getNormalizedFilename(chooser.getSelectedFile());
        } else {
            String file = this.getFilenameTextField().getText();
            if (file.compareTo(this.fileUtil.getOnlyLayerName()) == 0) {
                this.fileUtil.usesOnlyLayerName();
            }
            path = !this.compress ? Utilities.createTempDirectory() + File.separator + file + ".tif" : Utilities.createTempDirectory() + File.separator + file + ".jp2";
            this.updateNewLayerText();
        }
        return path;
    }

    public void actionValueChanged(PropertyEvent e) {
        this.updateNewLayerText();
    }
}

