/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.RasterMainPluginUtils;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roimask.algorithm.ROIMaskProcess;
import org.gvsig.raster.roimask.app.MainPanel;
import org.gvsig.raster.roimask.app.ROIMaskPreview;
import org.gvsig.raster.roimask.app.ROIMaskTocMenuEntry;
import org.gvsig.raster.roimask.app.ROIMaskWindow;
import org.gvsig.raster.roimask.app.toolbox.ToolboxROIMaskLoader;
import org.gvsig.raster.roimask.swing.ROIMaskPanel;
import org.gvsig.raster.roimask.swing.ROIMaskSwingLocator;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.newlayer.CreateNewLayerPanel;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewPanel;
import org.gvsig.raster.util.RasterNotLoadException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROIMaskExtension
extends Extension
implements ActionListener,
IProcessActions {
    private int windowWidth = 600;
    private int windowHeight = 370;
    private IWindow window = null;
    private PreviewPanel previewPanel = null;
    private ROIMaskPreview processPreview = null;
    private ROIMaskPanel panel = null;
    private CreateNewLayerPanel newLayerPanel = null;
    private static final Logger logger = LoggerFactory.getLogger(ROIMaskExtension.class);

    public void initialize() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("GenericToolBarMenu");
        point.append("ROIMask", "", (ExtensionBuilder)ROIMaskTocMenuEntry.getSingleton());
        ROIMaskTocMenuEntry.setExtension(this);
        Messages.addResourceFamily((String)"org.gvsig.raster.roimask.app.i18n.text", (ClassLoader)ROIMaskExtension.class.getClassLoader(), (String)ROIMaskExtension.class.getClass().getName());
        this.initilizeIcons();
    }

    public void postInitialize() {
        new ToolboxROIMaskLoader().registerTool();
    }

    public void execute(String actionCommand) {
        if (actionCommand.compareTo("ROIMask") == 0) {
            if (this.getSelectedLayer() == null) {
                RasterSwingLibrary.messageBoxError((String)"layer_not_selected", null);
                return;
            }
            try {
                this.initializeMainPanel();
            }
            catch (ReadException e) {
                logger.error("Error initializing the main panel", (Throwable)e);
            }
            catch (ROIException e) {
                logger.error("Error getting ROI", (Throwable)e);
            }
        }
    }

    private void initializeMainPanel() throws ReadException, ROIException {
        try {
            this.loadROIMaskPanel();
        }
        catch (NotInitializeException e) {
            throw new ReadException("Error loading the table", (Throwable)e);
        }
        MainPanel mainPanel = new MainPanel(this.getROIMaskPanel().getComponent(), (JComponent)this.getNewLayerPanel());
        this.window = new ROIMaskWindow(mainPanel, (JPanel)this.getPreviewPanel(), Messages.getText((String)"roimask"), this.windowWidth, this.windowHeight, false, this);
        PluginServices.getMDIManager().addWindow(this.window);
        this.getPreviewPanel().previewInitializeSizes();
        this.getPreviewPanel().refreshPreview();
    }

    private void loadROIMaskPanel() throws NotInitializeException, ROIException {
        FLyrRaster lyr = this.getSelectedLayer();
        LayerElement element = new LayerElement((FLayer)lyr);
        this.getROIMaskPanel().getDataModel().setInputLayer((Object)element);
        ColorInterpretation ci = lyr.getDataStore().getColorInterpretation();
        if (ci.isRGB() || ci.isRGBA()) {
            this.getROIMaskPanel().activeSlider(true);
        } else {
            this.getROIMaskPanel().activeSlider(false);
        }
        if (lyr.getRois() == null || lyr.getRois().size() == 0) {
            this.getROIMaskPanel().showWarning(true);
        } else {
            this.getROIMaskPanel().showWarning(false);
        }
        this.getROIMaskPanel().getDataModel().clearROIs();
        List roisArray = lyr.getRois();
        if (roisArray != null) {
            for (int i = 0; i < roisArray.size(); ++i) {
                ROI roi = (ROI)roisArray.get(i);
                Object[] row = new Object[]{"", "", ""};
                boolean active = false;
                row[0] = new Boolean(active);
                row[1] = roi.getName();
                row[2] = new Integer(i);
                this.getROIMaskPanel().getDataModel().addROI(row);
            }
        }
        if (lyr != null) {
            switch (lyr.getDataStore().getDataType()[0]) {
                case 0: {
                    this.getROIMaskPanel().getDataModel().setValueNoData((double)RasterLibrary.defaultByteNoDataValue);
                    break;
                }
                case 2: {
                    this.getROIMaskPanel().getDataModel().setValueNoData((double)RasterLibrary.defaultShortNoDataValue);
                    break;
                }
                case 3: {
                    this.getROIMaskPanel().getDataModel().setValueNoData((double)RasterLibrary.defaultIntegerNoDataValue);
                    break;
                }
                case 4: {
                    this.getROIMaskPanel().getDataModel().setValueNoData((double)RasterLibrary.defaultFloatNoDataValue);
                    break;
                }
                case 5: {
                    this.getROIMaskPanel().getDataModel().setValueNoData(RasterLibrary.defaultDoubleNoDataValue);
                }
            }
        }
    }

    private FLayers getLayers() {
        MapControl mapControl = null;
        IWindow[] windowList = PluginServices.getMDIManager().getOrderedWindows();
        for (int i = 0; i < windowList.length; ++i) {
            if (!(windowList[i] instanceof AbstractViewPanel)) continue;
            mapControl = ((AbstractViewPanel)windowList[i]).getMapControl();
            break;
        }
        if (mapControl != null) {
            return mapControl.getMapContext().getLayers();
        }
        return null;
    }

    private FLyrRaster getSelectedLayer() {
        FLayers lyrs = this.getLayers();
        if (lyrs != null) {
            for (int i = 0; i < lyrs.getLayersCount(); ++i) {
                FLayer lyr = lyrs.getLayer(i);
                if (!lyr.isActive() || !(lyr instanceof FLyrRaster)) continue;
                return (FLyrRaster)lyr;
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FLyrRaster selectedLayer = this.getSelectedLayer();
        if (selectedLayer == null) {
            return false;
        }
        return selectedLayer != null && selectedLayer.isActive() && selectedLayer instanceof FLyrRaster;
    }

    public boolean isVisible() {
        FLyrRaster selectedLayer = this.getSelectedLayer();
        if (selectedLayer == null) {
            return false;
        }
        if (!(selectedLayer instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedLayer).isActionEnabled(13);
    }

    void initilizeIcons() {
        IconThemeHelper.registerIcon(null, (String)"gvsig-icon", (Object)this);
        IconThemeHelper.registerIcon(null, (String)"mask-icon", (Object)this);
        IconThemeHelper.registerIcon(null, (String)"gvsig-icon16x16", (Object)this);
    }

    private CreateNewLayerPanel getNewLayerPanel() {
        if (this.newLayerPanel == null) {
            this.newLayerPanel = RasterSwingLocator.getSwingManager().createNewLayerPanel(Messages.getText((String)"create_output_layer"));
        }
        return this.newLayerPanel;
    }

    private PreviewPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            this.previewPanel = RasterSwingLocator.getSwingManager().createSinglePreviewPanel(null, (DataSourcePreview)this.getDataSourcePreview());
        }
        return this.previewPanel;
    }

    private ROIMaskPreview getDataSourcePreview() {
        if (this.processPreview == null) {
            this.processPreview = new ROIMaskPreview();
        }
        this.processPreview.setData(this.getROIMaskPanel().getDataModel());
        return this.processPreview;
    }

    private ROIMaskPanel getROIMaskPanel() {
        if (this.panel == null) {
            this.panel = ROIMaskSwingLocator.getSwingManager().createROIMaskPanel();
            this.panel.addListener((ActionListener)this);
        }
        return this.panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.window != null && (e.getSource() == ((ROIMaskWindow)this.window).getButtonsPanel().getButton(1) || e.getSource() == ((ROIMaskWindow)this.window).getButtonsPanel().getButton(3))) {
            DataProcess task = null;
            try {
                task = RasterBaseAlgorithmLibrary.getManager().createRasterTask("ROIMaskProcess");
            }
            catch (ProcessException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_processing_layer", null, (Exception)((Object)e1));
            }
            task.setActions((IProcessActions)this);
            try {
                this.getDataSourcePreview().addParams(task, this.getNewLayerPanel().getDirectorySelected(), this.getNewLayerPanel().getFileSelected());
            }
            catch (ROIException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_processing_layer", null, (Exception)((Object)e1));
            }
            task.start();
            return;
        }
        this.getPreviewPanel().refreshPreview();
    }

    public void end(Object params) {
        if (params instanceof HashMap) {
            HashMap map = (HashMap)params;
            String fName = (String)map.get(ROIMaskProcess.FILENAME);
            long milis = (Long)map.get(ROIMaskProcess.TIME);
            this.processFinalize(fName, milis);
            RasterSwingLocator.getSwingManager().showSummaryProcessDialog(fName, milis);
        }
    }

    private void processFinalize(String fileName, long milis) {
        if (!new File(fileName).exists()) {
            return;
        }
        String viewName = this.getViewName();
        if (viewName != null && RasterSwingLibrary.messageBoxYesOrNot((String)"cargar_toc", (Object)this)) {
            try {
                RasterMainPluginUtils.loadLayer((String)viewName, (String)fileName, null);
            }
            catch (RasterNotLoadException e) {
                RasterSwingLibrary.messageBoxError((String)"error_load_layer", null, (Exception)((Object)e));
            }
        }
    }

    private String getViewName() {
        FLyrRaster lyrRaster = this.getSelectedLayer();
        IWindow[] w = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < w.length; ++i) {
            if (!(w[i] instanceof AbstractViewPanel)) continue;
            FLayers lyrs = ((AbstractViewPanel)w[i]).getMapControl().getMapContext().getLayers();
            for (int j = 0; j < lyrs.getLayersCount(); ++j) {
                FLayer lyr = lyrs.getLayer(j);
                if (lyrRaster != lyr) continue;
                return PluginServices.getMDIManager().getWindowInfo((IWindow)((AbstractViewPanel)w[i])).getTitle();
            }
        }
        return null;
    }

    public void interrupted() {
    }

    public void updateProgress(int current, int total) {
    }

    public class LayerElement {
        private FLayer lyr = null;

        public LayerElement(FLayer lyr) {
            this.lyr = lyr;
        }

        public FLayer getLayer() {
            return this.lyr;
        }

        public String toString() {
            return this.lyr.getName();
        }

        public int getNumOfElements() {
            if (this.lyr instanceof FLyrRaster) {
                return ((FLyrRaster)this.lyr).getDataStore().getBandCount();
            }
            return 0;
        }
    }
}

