/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.app.toolbox;

import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.core.ToolboxAction;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FLyrRasterIRasterLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;

public abstract class AbstractToolboxAction
extends ToolboxAction {
    protected FLyrRaster lyr = null;

    public String getGroup() {
        return Messages.getText((String)"group_tools");
    }

    public boolean isActive() {
        IWindow[] windows = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < windows.length; ++i) {
            if (!(windows[i] instanceof AbstractViewPanel)) continue;
            FLayers lyrs = ((AbstractViewPanel)windows[i]).getMapControl().getMapContext().getLayers();
            for (int j = 0; j < lyrs.getLayersCount(); ++j) {
                if (!(lyrs.getLayer(j) instanceof FLyrRaster)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract boolean isPluginInstalled();

    public boolean loadLayer() {
        if (!this.isPluginInstalled()) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"plugin_not_installed"), null);
            return false;
        }
        if (!this.isActive()) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"layer_not_valid"), null);
            return false;
        }
        boolean existsRasterButNotActive = false;
        this.lyr = null;
        IWindow[] windows = PluginServices.getMDIManager().getOrderedWindows();
        MapContext mapCtx = null;
        for (int i = 0; i < windows.length; ++i) {
            if (!(windows[i] instanceof AbstractViewPanel)) continue;
            mapCtx = ((AbstractViewPanel)windows[i]).getMapControl().getMapContext();
            break;
        }
        IRasterLayer[] layers = SextanteGUI.getInputFactory().getRasterLayers();
        for (int i = 0; i < layers.length; ++i) {
            FLyrRaster l = (FLyrRaster)((FLyrRasterIRasterLayer)layers[i]).getBaseDataObject();
            existsRasterButNotActive = true;
            if (!l.isActive() || mapCtx != l.getMapContext()) continue;
            existsRasterButNotActive = false;
            this.lyr = l;
            break;
        }
        if (existsRasterButNotActive) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"raster_layer_not_active"), null);
            return false;
        }
        return true;
    }
}

