/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.dynamiclegend;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.logging.Level;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.dynamiclegend.DynamicSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.ISimpleFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.SimpleFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ISimpleLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.ISimpleMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ILineStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ISimpleLineStyle;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDynamicSymbol
extends AbstractSymbol
implements DynamicSymbol {
    private Feature feature = null;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleFillSymbol.class);
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    public static Expression eOutlineColor = null;
    public static Expression eFillColor = null;
    public static Expression eSize = null;
    public static Expression eRotation = null;
    private ISimpleMarkerSymbol pointSymbol = null;
    private ISimpleLineSymbol lineSymbol = null;
    private ISimpleFillSymbol polygonSymbol = null;
    public FeatureSymbolTable featureSymbolTable = null;
    public SymbolTable symbolTable = ExpressionEvaluatorLocator.getManager().createSymbolTable();
    private Expression eOffset;
    private List<String> listRequiredAttributeNames;

    public DefaultDynamicSymbol() {
        this.featureSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
        this.symbolTable.addSymbolTable((SymbolTable)this.featureSymbolTable);
    }

    public void setFeature(Feature feat) {
        this.feature = feat;
        if (this.featureSymbolTable == null) {
            this.getFeatureSymbolTable();
        }
        this.featureSymbolTable.setFeature(feat);
    }

    public DynamicSymbol clone() throws CloneNotSupportedException {
        return null;
    }

    public ISymbol getSymbolForSelection(Color selectionColor) {
        int typeGeom = this.feature.getDefaultGeometry().getGeometryType().getType();
        if (GeometryUtils.isSubtype((int)1, (int)typeGeom) || GeometryUtils.isSubtype((int)7, (int)typeGeom)) {
            this.setPointSymbolValues();
            this.pointSymbol.setColor(selectionColor);
            this.pointSymbol.setOutlineColor(selectionColor);
            return this.pointSymbol;
        }
        if (GeometryUtils.isSubtype((int)2, (int)typeGeom) || GeometryUtils.isSubtype((int)8, (int)typeGeom)) {
            this.setLineSymbolValues();
            this.lineSymbol.setColor(selectionColor);
            return this.lineSymbol;
        }
        if (GeometryUtils.isSubtype((int)3, (int)typeGeom) || GeometryUtils.isSubtype((int)9, (int)typeGeom)) {
            this.setPolygonSymbolValues();
            this.polygonSymbol.setFillColor(selectionColor);
            return this.polygonSymbol;
        }
        return null;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        Color c = this.getColor();
        int typeGeom = geom.getGeometryType().getType();
        if (GeometryUtils.isSubtype((int)1, (int)typeGeom) || GeometryUtils.isSubtype((int)7, (int)typeGeom)) {
            this.drawPoint(g, affineTransform, geom, f, cancel);
        } else if (GeometryUtils.isSubtype((int)2, (int)typeGeom) || GeometryUtils.isSubtype((int)8, (int)typeGeom)) {
            this.drawLine(g, affineTransform, geom, f, cancel);
        } else if (GeometryUtils.isSubtype((int)3, (int)typeGeom) || GeometryUtils.isSubtype((int)9, (int)typeGeom)) {
            this.drawPolygon(g, affineTransform, geom, f, cancel);
        } else {
            try {
                Geometry env = geom.getEnvelope().getGeometry();
                env.transform(affineTransform);
                Envelope env2 = env.getEnvelope();
                if (env2.getLength(0) < 1.5 && env2.getLength(1) < 1.5) {
                    geom = env2.getUpperCorner();
                }
            }
            catch (Exception ex) {
                LOG.warn("Error optimizing the drawing of the geometry. Continues with normal drawing.", (Throwable)ex);
            }
            g.setColor(c);
            g.fill(geom.getShape(affineTransform));
            g.draw(geom.getShape(affineTransform));
        }
    }

    protected void drawPolygon(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel) {
        this.setPolygonSymbolValues();
        this.polygonSymbol.draw(g, affineTransform, geom, f, cancel);
    }

    protected void setPolygonSymbolValues() {
        if (this.polygonSymbol == null) {
            this.polygonSymbol = SymbologyLocator.getSymbologyManager().createSimpleFillSymbol();
        }
        this.setLineSymbolValues();
        this.lineSymbol.setColor(this.getComputedOutlineColor());
        this.polygonSymbol.setOutline((ILineSymbol)this.lineSymbol);
        this.polygonSymbol.setFillColor(this.getComputedFillColor());
        this.polygonSymbol.setHasOutline(true);
        this.polygonSymbol.setHasFill(true);
    }

    protected void setLineSymbolValues() {
        if (this.lineSymbol == null) {
            this.lineSymbol = SymbologyLocator.getSymbologyManager().createSimpleLineSymbol();
        }
        this.lineSymbol.setLineColor(this.getComputedOutlineColor());
        this.lineSymbol.setLineWidth((double)this.getComputedSize());
        ISimpleLineStyle lineStyle = SymbologyLocator.getSymbologyManager().createSimpleLineStyle();
        lineStyle.setOffset(0.0);
        BasicStroke stroke = new BasicStroke(this.getComputedSize(), 0, 0);
        lineStyle.setStroke((Stroke)stroke);
        this.lineSymbol.setLineStyle((ILineStyle)lineStyle);
    }

    protected void drawLine(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel) {
        this.setLineSymbolValues();
        this.lineSymbol.draw(g, affineTransform, geom, f, cancel);
    }

    protected void setPointSymbolValues() {
        if (this.pointSymbol == null) {
            this.pointSymbol = SymbologyLocator.getSymbologyManager().createSimpleMarkerSymbol();
        }
        this.pointSymbol.setColor(this.getColor());
        this.pointSymbol.setSize((double)this.getComputedSize());
        this.pointSymbol.setRotation(0.0);
        this.pointSymbol.setStyle(0);
        this.pointSymbol.setOutlined(true);
        this.pointSymbol.setOutlineSize(2.0);
        this.pointSymbol.setOutlineColor(this.getComputedOutlineColor());
    }

    protected void drawPoint(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel) {
        this.setPointSymbolValues();
        this.pointSymbol.draw(g, affineTransform, geom, f, cancel);
    }

    public int getSymbolType() {
        int type = this.feature.getDefaultGeometry().getGeometryType().getType();
        return type;
    }

    public boolean isSuitableFor(Geometry geom) {
        return true;
    }

    public SymbolTable getFeatureSymbolTable() {
        if (this.symbolTable == null) {
            MutableSymbolTable s = ExpressionEvaluatorLocator.getManager().createSymbolTable();
            FeatureSymbolTable fst = DALLocator.getDataManager().createFeatureSymbolTable();
            s.addSymbolTable((SymbolTable)fst);
            if (this.feature != null) {
                fst.setFeature(this.feature);
            }
            this.symbolTable = s;
        }
        return this.symbolTable;
    }

    public Color getColor() {
        Expression value = this.getComputedColor();
        return this.getColorFromExpression(value);
    }

    public Expression getComputedColor() {
        return eFillColor;
    }

    public Expression getOutlineColor() {
        return eOutlineColor;
    }

    public Color getComputedOutlineColor() {
        return this.getColorFromExpression(this.getOutlineColor());
    }

    public void setOutlineColor(Expression exp) {
        eOutlineColor = exp;
    }

    public Expression getFillColor() {
        return eFillColor;
    }

    public Color getComputedFillColor() {
        return this.getColorFromExpression(this.getFillColor());
    }

    public void setFillColor(Expression exp) {
        eFillColor = exp;
    }

    public Expression getSize() {
        return eSize;
    }

    public int getComputedSize() {
        Expression exp = this.getSize();
        Integer size = (Integer)exp.execute(this.getFeatureSymbolTable());
        return size;
    }

    public void setSize(Expression exp) {
        eSize = exp;
    }

    public Expression getOffset() {
        return this.eOffset;
    }

    public void setOffset(Expression offset) {
        this.eOffset = offset;
    }

    public Point getComputedOffset() {
        Point pointOffset = null;
        try {
            pointOffset = GeometryLocator.getGeometryManager().createPoint(0.0, 0.0, 0);
        }
        catch (CreateGeometryException ex) {
            java.util.logging.Logger.getLogger(DefaultDynamicSymbol.class.getName()).log(Level.SEVERE, null, ex);
        }
        return pointOffset;
    }

    public Expression getRotation() {
        return eRotation;
    }

    public int getComputedRotation() {
        Expression exp = this.getRotation();
        Integer size = (Integer)exp.execute(this.getFeatureSymbolTable());
        return size;
    }

    public void setRotation(Expression exp) {
        eRotation = exp;
    }

    private Color getColorFromExpression(Expression exp) {
        Integer rgbcolor = (Integer)exp.execute(this.getFeatureSymbolTable());
        Color color = new Color(rgbcolor, true);
        return color;
    }

    public void setColor(Color color) {
    }

    public void setColor(Expression color) {
        eOutlineColor = color;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void print(Graphics2D g, AffineTransform at, Geometry shape, PrintAttributes properties) {
        if (shape.getGeometryType().getType() == 19) {
            Color c = this.getColor();
            if (c != null) {
                g.setColor(c);
                g.fill(shape.getShape(at));
            }
            if (this.getComputedOutlineColor() == null) return;
        }
        if (shape.getGeometryType().getType() != 1) return;
        this.draw(g, at, shape, null, null);
    }

    public String[] getRequiredFeatureAttributeNames(FeatureStore featureStore) throws DataException {
        return this.listRequiredAttributeNames.toArray(new String[this.listRequiredAttributeNames.size()]);
    }

    public void setRequiredFeatureAttributesNames(List<String> listRequiredAttributeNames) {
        this.listRequiredAttributeNames = listRequiredAttributeNames;
    }

    public static void selfRegister() {
        MapContextLocator.getSymbolManager().registerSymbol("DynamicSymbol", DefaultDynamicSymbol.class);
    }
}

