/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.driver.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.exceptions.IncompatibleLegendReadException;
import org.gvsig.fmap.mapcontext.exceptions.ReadLegendException;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.driver.ILegendReader;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.persistence.PersistenceManager;

public class PersistenceBasedLegendReader
implements ILegendReader {
    public ILegend read(File inFile, int geometryType) throws ReadLegendException, IncompatibleLegendReadException, IOException {
        FileInputStream istr = null;
        istr = new FileInputStream(inFile);
        ILegend resp = null;
        try {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            Object inobj = manager.getObject((InputStream)istr);
            resp = (ILegend)inobj;
        }
        catch (Exception exc) {
            throw new ReadLegendException(inFile, (Throwable)exc);
        }
        ((InputStream)istr).close();
        if (resp instanceof IVectorLegend) {
            IVectorLegend vleg = (IVectorLegend)resp;
            GeometryType foundgt = null;
            try {
                foundgt = GeometryLocator.getGeometryManager().getGeometryType(vleg.getShapeType(), 0);
            }
            catch (Exception e) {
                throw new IncompatibleLegendReadException(inFile, geometryType, (Throwable)e);
            }
            if (geometryType != 0 && !foundgt.isTypeOf(geometryType)) {
                throw new IncompatibleLegendReadException(inFile, geometryType, (Throwable)new Exception("Geometry type found: " + vleg.getShapeType()));
            }
        }
        return resp;
    }
}

