/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.CartographicSupportToolkit;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public abstract class AbstractFillSymbol
extends AbstractSymbol
implements IFillSymbol {
    public static final String FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME = "FillSymbol";
    private static final String FIELD_OUTLINE = "outline";
    private static final String FIELD_HAS_OUTLINE = "hasOutline";
    private static final String FIELD_HAS_FILL = "hasFill";
    private static final String FIELD_COLOR = "color";
    private boolean hasFill = true;
    private boolean hasOutline = true;
    private Color color;
    private ILineSymbol outline;

    public AbstractFillSymbol() {
        SymbolManager symbolManager = MapContextLocator.getSymbolManager();
        SymbolPreferences symbolPreferences = symbolManager.getSymbolPreferences();
        this.color = symbolPreferences.getDefaultSymbolFillColor();
        this.outline = (ILineSymbol)symbolManager.createSymbol("line");
        this.outline.setColor(symbolPreferences.getDefaultSymbolColor());
        BasicStroke basicStroke = new BasicStroke(1.0f, 2, 2);
        this.outline.getLineStyle().setStroke((Stroke)basicStroke);
    }

    public boolean isSuitableFor(Geometry geom) {
        GeometryType gt = geom.getGeometryType();
        return gt.isTypeOf(3);
    }

    public void setFillColor(Color color) {
        this.color = color;
    }

    public void setOutline(ILineSymbol outline) {
        this.outline = outline;
    }

    public Color getFillColor() {
        return this.color;
    }

    public ILineSymbol getOutline() {
        return this.outline;
    }

    public int getFillAlpha() {
        if (this.color == null) {
            return 255;
        }
        return this.color.getAlpha();
    }

    public void setCartographicSize(double cartographicSize, Geometry geom) {
        if (this.getOutline() != null) {
            this.getOutline().setLineWidth(cartographicSize);
        }
    }

    public double toCartographicSize(ViewPort viewPort, double dpi, Geometry geom) {
        if (this.getOutline() != null) {
            double oldSize = this.getOutline().getLineWidth();
            this.setCartographicSize(this.getCartographicSize(viewPort, dpi, geom), geom);
            return oldSize;
        }
        return 0.0;
    }

    public boolean hasFill() {
        return this.hasFill;
    }

    public void setHasFill(boolean hasFill) {
        this.hasFill = hasFill;
    }

    public boolean hasOutline() {
        return this.hasOutline;
    }

    public void setHasOutline(boolean hasOutline) {
        this.hasOutline = hasOutline;
    }

    public double getCartographicSize(ViewPort viewPort, double dpi, Geometry geom) {
        if (this.getOutline() != null) {
            return CartographicSupportToolkit.getCartographicLength((CartographicSupport)this, (double)this.getOutline().getLineWidth(), (ViewPort)viewPort, (double)dpi);
        }
        return 0.0;
    }

    public void setUnit(int unitIndex) {
        super.setUnit(unitIndex);
        if (this.getOutline() != null) {
            this.getOutline().setUnit(unitIndex);
        }
    }

    public Color getColor() {
        return this.getFillColor();
    }

    public void setColor(Color color) {
        this.setFillColor(color);
    }

    public Object clone() throws CloneNotSupportedException {
        IFillSymbol copy = (IFillSymbol)super.clone();
        ILineSymbol theOutline = copy.getOutline();
        if (theOutline != null) {
            copy.setOutline((ILineSymbol)theOutline.clone());
        }
        return copy;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setColor((Color)state.get(FIELD_COLOR));
        this.setHasFill(state.getBoolean(FIELD_HAS_FILL));
        this.setHasOutline(state.getBoolean(FIELD_HAS_OUTLINE));
        this.setOutline((ILineSymbol)state.get(FIELD_OUTLINE));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_COLOR, (Object)this.getColor());
        state.set(FIELD_HAS_FILL, this.hasFill());
        state.set(FIELD_HAS_OUTLINE, this.hasOutline());
        state.set(FIELD_OUTLINE, (Persistent)this.getOutline());
    }

    protected Geometry getSampleGeometry(Rectangle r) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createEnvelope((double)(r.x + 1), (double)(r.y + 1), (double)(r.x + r.width - 2), (double)(r.y + r.height - 2), 0).getGeometry();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create smple geometry.", e);
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(AbstractFillSymbol.FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(AbstractFillSymbol.class, AbstractFillSymbol.FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME, "FillSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("Symbol"));
                definition.addDynFieldObject(AbstractFillSymbol.FIELD_COLOR).setMandatory(false).setClassOfValue(Color.class);
                definition.addDynFieldBoolean(AbstractFillSymbol.FIELD_HAS_FILL).setMandatory(true);
                definition.addDynFieldBoolean(AbstractFillSymbol.FIELD_HAS_OUTLINE).setMandatory(true);
                definition.addDynFieldObject(AbstractFillSymbol.FIELD_OUTLINE).setMandatory(false).setClassOfValue(ILineSymbol.class);
            }
            return Boolean.TRUE;
        }
    }
}

