/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.IMultiShapeSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ILineStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMask;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.NotYetImplemented;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiShapeSymbol
extends AbstractSymbol
implements ILineSymbol,
IMarkerSymbol,
IFillSymbol,
IMultiShapeSymbol {
    private static final Logger LOG = LoggerFactory.getLogger(MultiShapeSymbol.class);
    public static final String MULTI_SHAPE_SYMBOL_PERSISTENCE_DEFINITION_NAME = "MultiShapeSymbol";
    private static final String FIELD_MARKER = "marker";
    private static final String FIELD_LINE = "line";
    private static final String FIELD_FILL = "fill";
    private static final String FIELD_DESCRIPTION = "description";
    public static final String SYMBOL_NAME = "multiShape";
    private IMarkerSymbol marker = (IMarkerSymbol)this.createSymbol("marker");
    private ILineSymbol line = (ILineSymbol)this.createSymbol("line");
    private IFillSymbol fill = (IFillSymbol)this.createSymbol("fill");
    private IMask mask;
    private int referenceSystem;
    private MultiShapeSymbol symSelect;

    private ISymbol createSymbol(String symbolName) {
        SymbolManager manager = MapContextLocator.getSymbolManager();
        return manager.createSymbol(symbolName);
    }

    public Color getLineColor() {
        return this.line.getColor();
    }

    public void setLineColor(Color color) {
        this.line.setLineColor(color);
    }

    public ILineStyle getLineStyle() {
        return this.line.getLineStyle();
    }

    public void setLineStyle(ILineStyle lineStyle) {
        this.line.setLineStyle(lineStyle);
    }

    public void setLineWidth(double width) {
        this.line.setLineWidth(width);
    }

    public double getLineWidth() {
        return this.line.getLineWidth();
    }

    public int getAlpha() {
        return this.line.getAlpha();
    }

    public void setAlpha(int outlineAlpha) {
        this.line.setAlpha(outlineAlpha);
    }

    public ISymbol getSymbolForSelection() {
        if (this.symSelect == null) {
            this.symSelect = new MultiShapeSymbol();
        }
        if (this.marker != null) {
            this.symSelect.setMarkerSymbol((IMarkerSymbol)this.marker.getSymbolForSelection());
        }
        if (this.line != null) {
            this.symSelect.setLineSymbol((ILineSymbol)this.line.getSymbolForSelection());
        }
        if (this.fill != null) {
            this.symSelect.setFillSymbol((IFillSymbol)this.fill.getSymbolForSelection());
        }
        if (this.symSelect instanceof CartographicSupport) {
            this.symSelect.setUnit(this.getUnit());
        }
        return this.symSelect;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        if (r != null) {
            double myWidth = r.getWidth() / 3.0;
            Rectangle rect = new Rectangle(0, 0, (int)myWidth, r.height);
            if (this.marker != null) {
                CartographicSupport.copyCartographicContext((CartographicSupport)this, (Object)this.marker);
                g.translate(r.x, r.y);
                this.marker.draw(g, affineTransform, geom, f, cancel, rect);
                g.translate(-r.x, -r.y);
            }
            if (this.line != null) {
                CartographicSupport.copyCartographicContext((CartographicSupport)this, (Object)this.line);
                g.translate((double)r.x + myWidth, (double)r.y);
                this.line.draw(g, affineTransform, geom, f, cancel, rect);
                g.translate(-((double)r.x + myWidth), (double)(-r.y));
            }
            if (this.fill != null) {
                CartographicSupport.copyCartographicContext((CartographicSupport)this, (Object)this.fill);
                g.translate((double)r.x + myWidth + myWidth, (double)r.y);
                this.fill.draw(g, affineTransform, geom, f, cancel, rect);
                g.translate(-((double)r.x + myWidth + myWidth), (double)(-r.y));
            }
        } else {
            GeometryType geometryType = geom.getGeometryType();
            if (geometryType.isTypeOf(1)) {
                if (this.marker != null) {
                    CartographicSupport.copyCartographicContext((CartographicSupport)this, (Object)this.marker);
                    this.marker.draw(g, affineTransform, geom, f, cancel, r);
                }
            } else if (geometryType.isTypeOf(2)) {
                if (this.line != null) {
                    CartographicSupport.copyCartographicContext((CartographicSupport)this, (Object)this.line);
                    this.line.draw(g, affineTransform, geom, f, cancel, r);
                }
            } else if (geometryType.isTypeOf(3)) {
                if (this.fill != null) {
                    CartographicSupport.copyCartographicContext((CartographicSupport)this, (Object)this.fill);
                    this.fill.draw(g, affineTransform, geom, f, cancel, r);
                }
            } else if (geometryType.isTypeOf(6)) {
                Aggregate aggregate = (Aggregate)geom;
                for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
                    this.draw(g, affineTransform, (Geometry)aggregate.getPrimitiveAt(i), f, cancel, r);
                }
            }
        }
    }

    public boolean isShapeVisible() {
        if (this.marker != null) {
            return this.marker.isShapeVisible();
        }
        if (this.line != null) {
            return this.line.isShapeVisible();
        }
        if (this.fill != null) {
            this.fill.isShapeVisible();
        }
        return false;
    }

    public int getSymbolType() {
        return 0;
    }

    public boolean isSuitableFor(Geometry geom) {
        return true;
    }

    public double getRotation() {
        if (this.marker != null) {
            return this.marker.getRotation();
        }
        return 0.0;
    }

    public void setRotation(double rotation) {
        if (this.marker != null) {
            this.marker.setRotation(rotation);
        }
    }

    public Point2D getOffset() {
        if (this.marker != null) {
            return this.marker.getOffset();
        }
        return new Point2D.Double();
    }

    public void setOffset(Point2D offset) {
        if (this.marker != null) {
            this.marker.setOffset(offset);
        }
    }

    public double getSize() {
        if (this.marker != null) {
            return this.marker.getSize();
        }
        return 0.0;
    }

    public void setSize(double size) {
        if (this.marker != null) {
            this.marker.setSize(size);
        }
    }

    public Color getColor() {
        if (this.marker != null) {
            return this.marker.getColor();
        }
        return null;
    }

    public void setColor(Color color) {
        if (this.marker != null) {
            this.marker.setColor(color);
        }
    }

    public void setFillColor(Color color) {
        if (this.fill != null) {
            this.fill.setFillColor(color);
        }
    }

    public void setOutline(ILineSymbol outline) {
        if (this.fill != null) {
            this.fill.setOutline(outline);
        }
    }

    public Color getFillColor() {
        if (this.fill != null) {
            return this.fill.getFillColor();
        }
        return null;
    }

    public ILineSymbol getOutline() {
        if (this.fill != null) {
            return this.fill.getOutline();
        }
        return null;
    }

    public int getFillAlpha() {
        if (this.fill != null) {
            return this.fill.getFillAlpha();
        }
        return 255;
    }

    public IMask getMask() {
        return this.mask;
    }

    public void setUnit(int unitIndex) {
        if (this.marker != null) {
            this.marker.setUnit(unitIndex);
        }
        if (this.line != null) {
            this.line.setUnit(unitIndex);
        }
    }

    public int getUnit() {
        if (this.marker != null) {
            return this.marker.getUnit();
        }
        if (this.line != null) {
            return this.line.getUnit();
        }
        return -1;
    }

    public void setMask(IMask mask) {
        throw new NotYetImplemented();
    }

    public int getReferenceSystem() {
        return this.referenceSystem;
    }

    public void setReferenceSystem(int system) {
        this.referenceSystem = system;
    }

    public IMarkerSymbol getMarkerSymbol() {
        return this.marker;
    }

    public ILineSymbol getLineSymbol() {
        return this.line;
    }

    public IFillSymbol getFillSymbol() {
        return this.fill;
    }

    public void setMarkerSymbol(IMarkerSymbol markerSymbol) {
        this.marker = markerSymbol;
    }

    public void setLineSymbol(ILineSymbol lineSymbol) {
        this.line = lineSymbol;
    }

    public void setFillSymbol(IFillSymbol fillFillSymbol) {
        this.fill = fillFillSymbol;
    }

    public boolean hasFill() {
        if (this.fill == null) {
            return false;
        }
        return this.fill.hasFill();
    }

    public void setHasFill(boolean hasFill) {
        if (this.fill != null) {
            this.fill.setHasFill(hasFill);
        }
    }

    public boolean hasOutline() {
        return false;
    }

    public void setHasOutline(boolean hasOutline) {
    }

    public Object clone() throws CloneNotSupportedException {
        MultiShapeSymbol copy = (MultiShapeSymbol)((Object)super.clone());
        if (this.marker != null) {
            copy.marker = (IMarkerSymbol)this.marker.clone();
        }
        if (this.line != null) {
            copy.line = (ILineSymbol)this.line.clone();
        }
        if (this.fill != null) {
            copy.fill = (IFillSymbol)this.fill.clone();
        }
        if (this.mask != null) {
            copy.mask = (IMask)this.mask.clone();
        }
        if (this.symSelect != null) {
            copy.symSelect = (MultiShapeSymbol)((Object)this.symSelect.clone());
        }
        return copy;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setDescription(state.getString(FIELD_DESCRIPTION));
        this.setFillSymbol((IFillSymbol)state.get(FIELD_FILL));
        this.setMarkerSymbol((IMarkerSymbol)state.get(FIELD_MARKER));
        this.setLineSymbol((ILineSymbol)state.get(FIELD_LINE));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_DESCRIPTION, this.getDescription());
        state.set(FIELD_FILL, (Persistent)this.getFillSymbol());
        state.set(FIELD_MARKER, (Persistent)this.getMarkerSymbol());
        state.set(FIELD_LINE, (Persistent)this.getLineSymbol());
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{0};
            manager.registerSymbol(MultiShapeSymbol.SYMBOL_NAME, shapeTypes, MultiShapeSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(MultiShapeSymbol.MULTI_SHAPE_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(MultiShapeSymbol.class, MultiShapeSymbol.MULTI_SHAPE_SYMBOL_PERSISTENCE_DEFINITION_NAME, "MultiShapeSymbol Persistence definition", null, null);
                definition.addDynFieldString(MultiShapeSymbol.FIELD_DESCRIPTION).setMandatory(false);
                definition.addDynFieldObject(MultiShapeSymbol.FIELD_FILL).setClassOfValue(IFillSymbol.class).setMandatory(true);
                definition.addDynFieldObject(MultiShapeSymbol.FIELD_LINE).setClassOfValue(ILineSymbol.class).setMandatory(true);
                definition.addDynFieldObject(MultiShapeSymbol.FIELD_MARKER).setClassOfValue(IMarkerSymbol.class).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

