/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URL;
import org.apache.batik.ext.awt.geom.DefaultPathLength;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.IPictureLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl.AbstractLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.BackgroundFileStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMask;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PictureLineSymbol
extends AbstractLineSymbol
implements IPictureLineSymbol {
    private static final Logger logger = LoggerFactory.getLogger(PictureLineSymbol.class);
    public static final String PICTURE_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME = "PictureLineSymbol";
    private static final String SELECTED = "selected";
    private static final String SELECTION_SYMBOL = "selectionSym";
    private static final String BACKGROUND_IMAGE = "bgImage";
    private static final String BACKGROUND_SELECTION_IMAGE = "bgSelImage";
    private static final String WIDTH = "width";
    private static final String FIELD_SIZE_EXPRESSION = "sizeExpression";
    private transient PictureLineSymbol selectionSym;
    private double width;
    private boolean selected;
    private BackgroundFileStyle bgImage;
    private BackgroundFileStyle bgSelImage;
    private PrintAttributes properties;
    private double rotation;
    private Point2D offset = new Point2D.Double();
    private IMask mask;
    private Color lineToOffsetColor;
    private boolean drawLineToOffset;
    private String sizeExpression;
    private String offsetXExpression;
    private String offsetYExpression;
    private String rotationExpression;
    private String lineToOffsetColorExpression;
    private FeatureSymbolTable symbolTable = null;

    public PictureLineSymbol() {
    }

    public PictureLineSymbol(URL imageURL, URL selImageURL) throws IOException {
        this.setImage(imageURL);
        if (selImageURL != null) {
            this.setSelImage(selImageURL);
        } else {
            this.setSelImage(imageURL);
        }
    }

    public void setImage(URL imageUrl) throws IOException {
        this.bgImage = BackgroundFileStyle.createStyleByURL(imageUrl);
    }

    public void setSelImage(URL selImageUrl) throws IOException {
        this.bgSelImage = BackgroundFileStyle.createStyleByURL(selImageUrl);
    }

    public void setLineWidth(double width) {
        this.width = width;
        this.getLineStyle().setLineWidth((float)width);
    }

    public double getLineWidth() {
        return this.width;
    }

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.selectionSym == null) {
            this.selectionSym = (PictureLineSymbol)this.cloneForSelection(selectionColor);
            this.selectionSym.selected = true;
            this.selectionSym.selectionSym = this.selectionSym;
        } else {
            this.selectionSym.setColor(selectionColor);
        }
        if (this.selectionSym instanceof CartographicSupport) {
            this.selectionSym.setUnit(this.getUnit());
        }
        return this.selectionSym;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        double effectiveSize;
        double scale;
        if (r != null) {
            geom = this.getSampleGeometry(r);
        }
        if ((scale = this.getScale(effectiveSize = this.getEfectiveSize(f))) <= 0.0) {
            return;
        }
        Shape geom_transf_clip = geom.getShape(affineTransform);
        BackgroundFileStyle bg = !this.selected ? this.bgImage : this.bgSelImage;
        Rectangle bounds = bg.getBounds();
        double imageHeight = effectiveSize;
        double imageWidth = bounds.getWidth() * scale;
        if (imageWidth <= 0.0 || imageHeight <= 0.0) {
            return;
        }
        int height = (int)imageHeight;
        float csWidth = height;
        BasicStroke bs = new BasicStroke(csWidth, 1, 1);
        g.setClip(bs.createStrokedShape(geom_transf_clip));
        DefaultPathLength pl = new DefaultPathLength(geom_transf_clip);
        PathIterator iterator = geom_transf_clip.getPathIterator(null, 0.8);
        double[] theData = new double[6];
        Point2D.Double firstPoint = null;
        Point2D startPoint = null;
        Point2D endPoint = null;
        if (!iterator.isDone() && iterator.currentSegment(theData) != 4) {
            firstPoint = new Point2D.Double(theData[0], theData[1]);
        }
        float currentPathLength = 1.0f;
        Rectangle rect = new Rectangle();
        block7: while (!(cancel != null && cancel.isCanceled() || iterator.isDone())) {
            int theType = iterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    startPoint = new Point2D.Double(theData[0], theData[1]);
                    endPoint = null;
                    iterator.next();
                    continue block7;
                }
                case 1: 
                case 2: 
                case 3: {
                    endPoint = new Point2D.Double(theData[0], theData[1]);
                    break;
                }
                case 4: {
                    endPoint = startPoint;
                    startPoint = firstPoint;
                }
            }
            double a = endPoint.getX() - startPoint.getX();
            double b = endPoint.getY() - startPoint.getY();
            double theta = pl.angleAtLength(currentPathLength);
            if (this.getEfectiveRotationInRadians(f) != 0.0) {
                theta += this.getEfectiveRotationInRadians(f);
            }
            double x = startPoint.getX();
            double y = startPoint.getY();
            float segmentLength = (float)Math.sqrt(a * a + b * b);
            int count = (int)Math.ceil((double)segmentLength / imageWidth);
            for (int i = 0; !(cancel != null && cancel.isCanceled() || i >= count); ++i) {
                g.translate(x, y);
                g.rotate(theta);
                double xOffsetTranslation = imageWidth * (double)i;
                g.translate(xOffsetTranslation, -csWidth);
                rect.setBounds(0, (int)Math.round((double)height * 0.5), (int)Math.ceil(imageWidth), height);
                Dimension rectSize = rect.getSize();
                if (rectSize.getHeight() > 0.0 && rectSize.getWidth() > 0.0) {
                    try {
                        bg.drawInsideRectangle(g, rect, false);
                    }
                    catch (SymbolDrawingException e) {
                        logger.warn(Messages.getText((String)"label_style_could_not_be_painted"), (Throwable)e);
                    }
                }
                g.translate(-xOffsetTranslation, csWidth);
                g.rotate(-theta);
                g.translate(-x, -y);
            }
            startPoint = endPoint;
            currentPathLength += segmentLength;
            iterator.next();
        }
        g.setClip(null);
    }

    protected double getAdjustedSize(Rectangle r, double size) {
        if (r == null) {
            return size;
        }
        double min = Math.min(r.getHeight(), r.getWidth());
        if (size > min) {
            size = min;
        }
        return size;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public URL getSelectedSource() {
        return this.bgSelImage.getSource();
    }

    public URL getSource() {
        return this.bgImage.getSource();
    }

    private double getScale(double size) {
        BackgroundFileStyle image = this.selected ? this.bgSelImage : this.bgImage;
        return size / image.getBounds().getHeight();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PictureLineSymbol copy = (PictureLineSymbol)((Object)super.clone());
        if (this.selectionSym != null) {
            copy.selectionSym = this == this.selectionSym ? copy : (PictureLineSymbol)((Object)this.selectionSym.clone());
        }
        if (this.bgImage != null) {
            copy.bgImage = (BackgroundFileStyle)((Object)this.bgImage.clone());
        }
        if (this.bgSelImage != null) {
            copy.bgSelImage = (BackgroundFileStyle)((Object)this.bgSelImage.clone());
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.selected = (Boolean)state.get(SELECTED);
        this.selectionSym = (PictureLineSymbol)((Object)state.get(SELECTION_SYMBOL));
        this.bgImage = (BackgroundFileStyle)((Object)state.get(BACKGROUND_IMAGE));
        this.bgSelImage = (BackgroundFileStyle)((Object)state.get(BACKGROUND_SELECTION_IMAGE));
        this.setLineWidth(state.getDouble(WIDTH));
        this.setLineWidth(state.getDouble(WIDTH));
        this.setSizeExpression(state.getString(FIELD_SIZE_EXPRESSION));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(SELECTED, this.selected);
        state.set(SELECTION_SYMBOL, (Persistent)this.getSymbolForSelection());
        state.set(BACKGROUND_IMAGE, (Persistent)this.bgImage);
        state.set(BACKGROUND_SELECTION_IMAGE, (Persistent)this.bgSelImage);
        state.set(WIDTH, this.width);
        state.set(FIELD_SIZE_EXPRESSION, this.getSizeExpression());
    }

    protected SymbolTable getSymbolTable(Feature f) {
        if (this.symbolTable == null) {
            this.symbolTable = DALLocator.getManager().createFeatureSymbolTable();
            this.symbolTable.addSymbolTable((SymbolTable)ExpressionUtils.createSymbolTable());
        }
        this.symbolTable.setFeature(f);
        return this.symbolTable;
    }

    public Color getEfectiveLineToOffsetColor(Feature f) {
        if (f == null) {
            f = this.getFeature();
        }
        if (f == null || StringUtils.isBlank((CharSequence)this.lineToOffsetColorExpression)) {
            return this.getLineToOffsetColor();
        }
        Color theColor = ExpressionUtils.parseColor((SymbolTable)this.getSymbolTable(f), (String)this.lineToOffsetColorExpression, (Color)this.getLineToOffsetColor());
        return theColor;
    }

    public Point2D getEfectiveOffset(Feature f) {
        Point2D p;
        if (f == null) {
            f = this.getFeature();
        }
        if (f == null || StringUtils.isBlank((CharSequence)this.offsetXExpression) || StringUtils.isBlank((CharSequence)this.offsetYExpression)) {
            p = this.getOffset();
            p = new Point2D.Double(this.toCartographicUnits(p.getX()), this.toCartographicUnits(p.getY()));
        } else {
            double offsetX = this.toCartographicUnits(ExpressionUtils.parseDouble((SymbolTable)this.getSymbolTable(f), (String)this.offsetXExpression, (double)((int)this.getOffset().getX())));
            double offsetY = this.toCartographicUnits(ExpressionUtils.parseDouble((SymbolTable)this.getSymbolTable(f), (String)this.offsetYExpression, (double)((int)this.getOffset().getY())));
            p = new Point2D.Double(offsetX, offsetY);
        }
        return p;
    }

    public double getEfectiveRotationInDegres(Feature f) {
        if (StringUtils.isBlank((CharSequence)this.rotationExpression)) {
            return Math.toDegrees(this.getRotation());
        }
        if (f == null) {
            f = this.getFeature();
        }
        if (f == null) {
            return Math.toDegrees(this.getRotation());
        }
        double r = ExpressionUtils.parseDouble((SymbolTable)this.getSymbolTable(f), (String)this.rotationExpression, (double)this.getRotation());
        return r;
    }

    public double getEfectiveRotationInRadians(Feature f) {
        if (StringUtils.isBlank((CharSequence)this.rotationExpression)) {
            return this.getRotation();
        }
        double r = this.getEfectiveRotationInDegres(f);
        if (r == 0.0) {
            return 0.0;
        }
        r = Math.toRadians(r);
        return r;
    }

    private double getCartographicSize() {
        return this.toCartographicUnits(this.getSize());
    }

    public double getEfectiveSize(Feature f) {
        if (StringUtils.isBlank((CharSequence)this.sizeExpression)) {
            return this.getCartographicSize();
        }
        if (f == null) {
            f = this.getFeature();
        }
        if (f == null) {
            return this.getCartographicSize();
        }
        double sz = ExpressionUtils.parseDouble((SymbolTable)this.getSymbolTable(f), (String)this.sizeExpression, (double)-1.0);
        if (sz < 0.0) {
            return this.getCartographicSize();
        }
        return this.toCartographicUnits(sz);
    }

    public Color getLineToOffsetColor() {
        return this.lineToOffsetColor;
    }

    public String getLineToOffsetColorExpression() {
        return this.lineToOffsetColorExpression;
    }

    public String getOffsetXExpression() {
        return this.offsetXExpression;
    }

    public String getOffsetYExpression() {
        return this.offsetYExpression;
    }

    public String getRotationExpression() {
        return this.rotationExpression;
    }

    public String getSizeExpression() {
        return this.sizeExpression;
    }

    public boolean isDrawLineToOffset() {
        return this.drawLineToOffset;
    }

    public void setDrawLineToOffset(boolean drawLineToOffset) {
        this.drawLineToOffset = drawLineToOffset;
    }

    public void setLineToOffsetColor(Color color) {
        this.lineToOffsetColor = color;
    }

    public void setLineToOffsetColorExpression(String lineToOffsetColorExpression) {
        this.lineToOffsetColorExpression = StringUtils.trimToNull((String)lineToOffsetColorExpression);
    }

    public void setOffsetXExpression(String offsetXExpression) {
        this.offsetXExpression = StringUtils.trimToNull((String)offsetXExpression);
    }

    public void setOffsetYExpression(String offsetYExpression) {
        this.offsetYExpression = StringUtils.trimToNull((String)offsetYExpression);
    }

    public void setRotationExpression(String rotationExpression) {
        this.rotationExpression = StringUtils.trimToNull((String)rotationExpression);
    }

    public void setSizeExpression(String sizeExpression) {
        this.sizeExpression = StringUtils.trimToNull((String)sizeExpression);
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double r) {
        this.rotation = r;
        this.setRotationExpression(null);
    }

    public Point2D getOffset() {
        if (this.offset == null) {
            this.offset = new Point();
        }
        return this.offset;
    }

    public void setOffset(Point2D offset) {
        this.offset = offset;
    }

    public double getSize() {
        return this.getLineWidth();
    }

    public void setSize(double size) {
        this.setSizeExpression(null);
        this.setLineWidth(size);
    }

    public IMask getMask() {
        return this.mask;
    }

    public void setMask(IMask mask) {
        this.mask = mask;
    }

    public String[] getRequiredFeatureAttributeNames(FeatureStore featureStore) throws DataException {
        FeatureType ftype = featureStore.getDefaultFeatureTypeQuietly();
        String[] res = new String[ftype.size()];
        int cont = 0;
        for (FeatureAttributeDescriptor attr : ftype) {
            res[cont++] = attr.getName();
        }
        return res;
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            manager.registerSymbol(PictureLineSymbol.PICTURE_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME, PictureLineSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(PictureLineSymbol.PICTURE_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(PictureLineSymbol.class, PictureLineSymbol.PICTURE_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME, "PictureLineSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("LineSymbol"));
                definition.addDynFieldBoolean(PictureLineSymbol.SELECTED).setMandatory(false);
                definition.addDynFieldObject(PictureLineSymbol.SELECTION_SYMBOL).setClassOfValue(PictureLineSymbol.class).setMandatory(false);
                definition.addDynFieldObject(PictureLineSymbol.BACKGROUND_IMAGE).setClassOfValue(BackgroundFileStyle.class).setMandatory(false);
                definition.addDynFieldObject(PictureLineSymbol.BACKGROUND_SELECTION_IMAGE).setClassOfValue(BackgroundFileStyle.class).setMandatory(false);
                definition.addDynFieldObject(PictureLineSymbol.WIDTH).setClassOfValue(Double.class).setMandatory(true);
                definition.addDynFieldString(PictureLineSymbol.FIELD_SIZE_EXPRESSION).setMandatory(false);
            }
            return Boolean.TRUE;
        }
    }
}

