/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.MarkerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.AbstractStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMarkerFillPropertiesStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class SimpleMarkerFillPropertiesStyle
extends AbstractStyle
implements IMarkerFillPropertiesStyle {
    public static final String SIMPLE_MARKER_FILL_STYLE_PERSISTENCE_DEFINITION_NAME = "SimpleMarkerFillPropertiesStyle";
    private static final String FIELD_SAMPLE_SYMBOL = "sampleSymbol";
    private static final String FIELD_ROTATION = "rotation";
    private static final String FIELD_XOFFSET = "xOffset";
    private static final String FIELD_YOFFSET = "yOffset";
    private static final String FIELD_XSEPARATION = "xSeparation";
    private static final String FIELD_YSEPARATION = "ySeparation";
    private static final String FIELD_FILL_STYLE = "fillStyle";
    private IMarkerSymbol sampleSymbol = SymbologyLocator.getSymbologyManager().createSimpleMarkerSymbol();
    private double rotation = 0.0;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double xSeparation = 20.0;
    private double ySeparation = 20.0;
    private int fillStyle = MarkerFillSymbol.DefaultFillStyle;

    public void drawInsideRectangle(Graphics2D g, Rectangle r) {
        BufferedImage bi;
        Rectangle rProv;
        block4: {
            int s = (int)this.sampleSymbol.getSize();
            rProv = new Rectangle();
            rProv.setFrame(0.0, 0.0, s, s);
            bi = new BufferedImage(s, s, 2);
            Graphics2D gAux = bi.createGraphics();
            try {
                this.sampleSymbol.drawInsideRectangle(gAux, gAux.getTransform(), rProv);
            }
            catch (SymbolDrawingException e) {
                if (e.getType() != 0) break block4;
                try {
                    IWarningSymbol warning = MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, "", 0);
                    warning.drawInsideRectangle(gAux, gAux.getTransform(), rProv);
                }
                catch (SymbolDrawingException symbolDrawingException) {
                    // empty catch block
                }
            }
        }
        TexturePaint resulPatternFill = new TexturePaint(bi, rProv);
        g.setColor(null);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(resulPatternFill);
        g.fill(r);
    }

    public boolean isSuitableFor(ISymbol symbol) {
        return symbol instanceof IFillSymbol;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void drawOutline(Graphics2D g, Rectangle r) {
        this.drawInsideRectangle(g, r);
    }

    public void setSampleSymbol(IMarkerSymbol marker) {
        if (marker != null) {
            this.sampleSymbol = marker;
        }
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(double offset) {
        this.xOffset = offset;
    }

    public double getXSeparation() {
        return this.xSeparation;
    }

    public void setXSeparation(double separation) {
        this.xSeparation = separation;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(double offset) {
        this.yOffset = offset;
    }

    public double getYSeparation() {
        return this.ySeparation;
    }

    public void setYSeparation(double separation) {
        this.ySeparation = separation;
    }

    public void setFillStyle(int fillStyle) {
        this.fillStyle = fillStyle;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SimpleMarkerFillPropertiesStyle copy = (SimpleMarkerFillPropertiesStyle)((Object)super.clone());
        if (this.sampleSymbol != null) {
            copy.sampleSymbol = (IMarkerSymbol)this.sampleSymbol.clone();
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setRotation(state.getDouble(FIELD_ROTATION));
        this.setXOffset(state.getDouble(FIELD_XOFFSET));
        this.setYOffset(state.getDouble(FIELD_YOFFSET));
        this.setXSeparation(state.getDouble(FIELD_XSEPARATION));
        this.setYSeparation(state.getDouble(FIELD_YSEPARATION));
        this.setFillStyle(state.getInt(FIELD_FILL_STYLE));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_ROTATION, this.getRotation());
        state.set(FIELD_XOFFSET, this.getXOffset());
        state.set(FIELD_YOFFSET, this.getYOffset());
        state.set(FIELD_XSEPARATION, this.getXSeparation());
        state.set(FIELD_YSEPARATION, this.getYSeparation());
        state.set(FIELD_FILL_STYLE, this.getFillStyle());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(SimpleMarkerFillPropertiesStyle.SIMPLE_MARKER_FILL_STYLE_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(SimpleMarkerFillPropertiesStyle.class, SimpleMarkerFillPropertiesStyle.SIMPLE_MARKER_FILL_STYLE_PERSISTENCE_DEFINITION_NAME, "SimpleMarkerFillPropertiesStyle Persistence definition", null, null);
                definition.extend(manager.getDefinition("Style"));
                definition.addDynFieldObject(SimpleMarkerFillPropertiesStyle.FIELD_SAMPLE_SYMBOL).setClassOfValue(IMarkerSymbol.class);
                definition.addDynFieldDouble(SimpleMarkerFillPropertiesStyle.FIELD_ROTATION).setMandatory(true);
                definition.addDynFieldDouble(SimpleMarkerFillPropertiesStyle.FIELD_XOFFSET).setMandatory(true);
                definition.addDynFieldDouble(SimpleMarkerFillPropertiesStyle.FIELD_YOFFSET).setMandatory(true);
                definition.addDynFieldDouble(SimpleMarkerFillPropertiesStyle.FIELD_XSEPARATION).setMandatory(true);
                definition.addDynFieldDouble(SimpleMarkerFillPropertiesStyle.FIELD_YSEPARATION).setMandatory(true);
                definition.addDynFieldInt(SimpleMarkerFillPropertiesStyle.FIELD_FILL_STYLE).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

