/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners.snapping.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.toolListeners.snapping.gui.DrawSnapCellRenderer;
import org.gvsig.app.project.documents.view.toolListeners.snapping.gui.PropertySnapCellEditor;
import org.gvsig.app.project.documents.view.toolListeners.snapping.gui.PropertySnapCellRenderer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapper;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class SnapConfig
extends JPanel {
    private static final long serialVersionUID = 3539711525292306297L;
    private JCheckBox jChkBoxRefentActive = null;
    private JTable jListSnappers = null;
    private JPanel jPanel = null;
    private JScrollPane jScrollPane = null;
    private JPanel jPanelTolerance = null;
    private JTextField jTxtTolerance = null;
    private JLabel jLabelTolerance = null;
    private JLabel jLabelTolerance1 = null;
    private static MapControlManager mapControlManager = MapControlLocator.getMapControlManager();

    public SnapConfig(MapControl mc) {
        this.initialize();
    }

    public SnapConfig(MapControl mc, MouseListener mouseListener) {
        this(mc);
        this.getJListSnappers().addMouseListener(mouseListener);
        this.getJChkBoxRefentActive().addMouseListener(mouseListener);
    }

    public SnapConfig(MouseListener mouseListener, KeyListener keyListener) {
        this(null, mouseListener);
        this.getJTxtTolerance().addKeyListener(keyListener);
    }

    private void initialize() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setSize(new Dimension(463, 239));
        this.setPreferredSize(new Dimension(463, 239));
        this.add((Component)this.getJChkBoxRefentActive(), "North");
        this.jLabelTolerance = new JLabel();
        this.jLabelTolerance.setText(i18nManager.getTranslation("snap_tolerance"));
        this.jLabelTolerance.setHorizontalAlignment(2);
        this.jLabelTolerance.setName("jLabel");
        this.jLabelTolerance.setBounds(new Rectangle(15, 8, 122, 15));
        this.jLabelTolerance.setPreferredSize(new Dimension(28, 20));
        this.jLabelTolerance.setHorizontalTextPosition(2);
        this.jLabelTolerance1 = new JLabel();
        this.jLabelTolerance1.setText(i18nManager.getTranslation("pixels"));
        this.jLabelTolerance1.setBounds(new Rectangle(195, 8, 207, 15));
        this.jLabelTolerance1.setPreferredSize(new Dimension(28, 20));
        this.jLabelTolerance1.setName("jLabel1");
        this.add((Component)this.getJPanelTolerance(), "South");
        this.add((Component)this.getJPanel(), "Center");
    }

    private JCheckBox getJChkBoxRefentActive() {
        if (this.jChkBoxRefentActive == null) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            this.jChkBoxRefentActive = new JCheckBox();
            this.jChkBoxRefentActive.setText(i18nManager.getTranslation("_Activate_reference_to_objects"));
            this.jChkBoxRefentActive.setBounds(new Rectangle(26, 10, 418, 23));
        }
        return this.jChkBoxRefentActive;
    }

    private JTextField getJTxtTolerance() {
        if (this.jTxtTolerance == null) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            if (this.jLabelTolerance == null) {
                this.jLabelTolerance = new JLabel();
                this.jLabelTolerance.setText(i18nManager.getTranslation("snap_tolerance"));
                this.jLabelTolerance.setHorizontalAlignment(2);
                this.jLabelTolerance.setName("jLabel");
                this.jLabelTolerance.setBounds(new Rectangle(15, 8, 122, 15));
                this.jLabelTolerance.setPreferredSize(new Dimension(28, 20));
                this.jLabelTolerance.setHorizontalTextPosition(2);
            }
            if (this.jLabelTolerance1 == null) {
                this.jLabelTolerance1 = new JLabel();
                this.jLabelTolerance1.setText(i18nManager.getTranslation("pixels"));
                this.jLabelTolerance1.setBounds(new Rectangle(195, 8, 207, 15));
                this.jLabelTolerance1.setPreferredSize(new Dimension(28, 20));
                this.jLabelTolerance1.setName("jLabel1");
            }
            this.jTxtTolerance = new JTextField();
            this.jTxtTolerance.setPreferredSize(new Dimension(28, 20));
            this.jTxtTolerance.setName("jTxtTolerance");
            this.jTxtTolerance.setHorizontalAlignment(4);
            this.jTxtTolerance.setBounds(new Rectangle(142, 8, 39, 15));
        }
        return this.jTxtTolerance;
    }

    private JPanel getJPanelTolerance() {
        if (this.jPanelTolerance == null) {
            this.jPanelTolerance = new JPanel();
            this.jPanelTolerance.setLayout(null);
            this.jPanelTolerance.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.jPanelTolerance.setPreferredSize(new Dimension(30, 30));
            this.jPanelTolerance.add((Component)this.jLabelTolerance, null);
            this.jPanelTolerance.add((Component)this.getJTxtTolerance(), null);
            this.jPanelTolerance.add((Component)this.jLabelTolerance1, null);
        }
        return this.jPanelTolerance;
    }

    private JTable getJListSnappers() {
        if (this.jListSnappers == null) {
            this.jListSnappers = new JTable();
        }
        return this.jListSnappers;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
            this.jPanel.setBounds(new Rectangle(19, 40, 423, 181));
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(new Rectangle(9, 9, 402, 163));
            this.jScrollPane.setViewportView(this.getJListSnappers());
        }
        return this.jScrollPane;
    }

    public void setSnappers() {
        MyTableModel listModel = new MyTableModel();
        this.getJListSnappers().setModel(listModel);
        TableColumn tc = this.getJListSnappers().getColumnModel().getColumn(0);
        this.setUpSymbolColumn(this.getJListSnappers().getColumnModel().getColumn(1));
        this.setUpPropertyColumn(this.getJListSnappers().getColumnModel().getColumn(4));
        this.getJListSnappers().setCellSelectionEnabled(false);
        tc.setMaxWidth(40);
        tc.setMinWidth(20);
    }

    public TableModel getTableModel() {
        return this.getJListSnappers().getModel();
    }

    public boolean applySnappers() {
        return this.getJChkBoxRefentActive().isSelected();
    }

    public void selectSnappers() {
        for (int i = 0; i < mapControlManager.getSnapperCount(); ++i) {
            this.getTableModel().setValueAt(mapControlManager.getSnapperAt(i).isEnabled(), i, 0);
        }
    }

    public Integer getSnapTolerance() {
        return Integer.valueOf(this.getJTxtTolerance().getText());
    }

    public void setSnapTolerance(Integer snapTolerance) {
        this.getJTxtTolerance().setText(snapTolerance.toString());
    }

    public void setApplySnappers(boolean applySnappers) {
        this.getJChkBoxRefentActive().setSelected(applySnappers);
    }

    public void setUpSymbolColumn(TableColumn column) {
        DrawSnapCellRenderer symbolCellRenderer = new DrawSnapCellRenderer();
        column.setCellRenderer(symbolCellRenderer);
    }

    public void setUpPropertyColumn(TableColumn column) {
        PropertySnapCellEditor propertyeditor = new PropertySnapCellEditor();
        column.setCellEditor(propertyeditor);
        PropertySnapCellRenderer renderer = new PropertySnapCellRenderer();
        column.setCellRenderer(renderer);
    }

    class MyCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ISnapper snapper = (ISnapper)value;
            String s = snapper.getToolTipText();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }

        @Override
        public void doClick() {
            super.doClick();
            System.out.println("Click");
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 6262877908586753756L;

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return mapControlManager.getSnapperCount();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 3;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ISnapper snap = mapControlManager.getSnapperAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    snap.setEnabled(((Boolean)aValue).booleanValue());
                    break;
                }
                case 3: {
                    snap.setPriority(((Integer)aValue).intValue());
                }
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ISnapper snap = mapControlManager.getSnapperAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return snap.isEnabled();
                }
                case 1: {
                    return snap.getClass().getName();
                }
                case 2: {
                    return snap.getToolTipText();
                }
                case 3: {
                    return snap.getPriority();
                }
                case 4: {
                    return new JButton();
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return JButton.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PluginServices.getText((Object)this, (String)"aplicar");
                }
                case 1: {
                    return PluginServices.getText((Object)this, (String)"simbolo");
                }
                case 2: {
                    return PluginServices.getText((Object)this, (String)"tipo");
                }
                case 3: {
                    return PluginServices.getText((Object)this, (String)"prioridad");
                }
                case 4: {
                    return PluginServices.getText((Object)this, (String)"propiedades");
                }
            }
            return null;
        }
    }
}

