/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermLengthOrPercent;
import java.awt.Graphics2D;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.VisualContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TableCaptionBox
extends BlockBox {
    private static Logger log = LoggerFactory.getLogger(TableCaptionBox.class);

    public TableCaptionBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
    }

    public TableCaptionBox(InlineBox src) {
        super(src);
        this.isblock = true;
    }

    @Override
    protected void computeWidthsInFlow(TermLengthOrPercent width, boolean auto, boolean exact, int contw, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (width == null) {
            auto = true;
        }
        if (this.cblock == null && this.cblock.getContainingBlock() != null) {
            log.debug(this.toString() + " has no cblock");
            return;
        }
        contw = this.cblock.getContainingBlock().getContentWidth();
        boolean mleftauto = this.style.getProperty("margin-left") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mleft = this.getLengthValue("margin-left");
        boolean mrightauto = this.style.getProperty("margin-right") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mright = this.getLengthValue("margin-right");
        this.preferredWidth = -1;
        if (!this.widthComputed) {
            update = false;
        }
        if (auto) {
            if (exact) {
                this.wset = false;
            }
            this.margin.left = dec.getLength(mleft, mleftauto, 0, 0, contw);
            this.margin.right = dec.getLength(mright, mrightauto, 0, 0, contw);
            this.declMargin.left = this.margin.left;
            this.declMargin.right = this.margin.right;
            if (!update || this.isInFlow()) {
                this.content.width = contw - this.margin.left - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.right;
                if (this.content.width < 0) {
                    this.content.width = 0;
                }
            }
            this.preferredWidth = -1;
        } else {
            int prefmr;
            if (exact) {
                this.wset = true;
                this.wrelative = width.isPercentage();
            }
            this.content.width = dec.getLength(width, auto, 0, 0, contw);
            this.margin.left = dec.getLength(mleft, mleftauto, 0, 0, contw);
            this.margin.right = dec.getLength(mright, mrightauto, 0, 0, contw);
            this.declMargin.left = this.margin.left;
            this.declMargin.right = this.margin.right;
            boolean prefer = !width.isPercentage();
            int prefml = mleft == null || mleft.isPercentage() || mleftauto ? 0 : this.margin.left;
            int n = prefmr = mright == null || mright.isPercentage() || mrightauto ? 0 : this.margin.right;
            if (prefer) {
                this.preferredWidth = prefml + this.border.left + this.padding.left + this.content.width + this.padding.right + this.border.right + prefmr;
            }
            if (this.isInFlow() && prefer) {
                if (mleftauto && mrightauto) {
                    int rest = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right;
                    if (rest < 0) {
                        rest = 0;
                    }
                    this.margin.left = (rest + 1) / 2;
                    this.margin.right = rest / 2;
                } else if (mleftauto) {
                    this.margin.left = contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.right;
                } else {
                    this.margin.right = mrightauto ? contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.left : contw - this.content.width - this.border.left - this.padding.left - this.padding.right - this.border.right - this.margin.left;
                }
            }
        }
    }
}

