/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.parser.v2.coordiates;

import java.io.IOException;
import java.util.StringTokenizer;
import org.gvsig.compat.CompatLocator;
import org.gvsig.gpe.prov.gml.parser.GPEDefaultGmlParser;
import org.gvsig.gpe.prov.gml.parser.v2.coordiates.GmlCoodinatesIterator;
import org.gvsig.gpe.prov.gml.parser.v2.geometries.DoubleTypeBinding;
import org.gvsig.gpe.prov.gml.utils.GmlTags;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class CoordinatesTypeIterator
extends GmlCoodinatesIterator {
    private StringTokenizer coordinatesString = null;

    @Override
    public void initialize(IXmlStreamReader parser, GPEDefaultGmlParser handler, IQName lastTag) throws XmlStreamException, IOException {
        super.initialize(parser, handler, lastTag);
        boolean endFeature = false;
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        while (!endFeature) {
            switch (currentTag) {
                case 1: {
                    if (!handler.getQNameComparator().equals(tag, GmlTags.GML_COORDINATES)) break;
                    parser.next();
                    String coordinatesTag = parser.getText().trim();
                    if (this.dimension == -1) {
                        this.dimension = this.caculateDimension(coordinatesTag);
                    }
                    this.coordinatesString = new StringTokenizer(coordinatesTag, this.TUPLES_SEPARATOR);
                    this.parseAll();
                    return;
                }
                case 2: {
                    if (!handler.getQNameComparator().equals(tag, GmlTags.GML_COORDINATES)) break;
                    endFeature = true;
                    break;
                }
            }
            if (endFeature) continue;
            currentTag = parser.next();
            tag = parser.getName();
        }
    }

    private int caculateDimension(String coordinatesTag) {
        StringTokenizer st = new StringTokenizer(coordinatesTag, this.TUPLES_SEPARATOR);
        String firstPair = st.hasMoreTokens() ? st.nextToken() : coordinatesTag;
        return CompatLocator.getStringUtils().split(firstPair, this.COORDINATES_SEPARATOR).length;
    }

    public boolean hasNext() throws IOException {
        return this.coordinatesString.hasMoreTokens();
    }

    public void next(double[] buffer) throws IOException {
        String next = this.coordinatesString.nextToken();
        String[] coordinates = CompatLocator.getStringUtils().split(next.trim(), this.COORDINATES_SEPARATOR);
        for (int i = 0; i < coordinates.length; ++i) {
            buffer[i] = DoubleTypeBinding.parse(coordinates[i], this.COORDINATES_DECIMAL, this.handler);
        }
    }
}

