/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Hashtable;

public final class OracleNumberFormat
extends Format {
    private static final String PATTERN_EXCEPTION = "Wrong pattern";
    public static final String NOT_IMPLIMENTED_EXCEPTION = "Not implimented";
    static final char DOT = '.';
    static final char GROUP = ' ';
    private static final Hashtable<String, FORMAT> formatsCache = new Hashtable();
    private FORMAT format = null;

    public OracleNumberFormat(String string) throws ParseException {
        this.format = formatsCache.get(string);
        if (this.format == null) {
            this.format = OracleNumberFormat.compilePattern(string);
            formatsCache.put(string, this.format);
        }
    }

    public String toString() {
        return this.format != null ? this.format.toString() : "null";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OracleNumberFormat oracleNumberFormat = (OracleNumberFormat)object;
        return this.format != null ? this.format.equals(oracleNumberFormat.format) : false;
    }

    private static FORMAT compilePattern(String string) throws ParseException {
        String string2;
        int n;
        if (string == null) {
            throw new ParseException(PATTERN_EXCEPTION, 0);
        }
        if (string.equals("RN") || string.equals("rn")) {
            throw new ParseException(NOT_IMPLIMENTED_EXCEPTION, 0);
        }
        FORMAT fORMAT = new FORMAT();
        if (string.length() == 0) {
            return fORMAT;
        }
        char c = (string = string.toUpperCase()).charAt(0);
        boolean bl = c == '0' || c == '9';
        int n2 = string.length();
        if (!bl) {
            for (n = 1; n < n2 && (c = string.charAt(n)) != '0' && c != '9'; ++n) {
            }
            string2 = string.substring(0, n);
        } else {
            string2 = "";
            n = 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        while (n < n2) {
            c = string.charAt(n);
            bl2 = true;
            if (c == 'G') {
                if (bl4 && !fORMAT.localGroups) {
                    throw new ParseException(PATTERN_EXCEPTION, 0);
                }
                bl4 = true;
                fORMAT.localGroups = true;
                bl2 = false;
                stringBuilder.append('G');
            } else if (c == ',') {
                if (bl4 && fORMAT.localGroups) {
                    throw new ParseException(PATTERN_EXCEPTION, n);
                }
                bl4 = true;
                fORMAT.localGroups = true;
                bl2 = false;
                stringBuilder.append('G');
            } else if (bl3) {
                if (c == '0') {
                    stringBuilder.append('0');
                    ++fORMAT.digits;
                    bl2 = false;
                } else if (c == '9') {
                    bl2 = false;
                    bl3 = false;
                    fORMAT.firstNine = stringBuilder.length();
                    stringBuilder.append('9');
                    ++fORMAT.digits;
                }
            } else if (c == '0' || c == '9') {
                bl2 = false;
                stringBuilder.append('9');
                ++fORMAT.digits;
            }
            if (bl2) break;
            ++n;
        }
        if (bl3) {
            fORMAT.firstNine = stringBuilder.length();
        }
        if (c == 'V') {
            ++n;
            while (n < n2 && ((c = string.charAt(n)) == '0' || c == '9')) {
                ++n;
                ++fORMAT.v;
            }
        } else if (c == '.' || c == 'D') {
            if (bl4) {
                if (fORMAT.localGroups && c == '.' || !fORMAT.localGroups && c == 'D') {
                    throw new ParseException(PATTERN_EXCEPTION, n);
                }
            } else {
                fORMAT.localGroups = c == 'D';
            }
            ++n;
            while (n < n2 && ((c = string.charAt(n)) == '0' || c == '9')) {
                ++n;
                ++fORMAT.dot;
            }
        }
        fORMAT.numbers = stringBuilder.toString();
        if (n == string2.length()) {
            throw new ParseException(PATTERN_EXCEPTION, n);
        }
        String string3 = string.substring(n);
        int n3 = 0;
        if (string3.startsWith("EEEE")) {
            fORMAT.sci = true;
            n3 = 4;
        }
        if (string3.startsWith("S", n3)) {
            fORMAT.sign = SIGN._S;
            ++n3;
        } else if (string3.startsWith("MI", n3)) {
            fORMAT.sign = SIGN.MI;
            n3 += 2;
        } else if (string3.startsWith("PR", n3)) {
            fORMAT.sign = SIGN.PR;
            n3 += 2;
        }
        if (n3 < string3.length()) {
            throw new ParseException(PATTERN_EXCEPTION, n);
        }
        int n4 = 0;
        if (fORMAT.sign == SIGN.DEFAULT && string2.startsWith("S")) {
            fORMAT.sign = SIGN.S_;
            ++n4;
        }
        if (string2.startsWith("FM", n4)) {
            fORMAT.fm = true;
            n4 += 2;
        }
        if (string2.startsWith("B", n4)) {
            fORMAT.b = true;
            ++n4;
        }
        if (fORMAT.sign == SIGN.DEFAULT && string2.startsWith("S", n4)) {
            fORMAT.sign = SIGN.S_;
            ++n3;
        }
        if (string2.startsWith("$", n4)) {
            fORMAT.cur = CURRENCY.DOLLARS;
            ++n4;
        } else if (string2.startsWith("L", n4)) {
            fORMAT.cur = CURRENCY.LOCAL;
            ++n4;
        } else if (string2.startsWith("C", n4)) {
            fORMAT.cur = CURRENCY.ISO;
            ++n4;
        }
        if (n4 < string2.length()) {
            throw new ParseException(PATTERN_EXCEPTION, 0);
        }
        return fORMAT;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Number) {
            BigDecimal bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : (object instanceof Double || object instanceof Float ? new BigDecimal(((Number)object).doubleValue()) : new BigDecimal(((Number)object).longValue()));
            if (this.format.sci) {
                int n;
                int n2 = bigDecimal.unscaledValue().abs().toString().toCharArray().length;
                int n3 = bigDecimal.scale();
                this.format.getPrefix(stringBuffer, bigDecimal);
                bigDecimal = new BigDecimal(bigDecimal.unscaledValue(), n2 - 1);
                bigDecimal = bigDecimal.setScale(this.format.dot + this.format.v, 6);
                char[] cArray = bigDecimal.unscaledValue().abs().toString().toCharArray();
                if (cArray.length > 1 + this.format.v) {
                    stringBuffer.append(cArray, 0, 1 + this.format.v);
                    if (cArray.length > 1) {
                        stringBuffer.append('.');
                        stringBuffer.append(cArray, 1 + this.format.v, cArray.length - 1);
                    }
                } else {
                    stringBuffer.append(cArray);
                    for (n = 0; n < this.format.v + 1 - cArray.length; ++n) {
                        stringBuffer.append('0');
                    }
                }
                n = n2 - n3 - 1;
                stringBuffer.append('E');
                stringBuffer.append(n >= 0 ? (char)'+' : '-');
                String string = Integer.toString(Math.abs(n));
                if (string.length() == 1) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
                this.format.getSuffix(stringBuffer, bigDecimal);
            } else if (this.format.b && bigDecimal.signum() == 0) {
                if (!this.format.fm) {
                    for (int i = 0; i < this.format.numbers.length() + this.format.v + 1; ++i) {
                        stringBuffer.append(' ');
                    }
                }
            } else if (bigDecimal.precision() - bigDecimal.scale() > this.format.digits) {
                for (int i = 0; i < this.format.numbers.length() + this.format.v + 1; ++i) {
                    stringBuffer.append('#');
                }
            } else {
                int n;
                this.format.getPrefix(stringBuffer, bigDecimal);
                int n4 = bigDecimal.scale();
                int n5 = this.format.digits;
                if (this.format.v > 0 && n4 > 0) {
                    int n6;
                    if (this.format.v > n4) {
                        n6 = 0;
                        this.format.v -= n4;
                    } else {
                        n6 = n4 - this.format.v;
                        this.format.v = 0;
                    }
                    n5 += n4;
                    bigDecimal = new BigDecimal(bigDecimal.unscaledValue(), n6);
                }
                char[] cArray = bigDecimal.unscaledValue().abs().toString().toCharArray();
                int n7 = cArray.length;
                if (this.format.dot < bigDecimal.scale()) {
                    bigDecimal = bigDecimal.setScale(this.format.dot, 6);
                    cArray = bigDecimal.unscaledValue().abs().toString().toCharArray();
                    n7 = cArray.length;
                }
                int n8 = 0;
                int n9 = n7 - bigDecimal.scale();
                boolean bl = false;
                int n10 = 0;
                int n11 = this.format.numbers.length();
                for (n = 0; n < n11; ++n) {
                    if (this.format.numbers.charAt(n) == 'G') {
                        stringBuffer.append(' ');
                        continue;
                    }
                    if (n10 < n5 - n9) {
                        if (this.format.firstNine != 0) {
                            stringBuffer.append('0');
                            bl = true;
                        } else if (!this.format.fm) {
                            stringBuffer.append(' ');
                        }
                        ++n10;
                        continue;
                    }
                    stringBuffer.append(cArray[n8++]);
                    bl = true;
                    ++n10;
                }
                while (n8 < cArray.length) {
                    stringBuffer.append(cArray[n8]);
                    ++n8;
                }
                for (n = 0; n < this.format.v; ++n) {
                    stringBuffer.append('0');
                }
                if (this.format.dot > 0) {
                    stringBuffer.append('.');
                }
                for (n = 0; n < this.format.dot; ++n) {
                    if (n < bigDecimal.scale()) {
                        stringBuffer.append(cArray[n9 + n]);
                        continue;
                    }
                    stringBuffer.append('0');
                }
                this.format.getSuffix(stringBuffer, bigDecimal);
            }
        }
        return stringBuffer;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object parseObject(String string, ParsePosition parsePosition) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(parsePosition != null ? string.substring(parsePosition.getIndex()) : string);
        try {
            void var14_22;
            int n2;
            int n3;
            boolean bl = false;
            int n4 = stringBuilder.length();
            for (n = 0; n < n4 && stringBuilder.charAt(n) == ' '; ++n) {
            }
            if (this.format.sign == SIGN.PR) {
                if (stringBuilder.charAt(n) == '<' && stringBuilder.charAt(n4 - 1) == '>') {
                    stringBuilder.setCharAt(n++, ' ');
                    stringBuilder.setLength(--n4);
                    bl = true;
                }
            } else if (this.format.sign == SIGN.MI) {
                if (stringBuilder.charAt(n4 - 1) == '-') {
                    stringBuilder.setLength(--n4);
                    bl = true;
                }
            } else if (this.format.sign == SIGN._S) {
                n3 = stringBuilder.charAt(n4 - 1);
                if (n3 == 45) {
                    stringBuilder.setLength(--n4);
                    bl = true;
                } else {
                    if (n3 != 43) {
                        parsePosition.setErrorIndex(n);
                        return null;
                    }
                    stringBuilder.setLength(--n4);
                }
            } else if (this.format.sign == SIGN.S_) {
                n3 = stringBuilder.charAt(n);
                if (n3 == 45) {
                    stringBuilder.setCharAt(n++, ' ');
                    bl = true;
                } else {
                    if (n3 != 43) {
                        parsePosition.setErrorIndex(n);
                        return null;
                    }
                    stringBuilder.setCharAt(n++, ' ');
                }
            } else if (this.format.sign == SIGN.DEFAULT) {
                n3 = stringBuilder.charAt(n);
                if (n3 == 45) {
                    stringBuilder.setCharAt(n++, ' ');
                    bl = true;
                } else if (n3 == 43) {
                    stringBuilder.setCharAt(n++, ' ');
                }
            }
            while (n < n4 && stringBuilder.charAt(n) == ' ') {
                ++n;
            }
            n3 = stringBuilder.indexOf("E");
            if (n3 == -1) {
                n3 = stringBuilder.indexOf("e");
            }
            int n5 = string.indexOf(46);
            int n6 = n4 - n;
            if (bl) {
                ++n6;
            }
            char[] cArray = new char[n6];
            int n7 = 0;
            int n8 = 0;
            if (bl) {
                ++n8;
                cArray[0] = 45;
            }
            if (this.format.sci) {
                if (this.format.numbers.length() == 0 || this.format.numbers.indexOf(71) != -1) {
                    parsePosition.setErrorIndex(n);
                    return null;
                }
                if (n3 == -1) {
                    parsePosition.setErrorIndex(n);
                    return null;
                }
                cArray[n8++] = stringBuilder.charAt(n);
                n7 = -Integer.valueOf(stringBuilder.substring(n3 + 1)).intValue();
                if (n5 == -1) {
                    if (n + 1 != n3) {
                        parsePosition.setErrorIndex(n);
                        return null;
                    }
                } else {
                    if (this.format.dot < n3 - n5 - 1) {
                        parsePosition.setErrorIndex(n5);
                        return null;
                    }
                    if (n + 1 != n5) {
                        parsePosition.setErrorIndex(n);
                        return null;
                    }
                    n7 += n3 - n5 - 1;
                    for (n2 = n5 + 1; n2 < n3; ++n2) {
                        cArray[n8++] = stringBuilder.charAt(n2);
                    }
                }
            } else {
                if (n3 >= 0) {
                    parsePosition.setErrorIndex(n3);
                    return null;
                }
                if (n5 != -1) {
                    --n6;
                    n7 = n4 - n5 - 1;
                    if (this.format.dot < n7) {
                        parsePosition.setErrorIndex(n5);
                        return null;
                    }
                }
                try {
                    void var14_18;
                    n2 = n5 < 0 ? n4 : n5;
                    int n9 = this.format.numbers.length() - 1;
                    for (int i = n; i < n2; ++i, --var14_18) {
                        char c = stringBuilder.charAt(i);
                        if (this.format.numbers.charAt((int)var14_18) == 'G') {
                            if (c == ' ') continue;
                            parsePosition.setErrorIndex(i);
                            return null;
                        }
                        if (!Character.isDigit(c)) {
                            parsePosition.setErrorIndex(i);
                            return null;
                        }
                        cArray[n8++] = c;
                    }
                }
                catch (Exception exception) {
                    parsePosition.setErrorIndex(n);
                    exception.printStackTrace();
                    return null;
                }
                if (n5 != -1) {
                    for (n2 = n5 + 1; n2 < n4; ++n2) {
                        char c = stringBuilder.charAt(n2);
                        if (!Character.isDigit(c)) {
                            parsePosition.setErrorIndex(n2);
                            return null;
                        }
                        cArray[n8++] = c;
                    }
                }
            }
            String string2 = new String(cArray, 0, n8);
            if (n7 == 0 && n8 < 10) {
                Integer n10 = new Integer(Integer.valueOf(string2));
            } else {
                BigDecimal bigDecimal = new BigDecimal(new BigInteger(string2), n7);
            }
            parsePosition.setIndex(n4);
            return var14_22;
        }
        catch (Exception exception) {
            parsePosition.setErrorIndex(n);
            exception.printStackTrace();
            return null;
        }
    }

    private static class FORMAT {
        boolean sci;
        boolean localGroups = true;
        String numbers = "";
        int digits = 0;
        int firstNine = -1;
        SIGN sign = SIGN.DEFAULT;
        boolean fm = false;
        boolean b = false;
        CURRENCY cur = CURRENCY.NON;
        int v = 0;
        int dot = 0;

        private FORMAT() {
        }

        public void getPrefix(StringBuffer stringBuffer, BigDecimal bigDecimal) {
            if (this.sci && !this.fm) {
                stringBuffer.append(' ');
            }
            if (bigDecimal.signum() == 1) {
                if (this.sign == SIGN.S_) {
                    stringBuffer.append('+');
                } else if (!this.fm && this.sign != SIGN._S && this.sign != SIGN.MI) {
                    stringBuffer.append(' ');
                }
            } else if (bigDecimal.signum() == -1) {
                if (this.sign == SIGN.PR) {
                    stringBuffer.append('<');
                } else if (this.sign != SIGN._S && this.sign != SIGN.MI) {
                    stringBuffer.append('-');
                }
            } else if (!this.fm) {
                stringBuffer.append(' ');
            }
            if (this.cur == CURRENCY.DOLLARS) {
                stringBuffer.append("$");
            } else if (this.cur == CURRENCY.ISO) {
                stringBuffer.append("RUR");
            }
        }

        public void getSuffix(StringBuffer stringBuffer, BigDecimal bigDecimal) {
            if (this.cur == CURRENCY.LOCAL) {
                stringBuffer.append("\ufffd\ufffd\ufffd");
            }
            if (bigDecimal.signum() == 1) {
                if (this.sign == SIGN._S) {
                    stringBuffer.append('+');
                } else if (this.sign == SIGN.MI) {
                    stringBuffer.append(' ');
                }
            } else if (bigDecimal.signum() == -1) {
                if (this.sign == SIGN.PR) {
                    stringBuffer.append('>');
                } else if (this.sign == SIGN.MI || this.sign == SIGN._S) {
                    stringBuffer.append('-');
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.sign == SIGN.S_) {
                stringBuilder.append('S');
            }
            if (this.fm) {
                stringBuilder.append("FM");
            }
            if (this.b) {
                stringBuilder.append('B');
            }
            if (this.cur == CURRENCY.DOLLARS) {
                stringBuilder.append('$');
            } else if (this.cur == CURRENCY.LOCAL) {
                stringBuilder.append('L');
            } else if (this.cur == CURRENCY.ISO) {
                stringBuilder.append('C');
            }
            stringBuilder.append(this.numbers);
            if (this.dot > 0) {
                stringBuilder.append('D');
                for (int i = 0; i < this.dot; ++i) {
                    stringBuilder.append('9');
                }
            } else if (this.v > 0) {
                stringBuilder.append('V');
                for (int i = 0; i < this.v; ++i) {
                    stringBuilder.append('9');
                }
            }
            if (this.sci) {
                stringBuilder.append("EEEE");
            }
            if (this.sign == SIGN._S) {
                stringBuilder.append('S');
            } else if (this.sign == SIGN.MI) {
                stringBuilder.append("MI");
            }
            return stringBuilder.toString();
        }

        public boolean equals(Comparable comparable) {
            if (comparable == null) {
                return false;
            }
            FORMAT fORMAT = (FORMAT)((Object)comparable);
            return this.sci == fORMAT.sci && this.localGroups == fORMAT.localGroups && this.numbers.equals(fORMAT.numbers) && this.digits == fORMAT.digits && this.firstNine == fORMAT.firstNine && this.sign == fORMAT.sign && this.fm == fORMAT.fm && this.b == fORMAT.b && this.cur == fORMAT.cur && this.v == fORMAT.v && this.dot == fORMAT.dot;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CURRENCY {
        NON,
        DOLLARS,
        LOCAL,
        ISO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SIGN {
        DEFAULT,
        MI,
        _S,
        S_,
        PR;

    }
}

