/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.programming.BreakFunction;
import org.gvsig.expressionevaluator.impl.function.programming.ReturnFunction;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class ForFunction
extends AbstractFunction {
    public static final String NAME = "FOR";

    public ForFunction() {
        super("Programming", NAME, Range.is((Comparable)Integer.valueOf(4)), "The for() function evaluate body and incr while the condition is true.", "FOR( init, condition, incr, body )", null, "Object", false);
    }

    public boolean isHidden() {
        return true;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        int argn = 1;
        Object body = null;
        Object init = this.getObject(interpreter, args, 0);
        boolean condition = this.getBoolean(interpreter, args, 1);
        while (condition) {
            try {
                body = this.getObject(interpreter, args, 3);
            }
            catch (BreakFunction.BreakException ex) {
                break;
            }
            catch (ReturnFunction.ReturnException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String stmt = "unknown";
                try {
                    stmt = Objects.toString(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.warn("Error in for function calling arg " + argn + ", " + stmt, (Throwable)ex);
                throw ex;
            }
            ++argn;
            Object incr = this.getObject(interpreter, args, 2);
            condition = this.getBoolean(interpreter, args, 1);
        }
        return body;
    }
}

