/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.string;

import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class ConcatFunction
extends AbstractFunction {
    public ConcatFunction() {
        super("String", "CONCAT", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (Object arg : args) {
            if (arg == null) continue;
            builder.append(Objects.toString(arg, ""));
        }
        return builder.toString();
    }
}

